<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");


global  $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$coprimeUserFlag = false;
$stm = $db->prepare("SELECT coprime_user FROM Admin WHERE id='".$_SESSION['adminID']."'");
$stm->execute();
$stm->bind_result($coprimeUser);
while ($stm->fetch()) {
    $coprimeUser = strtolower($coprimeUser);
}
$stm->close();

if(strcmp($coprimeUser, "yes") == 0) {
    $coprimeUserFlag = true;
}

if(!$coprimeUserFlag) {
    http_response_code(403);
    exit;
}



if(!isset($_POST['apkVersion']) || !isset($_POST['apkForceUpdate'])){
    echo "Missing required fields";
    return;
}
$version = intval($_POST['apkVersion']);
$forceUpdate = trim($_POST['apkForceUpdate']);

if(empty($version) || empty($forceUpdate)){
    echo "Fields cannot be empty";
    return;
}



if (!empty($_FILES['apkFile']['name'])) {
    $fileName = basename($_FILES['apkFile']['name']);
    $fileType = pathinfo($fileName, PATHINFO_EXTENSION);
    $fileSize = $_FILES['apkFile']['size'];

    if (strtolower($fileType) !== 'apk') {
        echo "Invalid file type.";
        return;
    }


    if ($fileSize > 300 * 1024 * 1024) { // 300MB in bytes
        echo "File is too large.";
        return;
    }

    $uploadFilePath = $_SERVER['DOCUMENT_ROOT'] . "/" . $fileName;
    $url = "https://" . HTML_PATH ."/". $fileName;

    if (!move_uploaded_file($_FILES['apkFile']['tmp_name'], $uploadFilePath)) {
        echo "Error saving the file";
        return;
    }
}
else{
    echo "No file uploaded";
    return;
}


$stm = $db->prepare("SELECT MAX(id) FROM ApksPurchasing ");
$stm->execute();
$stm->bind_result($maxID);
$stm->fetch();
$stm->close();

$nextID = intval($maxID) + 1;


$stmt = $db->prepare("INSERT INTO ApksPurchasing  (id, version, url, force_update, timestamp) VALUES(?,?,?,?,NOW())");
$stmt->bind_param('isss', $nextID, $version, $url, $forceUpdate);
if ($stmt->execute()) {
    echo "success";
} else {
    echo "error";
}
$stmt->close();




?>
