<?php
include_once("../../../../param.php");

$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$barcodeSchemaCode = trim($_POST['barcodeSchemaCode']);
$barcodeSchemaText = trim($_POST['barcodeSchemaText']);
$prefix = trim($_POST['prefix']);
$codeStart = trim($_POST['codeStart']);
$codeEnd = trim($_POST['codeEnd']);
$qtyStart = trim($_POST['qtyStart']);
$qtyEnd = trim($_POST['qtyEnd']);
$priceStart = trim($_POST['priceStart']);
$priceEnd = trim($_POST['priceEnd']);
$qtyFactor = trim($_POST['qtyFactor']);
$priceFactor = trim($_POST['priceFactor']);

if(empty($barcodeSchemaCode)) {
    echo "emptyFields";
    return;
}


$stm = $db->prepare("SELECT barcode_schema_code FROM Barcode_Schema WHERE barcode_schema_code = ?");
$stm->bind_param("s", $barcodeSchemaCode);
$stm->execute();
$stm->bind_result($existingCode);
$stm->fetch();
$stm->close();

if ($existingCode) {
    echo "existingCode";
    exit();
}

$stm = $db->prepare("SELECT MAX(barcode_schema_id) as max_id FROM Barcode_Schema");
$stm->execute();
$stm->bind_result($maxId);
$stm->fetch();
$stm->close();

if($maxId === null){
    $newId = 1;
}
else{
    $newId = $maxId + 1;
}

$stm = $db->prepare("INSERT INTO Barcode_Schema (barcode_schema_id, barcode_schema_code, barcode_schema_text, prefix, code_start, code_end, qty_start, qty_end, price_start, price_end, qty_factor, price_factor, timestamp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
$stm->bind_param("isssiiiiiiid", $newId, $barcodeSchemaCode, $barcodeSchemaText, $prefix, $codeStart, $codeEnd, $qtyStart, $qtyEnd, $priceStart, $priceEnd, $qtyFactor, $priceFactor);
if ($stm->execute()) {
    echo "success";
} else {
    echo "error";
}

$stm->close();
$db->close();
?>