<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$draftID            = trim(''.$_POST['invoiceID']);
$companyID          = $_SESSION['companyID'];
$customerID         = trim(''.$_POST['customerID']);
$deliveryAddress    = trim(''.$_POST['deliveryAddress']);
$billingAddress     = trim(''.$_POST['billingAddress']);
$invoiceType        = trim(''.$_POST['invoiceType']);
$invoiceDate        = trim(''.$_POST['invoiceDate']);
$serviceCallID      = trim(''.$_POST['serviceCallID']);
$orderID            = trim(''.$_POST['orderID']);
$waybillID          = trim(''.$_POST['waybillID']);
$currencyID         = trim(''.$_POST['currencyID']);
$paymentMethod      = trim(''.$_POST['paymentMethod']);
$salespersonSearch  = trim(''.$_POST['salespersonSearch']);
$warehouseSearch    = trim(''.$_POST['warehouseSearch']);
$subtotal           = trim(''.$_POST['subtotal']);
$discount           = trim(''.$_POST['discount']);
$vatTotal           = trim(''.$_POST['vatTotal']);
$grandTotal         = trim(''.$_POST['grandTotal']);
$details            = trim(''.$_POST['details']);
$dueDate            = trim(''.$_POST['dueDate']);

$invoiceItems       = array();
$invoiceItems         = json_decode($_POST['invoiceItems'], true);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($invoiceDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $invoiceDate);
        $invoiceDate = $date->format('Y-m-d');
    }

    if (isset($dueDate) and strcmp($dueDate, "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $dueDate);
        $dueDate = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }

    if (strcmp($invoiceType, 'Cash') == 0) {
        $status = "Paid";
    } else {
        $status = "Not Paid";
    }

    $invoiceID   = getNextKeySingleTransaction("Invoices", "invoice_id", $db);
    $invoiceCode = getNextCodeSingleTransaction("Invoices", "invoice_code", "I", "CLOUD", $db);

    if (strcmp($invoiceCode, '') == 0) {
        $invoiceCode = getNextInvoiceCode("CLOUD", $db);
    }

    if (isset($orderID) && $orderID > 0){
        $stmt = $db->prepare("SELECT order_code FROM Orders WHERE order_id='$orderID'");
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->bind_result($orderCode);
        while ($stmt->fetch()) {}
        $stmt->close();
    }

    if (isset($waybillID) && $waybillID > 0){
        $stmt = $db->prepare("SELECT order_code FROM Orders WHERE order_id='$orderID'");
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->bind_result($waybillCode);
        while ($stmt->fetch()) {}
        $stmt->close();
    }

    $stmt = $db->prepare("INSERT INTO Invoices (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,invoice_address_id,delivery_address_id,invoice_date,due_date,details,invoice_type,global_discount_percentage,status,order_id,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiissssdsii', $invoiceID, $invoiceCode, $companyID, $customerID, $salespersonSearch, $paymentMethod, $subtotal, $grandTotal, $vatTotal, $discount, $billingAddress, $deliveryAddress, $invoiceDate, $dueDate, $details, $invoiceType, $globalDiscountPercentage, $status, $orderID, $currencyID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
    $stmt->close();

    lockDocumentSingleTransaction($invoiceID, "Invoices", $db);

    $detailsTra = "Invoice $invoiceCode";

    $lineTotals         = 0;
    $lineDiscountTotals = 0;
    $itemsCounter       = 0;

    if (count($invoiceItems) == 0) {throw new Exception();}

    foreach ($invoiceItems as $invoiceItem) {

        $itemID = $invoiceItem['itemID'];

        if ($itemID > 0) {
            $itemsCounter++;

            $qty            = $invoiceItem['Qty'];
            $itemNotes      = $invoiceItem['Notes'];
            $unitPrice      = $invoiceItem['UP'];
            $lineDiscount   = $invoiceItem['LD'];
            $priceType      = $invoiceItem['PC'];
            $globalDiscount = $invoiceItem['globalDiscount'];
            $vatTotal       = $invoiceItem['vatLine'];
            $vatCode        = $invoiceItem['VAT'];
            $orderItemID    = $invoiceItem['orderItemID'];

            $vatID    = getVatID($vatCode, $db);
            $subunits = getSubUnits($itemID, $db);

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineTotals += floatval($unitPrice) * $qty / $subunits;
            $lineDiscountTotals += floatval($lineDiscount);


            if (isset($orderID) && $orderID > 0 && isset($orderItemID) && $orderItemID > 0) {

                $stmt = $db->prepare("SELECT (qty-Order_Item.qty_invoiced-Order_Item.qty_delivered) as available FROM Order_Item WHERE order_item_id='$orderItemID'");
                $stmt->execute();
                if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
                $stmt->bind_result($orderAvailableQty);
                while ($stmt->fetch()) {}
                $stmt->close();

                if($orderAvailableQty <= $qty){
                    $reserved  = $orderAvailableQty;
                } else {
                    $reserved  = $qty;
                }

                $stmt = $db->prepare("UPDATE Order_Item SET qty_invoiced=qty_invoiced+? WHERE order_item_id=?");
                $stmt->bind_param('di', $reserved, $orderItemID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();

                $batchNumber = '0';
                $fromActionQty = $reserved;
                $available = -$qty;
                $reserved  = -$reserved;
                $sold      = $qty;

                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, $reserved, 0, 0, 0, $sold, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, $reserved, 0, 0, 0, $sold, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Insert Invoice', 2, $orderID, $orderCode, "$fromActionQty", 'qty_invoiced');
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            } else if (isset($waybillID) && $waybillID > 0 && isset($orderItemID) && $orderItemID > 0) {

                $stmt = $db->prepare("SELECT batch_number, qty-Waybill_Item.qty_invoiced as available FROM Waybill_Item WHERE waybill_item_id='$orderItemID' LIMIT 1");
                $stmt->execute();
                if (strcmp("$stmt->error", "") != 0) {throw new Exception($stmt->error);}
                $stmt->bind_result($waybillItemBatchNumber,$waybillAvailableQty);
                while ($stmt->fetch()) {}
                $stmt->close();

                if($waybillAvailableQty <= $qty){
                    $available  = $qty - $waybillAvailableQty;
                    $invoiced = $waybillAvailableQty;
                } else {
                    $available  = 0;
                    $invoiced = $qty;
                }

                $stmt = $db->prepare("UPDATE Waybill_Item SET qty_invoiced=qty_invoiced+? WHERE waybill_item_id=?");
                $stmt->bind_param('di', $invoiced, $orderItemID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();

                $batchNumber = "$waybillItemBatchNumber";
                if(strcmp($batchNumber,'')==0){$batchNumber='0';}

                $available = -$available;
                $sold = $qty;
                $delivered = -$invoiced;

                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, $delivered, 0, 0, $sold, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, $delivered, 0, 0, $sold, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Insert Invoice', 3, $waybillID, $waybillCode, "$invoiced", 'qty_invoiced');
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            } else {

                $batchNumber = '0';
                $available = -$qty;
                $sold      = $qty;

                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, $sold, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, $sold, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Insert Invoice', 0, null, null, 0, null);
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            }

            $invoiceItemID = getNextKeySingleTransaction("Invoice_Item", "invoice_item_id", $db);

            $stmt = $db->prepare("INSERT INTO Invoice_Item (invoice_item_id,invoice_id,item_id,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidss', $invoiceItemID, $invoiceID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes,$batchNumber);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
            $stmt->close();

            $custTable = new CustomTable('Invoice_Item', $invoiceItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($invoiceItem, $code->tableCode, $db);
            }

        }

    }
    $discount = floatval($discount);
    $discount += floatval($lineDiscountTotals);

    $stmt = $db->prepare("UPDATE  Invoices SET subtotal =? ,discount_amount=? WHERE invoice_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $invoiceID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
    $stmt->close();

    if ($draftID > 0) {
        $stmt = $db->prepare("DELETE FROM Invoices_Draft WHERE invoice_id=?");
        $stmt->bind_param('i', $draftID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();

        $stmt = $db->prepare("DELETE FROM Invoice_Item_Draft WHERE invoice_id=?");
        $stmt->bind_param('i', $draftID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }

    if ($serviceCallID > 0) {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
        $status         = 0;
        $timezone       = 2;
        $date           = date("Y-m-d H:i:s");
        $replyTypeID    = 3;
        $details        = "New Invoice Issued";
        $documentType   = "Invoices";
        $salespersonTo  = 0;
        $emailResponse  = "";
        $priorityID     = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonSearch, $status, $date, $replyTypeID, $details, $invoiceID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }


    if (strcmp($invoiceType, "Credit") == 0) {
        $sign = 1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $invoiceCode, $customerID, $invoiceDate, $invoiceDate, $invoiceCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
        updateCustomerBalance($customerID, $grandTotal, $db);
    } else {
        $sign = 1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $invoiceCode, $customerID, $invoiceDate, $invoiceDate, $invoiceCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
        $sign = -1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $invoiceCode, $customerID, $invoiceDate, $invoiceDate, $invoiceCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }


    $custTable = new CustomTable('Invoices', $invoiceID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    if (isset($orderID) && $orderID > 0) {
        $stmt = $db->prepare("INSERT IGNORE INTO Order_Invoice (order_id,invoice_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii', $orderID, $invoiceID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }

    if (isset($waybillID) && $waybillID > 0) {
        $stmt = $db->prepare("INSERT IGNORE INTO Waybill_Invoice (waybill_id,invoice_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii', $waybillID, $invoiceID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }

    $db->commit(true);

    echo "$invoiceID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Invoices',$invoiceID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}


function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $subunits = 1;
    $sub = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        if($sub>0) {
            return $sub;
        }
    }
    $stm1->close();
    return $subunits;


}

function updateCustomerBalance($customerID,$amount,$db)
{

 $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
 $stmt->bind_param('di',$amount,$customerID);
 $stmt->execute();
 $stmt->close();

}
?>