<?php

include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$companyID = $_SESSION['companyID'];
$customerID= trim(''.$_POST['customerID']);
$deliveryAddress= trim(''.$_POST['deliveryAddress']);
$billingAddress= trim(''.$_POST['billingAddress']);
$orderDate= trim(''.$_POST['orderDate']);
$serviceCallID = trim(''.$_POST['serviceCallID']);
$dueDate = trim(''.$_POST['dueDate']);
$subtotal= trim(''.$_POST['subtotal']);
$discount= trim(''.$_POST['discount']);
$vatTotal= trim(''.$_POST['vatTotal']);
$grandTotal= trim(''.$_POST['grandTotal']);
$details= trim(''.$_POST['details']);
$project=trim(''.$_POST['project']);
$administrationFees= trim(''.$_POST['administrationFees']);
$paymentMethod= trim(''.$_POST['paymentMethod']);
$salespersonSearch= trim(''.$_POST['salespersonSearch']);
$warehouseSearch= trim(''.$_POST['warehouseSearch']);

$orderItems = array();
$orderItems =$_POST['orderItems'];

$status = "Placed";

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

try {
    $db->begin_transaction();

    if(isset($orderDate)) {
        $orderDate = date_format( date_create_from_format('d/m/Y', $orderDate), 'Y-m-d');
    }

    if(isset($dueDate) AND strcmp($dueDate,"")!=0) {
        $dueDate = date_format( date_create_from_format('d/m/Y', $dueDate), 'Y-m-d');
    }

    if(strcmp($warehouseSearch,'')==0) {
        $warehouseSearch = 1;
    }

    if(strpos($discount, '%') !== false) {
        $globalDiscountPercentage=str_replace("%","",$discount);
        $discount=$subtotal*$globalDiscountPercentage/100;
    } else {
        $globalDiscountPercentage=0;
    }

    $orderID = getNextKeySingleTransaction("Purchase_Orders","order_id",$db);
    $orderCode = getNextCodeSingleTransaction("Purchase_Orders", "order_code", "PO", "CLOUD", $db ,"Devices_Pop");

    if (strcmp($orderCode, '') == 0) {
        $orderCode = getNextPurchaseOrderCode("CLOUD", $db);
    }

    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO Purchase_Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,order_address_id,delivery_address_id,order_date,delivery_date,details,global_discount_percentage,status, delivery_method,tender_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiisssdssi',$orderID,$orderCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseSearch,$project);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($orderID,"Purchase_Orders",$db);

    $lineDiscountTotals =0;
    foreach($orderItems as $orderItem)
    {

        $itemID = $orderItem['itemID'];

        if($itemID > 0) {
            $itemNotes = $orderItem['Notes'];
            $qty = floatval($orderItem['Qty']);
            $unitPrice = floatval($orderItem['UP']);
            $lineDiscount = $orderItem['LD'];
            $priceType = $orderItem['PC'];
            $globalDiscount = $orderItem['globalDiscount'];
            $vatTotal = $orderItem['vatLine'];
            $vatCode = $orderItem['VAT'];

            $subunits=getSubUnits($itemID,$db);
            $vatID = getVatID($vatCode,$db);

            if(floatval($subunits)==0) {
                $subunits=1;
            }

            $batchNumber='0';

            if(strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage=str_replace("%","",$lineDiscount);
                $lineDiscount = ($qty/$subunits)*$unitPrice *($lineDiscountSelectedPercentage/100);
            } else {
                $lineDiscountSelectedPercentage=0;
            }
            $lineDiscount = floatval($lineDiscount);
            $lineTotals += floatval($unitPrice*$qty/$subunits);
            $lineDiscountTotals +=$lineDiscount;

            $orderItemID = getNextKeySingleTransaction("Purchase_Order_Item", "order_item_id",$db);

            $stmt = $db->prepare("INSERT INTO Purchase_Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiids', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            $onorder=$qty;
            $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, 0, 0, $onorder, 0, 0, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, 0, 0, $onorder, 0, 0, "0000-00-00", 9, $orderID, $orderCode, 'Insert P.Order', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}


            $custTable = new CustomTable('Purchase_Order_Item',$orderItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($orderItem, $code->tableCode,$db);
            }
        }

    }


    if($administrationFees>0)
    {
        $itemID=getItemID("ADMIN",$db);
        $vatID=getItemVatID($itemID,$db);

        $qty=1;
        $unitPrice=$administrationFees;
        $lineDiscount=$globalDiscount=0;
        $vatTotal=$unitPrice*0.19;
        $priceType=0;
        $lineDiscountSelectedPercentage=0;
        $itemDescription="";
        $lineTotals += $unitPrice*$qty;

        $orderItemID = getNextKeySingleTransaction("Purchase_Order_Item", "order_item_id",$db);

        $stmt = $db->prepare("INSERT INTO Purchase_Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiidddddiids', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemDescription);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

    }
    $discount = floatval($discount);
    $discount+=$lineDiscountTotals;

    $stmt = $db->prepare("UPDATE  Purchase_Orders SET subtotal =? ,discount_amount=? WHERE order_id=?");
    $stmt->bind_param('ddi',$lineTotals,$discount,$orderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    if($serviceCallID>0)
    {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id",$db);
        $status=0;
        $timezone=2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID=3;
        $details ="New Purchase Order Issued";
        $documentType="Purchase_Order";
        $salespersonTo=0;
        $emailResponse="";
        $priorityID=0;

        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salespersonSearch,$status,$date,$replyTypeID,$details,$orderID,$documentType,$salespersonTo,$emailResponse,$priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    $custTable = new CustomTable('Purchase_Orders',$orderID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode,$db);
    }

    $db->commit(true);

    if($serviceCallID>0){
        echo "$orderID&service_call_id=$serviceCallID";
    } else {
        echo "$orderID";
    }

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}


$custForm = new CustomForm('Orders',$orderID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}



function getVatID($vatCode,$db){

    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $sub = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Suppliers SET balance = balance + ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}

function getItemID($itemCode,$db)
{
    global $username;
    global $password;
    global $database;
    $z="";

    $stm1 = $db->prepare("SELECT item_id FROM Items WHERE item_code='$itemCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}
function getItemVatID($itemID,$db)
{
    global $username, $password, $database;
    $deliveryfee=0;

    $stm1 = $db->prepare("SELECT vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($itemID);
    while ($stm1->fetch()) {


    }
    $stm1->close();



    return $itemID;
}
?>