<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$customerID         = trim($_POST['customerID']);
$tenderDate         = trim($_POST['tenderDate']);
$serviceCallID      = trim($_POST['serviceCallID']);
$currencyID         = trim($_POST['currencyID']);
$subtotal           = trim($_POST['subtotal']);
$discount           = trim($_POST['discount']);
$vatTotal           = trim($_POST['vatTotal']);
$grandTotal         = trim($_POST['grandTotal']);
$details            = trim($_POST['details']);
$salespersonSearch  = trim($_POST['salespersonSearch']);
$revisionCode       = trim($_POST['revisionCode']);

$status             = "Placed";

$orderItems         = array();
$orderItems         = json_decode($_POST['tenderItems'], true);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $tenderID   = getNextKeySingleTransaction("Tenders", "tender_id", $db);
    $tenderCode = getNextCodeSingleTransaction("Tenders", "tender_code", "T", "CLOUD", $db);

    if (strcmp($tenderCode, '') == 0) {
        $tenderCode = getNextTenderCode("CLOUD", $db);
    }

    if(strcmp(trim($revisionCode),'')!=0){
        $revisionDelimiter = '/';
        $originalTenderCode = explode($revisionDelimiter,$revisionCode)[0];
        $stm = $db->prepare("SELECT count(tender_id) FROM Tenders WHERE tender_code LIKE '$originalTenderCode$revisionDelimiter%' ");
        $stm->execute();
        $stm->bind_result($revisionCounter);
        while ($stm->fetch()) {$revisionCounter++;}
        $stm->close();
        $tenderCode = $originalTenderCode.$revisionDelimiter.$revisionCounter;
    }

    if (isset($tenderDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $tenderDate);
        $tenderDate = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }


    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO Tenders (tender_id,tender_code,customer_id,salesperson_id,subtotal,grand_total,vat_amount,discount_amount,tender_date,details,global_discount_percentage,status,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiddddssdsi', $tenderID, $tenderCode, $customerID, $salespersonSearch, $subtotal, $grandTotal, $vatTotal, $discount, $tenderDate, $details, $globalDiscountPercentage, $status, $currencyID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($tenderID, "Tenders", $db);

    $lineTotals = 0;
    $lineDiscountTotals = 0;
    $itemsCounter = 0;

    if (count($orderItems) == 0) {throw new Exception();}

    foreach ($orderItems as $orderItem) {

        $itemID = $orderItem['itemID'];
        if ($itemID != 0) {

            $itemsCounter++;

            $qty             = $orderItem['Qty'];
            $unitPrice       = $orderItem['UP'];
            $lineDiscount    = $orderItem['LD'];
            $priceType       = $orderItem['PC'];
            $globalDiscount  = $orderItem['globalDiscount'];
            $vatTotal        = $orderItem['vatLine'];
            $vatCode         = $orderItem['VAT'];
            $itemDescription = $orderItem['Notes'];

            if ($qty == 0) {continue;}

            $subunits = getSubUnits($itemID, $db);
            $vatID    = getVatID($vatCode, $db);


            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }


            $lineTotals += floatval($unitPrice * $qty / $subunits);
            $lineDiscountTotals += floatval($lineDiscount);

            $tenderItemID = getNextKeySingleTransaction("Tender_Item", "tender_item_id", $db);

            $stmt = $db->prepare("INSERT INTO Tender_Item (tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiids', $tenderItemID, $tenderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemDescription);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            $custTable = new CustomTable('Tender_Item', $tenderItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($orderItem, $code->tableCode, $db);
            }
        }

    }
    $discount = floatval($discount);
    $discount += floatval($lineDiscountTotals);


    $stmt = $db->prepare("UPDATE  Tenders SET subtotal =? ,discount_amount=? WHERE tender_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $tenderID);
    $stmt->execute();
    $stmt->close();

    if ($serviceCallID > 0) {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
        $status = 0;
        $timezone = 2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID = 3;
        $details = "New Tender Issued";
        $documentType = "Tenders";
        $salespersonTo = 0;
        $emailResponse = "";
        $priorityID = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonSearch, $status, $date, $replyTypeID, $details, $tenderID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    $custTable = new CustomTable('Tenders', $tenderID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    if ($serviceCallID > 0) {
        echo "$tenderID&service_call_id=$serviceCallID";
    } else {
        echo "$tenderID";
    }

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}


$custForm = new CustomForm('Tenders',$tenderID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}



				
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $subunits = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $subunits;


}

function updateCustomerBalance($customerID,$amount)
{
 global $username;
 global $password;
 global $database;
 $db = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
 $stmt->bind_param('di',$amount,$customerID);
 $stmt->execute();
 $stmt->close();

}
?>