<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

 $companyID = $_SESSION['companyID'];
 $salespersonID= trim($_POST['salespersonSearch']);
 $warehouseIDFrom= trim($_POST['warehouseIDFrom']);
 $warehouseIDTo= trim($_POST['warehouseIDTo']);
 $details= trim($_POST['details']);
 $wtDate= trim($_POST['wtDate']);
 $serviceCallID = trim($_POST['serviceCallID']);
 $convertedOrderID = trim($_POST['fromOrderID']);
 $supplierID = trim($_POST['supplierID']);
 $withNewServiceCall = trim($_POST['withNewServiceCall']);





if(isset($wtDate)) {
 $date = DateTime::createFromFormat('d/m/Y', $wtDate);
    $wtDate = $date->format('Y-m-d');
}


$wtItems = json_decode($_POST['orderItems'], true);

$transactionType="Transfer Request";

$wtID = getNextKey("Warehouse_Transactions","warehouse_transaction_id");
$wtCode =getNextWTCode("CLOUD");


$db = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) 
 {
      printf("Connect failed: %s\n", mysqli_connect_error());
      exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("INSERT INTO Warehouse_Transactions (warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details) VALUES(?,?,?,?,?,?,?,?,?)");
 $stmt->bind_param('isiiiisss',$wtID,$wtCode,$warehouseIDFrom,$warehouseIDTo,$companyID,$salespersonID,$transactionType,$wtDate,$details);
 $stmt->execute();
 $stmt->close();

lockDocument($wtID,"Warehouse_Transactions");

$purchaseItems = array();
foreach($wtItems as $wtItem)
{






  $itemID = $wtItem['itemID'];
 if($itemID!=0) {
  $qty = $wtItem['Qty'];
  $batchNumber = $wtItem['Batch Number'];
  $expiryDate = $wtItem['Expiry Date'];
  $fromOrderItemID = $wtItem['docItemID'];
  $purchaseOrder = $wtItem['P. Order'];
  $isPurchaseOrder = false;
  if(strcmp($purchaseOrder,'yes')==0){$isPurchaseOrder = true;}

  if($isPurchaseOrder){

      $purchaseItem = "";
      $purchaseItem->id = $itemID;
      $purchaseItem->qty = $qty;
      $purchaseItem->orderItemID = $fromOrderItemID;

      array_push($purchaseItems,$purchaseItem);
      $isPurchaseOrder = false;

  } else {
      $warehouseItemID = getNextKey("Warehouse_Transaction_Item", "warehouse_transaction_item_id");

      $db = new mysqli(localhost, $username, $password, $database);
      if (mysqli_connect_errno()) {
          printf("Connect failed: %s\n", mysqli_connect_error());
          exit();
      }
      $db->set_charset("utf8");
      $stmt = $db->prepare("INSERT INTO Warehouse_Transaction_Item (warehouse_transaction_item_id,warehouse_transaction_id,item_id,warehouse_id,qty,batch_number) VALUES(?,?,?,?,?,?)");
      $stmt->bind_param('iiiids', $warehouseItemID, $wtID, $itemID, $warehouseIDFrom, $qty, $batchNumber);
      $stmt->execute();
      $stmt->close();

  }
 }
}

if(strcmp($withNewServiceCall,'yes')==0){

    $stm = $db->prepare("SELECT Customers.customer_id FROM Customers,Warehouses WHERE Customers.customer_code=Warehouses.warehouse_code AND Warehouses.warehouse_id ='$warehouseIDTo' LIMIT 1");
    $stm->execute();
    $stm->bind_result($customerIdFromWhTo);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT SalesPersons.salesperson_id FROM SalesPersons,Warehouses WHERE SalesPersons.salesperson_code=Warehouses.warehouse_code AND Warehouses.warehouse_id ='$warehouseIDTo' LIMIT 1");
    $stm->execute();
    $stm->bind_result($salesPersonIdFromWhTo);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT SalesPersons.salesperson_id FROM SalesPersons,Warehouses WHERE SalesPersons.salesperson_code=Warehouses.warehouse_code AND Warehouses.warehouse_id ='$warehouseIDFrom' LIMIT 1");
    $stm->execute();
    $stm->bind_result($salesPersonIdFromWhFrom);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT CONCAT(warehouse_code,' - ',name) FROM Warehouses WHERE Warehouses.warehouse_id ='$warehouseIDFrom' LIMIT 1");
    $stm->execute();
    $stm->bind_result($warehouseFromCode);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT CONCAT(warehouse_code,' - ',name) FROM Warehouses WHERE Warehouses.warehouse_id ='$warehouseIDTo' LIMIT 1");
    $stm->execute();
    $stm->bind_result($warehouseToCode);
    while ($stm->fetch()) {}
    $stm->close();

    $serviceCallID      = getNextKey("Service_Call","service_call_id");
    $serviceCallCode    = "C"."C".getNextServiceCallCode("CLOUD");

    $salespersonSearch  = $salesPersonIdFromWhTo;
    $referredToID       = $salesPersonIdFromWhFrom;
    $customerID         = $customerIdFromWhTo;

    $customerAddressID  = 0;
    $serialNumberID     = 0;
    $sourceID           = 0;
    $serviceCallType    = 2;
    $serviceCallStatus  = 1;
    $priority           = 1;
    $serviceCallTitle   = "Transfer request From: $warehouseFromCode To: $warehouseToCode";
    $serviceCallDetails = '';
    $sourceName         = '';
    $callerDetails      = '';

    $serviceCallDate              = date("Y-m-d H:i:s");
    $serviceCallscheduleStartDate = date("Y-m-d H:i:s");
    $dueDate                      = date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s') . "+3 Hours"));
    $serviceCallscheduleEndDate   = date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s') . "+3 Hours"));

    $stmt = $db->prepare("INSERT INTO Service_Call (service_call_id,service_call_code,salesperson_id,assign_to,customer_id,customer_address_id,serial_number_id,source_id,type_id,status_id,priority_id,topic,details,source_name,source_details,date,due_date,schedule_start_date,schedule_end_date,progress,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'-1',NOW())");
    $stmt->bind_param('isiiiiiiiiissssssss',$serviceCallID,$serviceCallCode,$salespersonID,$salespersonSearch,$customerID,$customerAddressID,$serialNumberID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$callerDetails,$serviceCallDate,$dueDate,$serviceCallscheduleStartDate,$serviceCallscheduleEndDate);
    $stmt->execute();
    $stmt->close();

    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO SC_Referred_To (service_call_id,salesperson_id,added_time,added_by_id,timestamp) VALUES(?,?,NOW(),?,NOW())");
    $stmt->bind_param('iii', $serviceCallID, $referredToID, $salespersonID);
    $stmt->execute();
    $stmt->close();

}

if($serviceCallID>0)
{
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $serviceCallReplyID = getNextKey("Service_Call_Reply", "service_call_reply_id");
    $status=0;
    $timezone=2;
        date_default_timezone_set('Europe/Athens');
    $date = date("Y-m-d H:i:s");
    $replyTypeID=3;
    $details ="Transfer Request";
    $documentType="Transfer";
    $salespersonTo=0;
    $emailResponse="";
    $priorityID=0;
    $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salespersonID,$status,$date,$replyTypeID,$details,$wtID,$documentType,$salespersonTo,$emailResponse,$priorityID);
    $stmt->execute();
    $stmt->close();
}

setNextWTCode("CLOUD");

if(!empty($purchaseItems)){
    require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
    $dbHelbelItem = new DBItem();


    $orderID = getNextKey("Purchase_Orders","order_id");
    $orderCode =getNextPurchaseOrderCode("CLOUD");


    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $customerID = $supplierID;
    if(strcmp($customerID,'')==0){$customerID = 0;}
    $paymentMethod = 0;
    $subtotal = 0;
    $grandTotal = 0;
    $vatTotal = 0;
    $discountAmount = 0;
    $billingAddress=0;
    $deliveryAddress=0;
    $orderDate = date('Y-m-d');
    $dueDate = "0000-00-00";
    $details=' ';
    $globalDiscountPercentage=0;
    $status = "Placed";
    $warehouseID = 0;
    $tenderID = 0;
    $printCount = 0 ;
    $vatIorE = 'i';
    $depositAmount = 0;
    $currencyID = 1;
    $deliveryMethod = "Not Set";
    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO Purchase_Orders(order_id, order_code, company_id, customer_id, salesperson_id, paymenttype_id, order_date, subtotal, grand_total,vat_amount, discount_amount, print_count, order_address_id, delivery_address_id, tender_id, vat_i_or_e, delivery_date, deposit_amount, details, status, currency_id, global_discount_percentage, delivery_method, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('isiiiisddddiiiissdssids',$orderID,$orderCode, $companyID, $customerID, $salespersonID, $paymentMethod, $orderDate, $subtotal,$grandTotal, $vatTotal, $discountAmount, $printCount, $billingAddress,  $deliveryAddress,    $tenderID, $vatIorE, $dueDate, $depositAmount, $details, $status, $currencyID, $globalDiscountPercentage, $deliveryMethod);
    $stmt->execute();
    $stmt->close();
    lockDocument($orderID,"Purchase_Orders");


    $lineTotals =0;
    $lineDiscountTotals =0;
    foreach($purchaseItems as $orderItem)
    {

        $itemID = $orderItem->id;
        $itemNotes = '';
        if($itemID!=0) {

            $qty = $orderItem->qty;
            $fromOrderItemID = $orderItem->orderItemID;
            $item = $dbHelbelItem->getItemByID($itemID);
            $unitPrice = 0;
            $lineDiscount = 0;
            $subunits=getSubUnits($itemID);
            if(strpos($lineDiscount, '%') !== false)
            {
                $lineDiscountSelectedPercentage=str_replace("%","",$lineDiscount);
                $lineDiscount = ($qty/$subunits)*$unitPrice *($lineDiscountSelectedPercentage/100);
            }
            else{
                $lineDiscountSelectedPercentage=0;
            }
            $priceType = 0;
            $globalDiscount = 0;
            $vatTotal = 0;
            $vatID = $item->vatID;

            $lineTotals += $unitPrice*$qty/$subunits;
            $lineDiscountTotals +=$lineDiscount;

            $orderItemID = getNextKey("Purchase_Order_Item", "order_item_id");

            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
            $stmt = $db->prepare("INSERT INTO Purchase_Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiids', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes);
            $stmt->execute();
            $stmt->close();

            if(isset($convertedOrderID) && $convertedOrderID > 0){
                if( $fromOrderItemID > 0 ){
                    $stmt = $db->prepare("UPDATE Order_Item SET master_item = 'PO:$qty' WHERE order_item_id=?  ");
                    $stmt->bind_param('i',$fromOrderItemID);
                    $stmt->execute();
                    $stmt->close();
                }

            }

        }

    }
    setNextPurchaseOrderCode("CLOUD");

    if($serviceCallID>0)
    {
        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $serviceCallReplyID = getNextKey("Service_Call_Reply", "service_call_reply_id");
        $status=0;
        $timezone=2;
        date_default_timezone_set('Europe/Athens');
        $date = date("Y-m-d H:i:s");
        $replyTypeID=3;
        $details ="New Purchase Order Issued";
        $documentType="Purchase_Order";
        $salespersonTo=0;
        $emailResponse="";
        $priorityID=0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salespersonID,$status,$date,$replyTypeID,$details,$orderID,$documentType,$salespersonTo,$emailResponse,$priorityID);
        $stmt->execute();
        $stmt->close();
    }
}

					 		
echo"$wtID";





function getSubUnits($itemID) {

    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $subunits = 1;
    $stm1 = $db1->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $subunits;


}
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

?>