<?php
include_once("../../../../param.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$customerId         = trim($_POST['customer']);
$categoryId         = trim($_POST['category']);
$cycleType          = trim($_POST['cycleType']);
$visitCycleDays     = trim($_POST['visitCycleDays']);
$lastVisitDate      = trim($_POST['lastVisitDate']);
$lastActionDate     = trim($_POST['lastActionDate']);
$rating             = trim($_POST['rating']);
$target             = trim($_POST['target']);
$notes              = trim($_POST['notes']);
$oldCustomerID      = trim($_POST['oldCustomerID']);
$oldCategoryID      = trim($_POST['oldCategoryID']);

if (empty($customerId) || empty($categoryId)) {
    echo "error";
    exit;
}

global $username, $password, $database;
$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if($oldCustomerID != $customerId || $oldCategoryID != $categoryId) {
    $stmt = $db->prepare("SELECT COUNT(*) FROM Allow_Categories_Customers WHERE customer_id = ? AND category_id = ?");
    $stmt->bind_param('ii', $customerId, $categoryId);
    $stmt->execute();
    $stmt->bind_result($count);
    $stmt->fetch();
    $stmt->close();

    if ($count > 0) {
        echo "existing";
        exit();
    }
}



$stmt = $db->prepare("UPDATE Allow_Categories_Customers 
                      SET customer_id = ?, category_id = ?, cycle_type = ?, visit_cycle_in_days = ?, 
                          last_visit_date = ?, last_action_date = ?, rating = ?, target = ?, notes = ?, timestamp = NOW() 
                      WHERE customer_id = ? AND category_id = ?");

$stmt->bind_param('iisisssisii', $customerId, $categoryId, $cycleType, $visitCycleDays, $lastVisitDate,
    $lastActionDate, $rating, $target, $notes, $oldCustomerID, $oldCategoryID);

if (!$stmt->execute()) {
    echo "error";
    exit();
}

$stmt->close();

echo "success";
?>
