<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$uniqueID = (trim(''.$_POST['uniqueID']));
$uniqueIDArray = explode('-', $uniqueID);

$customerID = $uniqueIDArray[0];
$itemID = $uniqueIDArray[1];
$minQty = $uniqueIDArray[2];



$fieldName= trim(''.$_POST['fieldName']);
$fieldValue= trim(''.$_POST['fieldValue']);


global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

//$existingKey=0;
//if (in_array($fieldName, ["customer", "item", "min_qty"])) {
//    $existingKey = checkForExistingKey($customerID, $itemID, $minQty, $fieldName, $fieldValue,$db);
//}
//
//if ($existingKey == true) {
//    echo "existingKey";
//    $db->close();
//    exit();
//}




switch ($fieldName) {

    case 'customer':
        $stm = $db->prepare("UPDATE ContractPrices SET customer_id = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'iiii';
        break;

    case 'item':
        $stm = $db->prepare("UPDATE ContractPrices SET item_id = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'iiii';
        break;

    case 'price':
        $stm = $db->prepare("UPDATE ContractPrices SET price = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'diii';
        break;

    case 'price_type':
        $stm = $db->prepare("UPDATE ContractPrices SET pricetype_id = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'iiii';
        break;

    case 'percentage':
        $stm = $db->prepare("UPDATE ContractPrices SET percentage = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'diii';
        break;

    case 'min_qty':
        $stm = $db->prepare("UPDATE ContractPrices SET min_qty = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'iiii';
        break;

    case 'valid_from':
        $stm = $db->prepare("UPDATE ContractPrices SET valid_from = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'siii';
        break;

    case 'valid_until':
        $stm = $db->prepare("UPDATE ContractPrices SET valid_until = ? WHERE customer_id = ? AND item_id = ? AND min_qty = ?");
        $paramType = 'siii';
        break;

    default:
        return;
}

$stm->bind_param($paramType, $fieldValue,$customerID,$itemID,$minQty);
$stm->execute();
$stm->close();
$db->close();


function checkForExistingKey($customerID, $itemID,$minQty,$fieldName,$fieldValue,$db){

    $stm = $db->prepare("SELECT count(*) FROM ContractPrices WHERE customer_id = ? AND item_id = ? AND min_qty = ? ");

    // fieldValue contains the new id
    if (strcmp($fieldName, "customer") == 0) {
        $stm->bind_param('iii', $fieldValue, $itemID, $minQty);
    } elseif (strcmp($fieldName, "item") == 0) {
        $stm->bind_param('iii', $customerID, $fieldValue, $minQty);
    } elseif (strcmp($fieldName, "min_qty") == 0) {
        $stm->bind_param('iii', $customerID, $itemID, $fieldValue);
    }

    $stm->execute();
    $stm->bind_result($count);
    $stm->fetch();
    $stm->close();

    if (intval($count) == 0) {
        return true;
    }
    else{
        return false;
    }


}



?>