<?php
include_once("../../../../param.php");

$text = trim(''.$_POST['text']);
$code = trim(''.$_POST['code']);
$days = trim(''.$_POST['days']);
if(isset($_POST['id'])){
    $paymentTermID = intval(trim(''.$_POST['id']));
}
else{
    $paymentTermID=0;
}


if(empty($text) || empty($code)){
    return;
}

global $username, $password, $database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT payment_term_id FROM Payment_Terms WHERE NOT payment_term_id=? AND payment_term_code LIKE ? LIMIT 1");
$stm->bind_param("is", $paymentTermID,$code);
$stm->execute();
$stm->bind_result($existingCodeID);
$stm->fetch();
$stm->close();

$existingCodeID = intval($existingCodeID);

if($existingCodeID > 0) {
    echo "existingCode";
    return;
}

if($paymentTermID > 0){

    $stmt = $db->prepare("UPDATE Payment_Terms SET payment_term_code = ?,payment_term_text = ?, payment_terms_days = ? WHERE payment_term_id = ?");
    $stmt->bind_param('ssii',$code,$text,$days,$paymentTermID);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();
} else {
    $stmt = $db->prepare("INSERT INTO Payment_Terms (payment_term_code,payment_term_text,payment_terms_days, timestamp) VALUES (?,?,?,NOW())");
    $stmt->bind_param('ssi',$code,$text,$days);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();

}


if($error){
    echo 'error';
    exit();
}





?>