<?php
include_once("../../../../param.php");


$name = trim(''.$_POST['name']);
$code = trim(''.$_POST['code']);
$active = trim(''.$_POST['active']);
if(isset($_POST['id'])){
    $projectID = intval(trim(''.$_POST['id']));
}
else{
    $projectID=0;
}


if(empty($name) || empty($code)){
    return;
}

global $username, $password, $database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT project_id FROM Projects WHERE NOT project_id=? AND project_code LIKE ? LIMIT 1");
$stm->bind_param("is", $projectID,$code);
$stm->execute();
$stm->bind_result($existingCodeID);
$stm->fetch();
$stm->close();

$existingCodeID = intval($existingCodeID);

if($existingCodeID > 0) {
    echo "existingCode";
    return;
}

if($projectID > 0){

    $stmt = $db->prepare("UPDATE Projects SET project_code = ?,project_name = ?, active = ? WHERE project_id = ?");
    $stmt->bind_param('sssi',$code,$name,$active,$projectID);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();
} else {
    $stmt = $db->prepare("INSERT INTO Projects (project_code,project_name,active, timestamp) VALUES (?,?,?,NOW())");
    $stmt->bind_param('sss',$code,$name,$active);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();

}


if($error){
    echo 'error';
    exit();
}





?>