<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$invoiceID = trim($_POST['invoiceID']);
$invoiceCode=trim($_POST['invoiceCode']);
$companyID = $_SESSION['companyID'];
$customerID= trim($_POST['customerID']);
$deliveryAddress= trim($_POST['deliveryAddress']);
$billingAddress= trim($_POST['billingAddress']);
$invoiceType= trim($_POST['invoiceType']);
$invoiceDate= trim($_POST['invoiceDate']);
$dueDate = trim($_POST['dueDate']);
$paymentMethod= trim($_POST['paymentMethod']);
$salespersonSearch= trim($_POST['salespersonSearch']);
$warehouseSearch= trim($_POST['warehouseSearch']);
$subtotal= trim($_POST['subtotal']);
$discount= trim($_POST['discount']);
$vatTotal= trim($_POST['vatTotal']);
$grandTotal= trim($_POST['grandTotal']);
$details= trim($_POST['details']);

$invoiceItems = array();
$invoiceItems =$_POST['invoiceItems'];


global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
try {
    $db->begin_transaction();

    if(isset($invoiceDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $invoiceDate);
        $invoiceDate = $date->format('Y-m-d');
    }

    if(isset($dueDate) AND strcmp($dueDate,"")!=0) {
        $date = DateTime::createFromFormat('d/m/Y', $dueDate);
        $dueDate = $date->format('Y-m-d');
    }

    if(strpos($discount, '%') !== false) {
        $globalDiscountPercentage=str_replace("%","",$discount);
        $discount=$subtotal*$globalDiscountPercentage/100;
    } else {
        $globalDiscountPercentage=0;
    }

    if(strcmp($invoiceType,'Cash')==0) {
        $status = "Paid";
    } else {
        $status = "Not Paid";
    }

    $prevTypesArray = array();
    $stmt = $db->prepare("SELECT invoice_type,grand_total,customer_id FROM Purchase_Invoices WHERE invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($previousType, $previousTotal, $previousCustomerID);
    while ($stmt->fetch()) {
        $prevTypeObject = new stdClass();
        $prevTypeObject->previousType = $previousType;
        $prevTypeObject->previousTotal = $previousTotal;
        $prevTypeObject->previousCustomerID = $previousCustomerID;
        array_push($prevTypesArray, $prevTypeObject);
    }
    $stmt->close();

    foreach ($prevTypesArray as $previousTypeObject) {
        $previousType = $prevTypeObject->previousType;
        $previousTotal = $prevTypeObject->previousTotal;
        $previousCustomerID = $prevTypeObject->previousCustomerID;
        if (strcmp($previousType, "Credit") == 0) {
            updateCustomerBalance($previousCustomerID, $previousTotal,$db);
        }
    }

    lockDocumentSingleTransaction($invoiceID,"Purchase_Invoices",$db);


    $stmt = $db->prepare("DELETE FROM Purchase_Invoices WHERE invoice_id=?");
    $stmt->bind_param('i',$invoiceID);
    $stmt->execute();
    $stmt->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement ="DELETE FROM Purchase_Invoices WHERE invoice_id=$invoiceID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is',$deleteID,$statement);
    $stmt->execute();
    $stmt->close();


    $stmt = $db->prepare("INSERT INTO Purchase_Invoices (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,invoice_address_id,delivery_address_id,invoice_date,due_date,details,invoice_type,global_discount_percentage,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiissssds',$invoiceID,$invoiceCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$invoiceDate,$dueDate,$details,$invoiceType,$globalDiscountPercentage,$status);
    $stmt->execute();
    $stmt->close();

    $detailsTra="Purchase Invoice $invoiceCode";

    $stmt = $db->prepare("DELETE FROM Transactions WHERE transaction_code=?");
    $stmt->bind_param('s',$invoiceCode);
    $stmt->execute();
    $stmt->close();


    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
    $statement ="DELETE FROM Transactions WHERE transaction_code=\"$invoiceCode\"";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is',$deleteID,$statement);
    $stmt->execute();
    $stmt->close();


    if(strcmp($invoiceType,"Credit")==0) {
        $sign=1;
        $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids',$transactionID,$invoiceCode,$customerID,$invoiceDate,$invoiceDate,$invoiceCode,$sign,$grandTotal,$detailsTra);
        $stmt->execute();
        $stmt->close();
        updateCustomerBalance($customerID, -$grandTotal,$db);
    }
    else{
        $sign=-1;
        $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids',$transactionID,$invoiceCode,$customerID,$invoiceDate,$invoiceDate,$invoiceCode,$sign,$grandTotal,$detailsTra);
        $stmt->execute();
        $stmt->close();
        $sign=1;
        $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids',$transactionID,$invoiceCode,$customerID,$invoiceDate,$invoiceDate,$invoiceCode,$sign,$grandTotal,$detailsTra);
        $stmt->execute();
        $stmt->close();
    }


    $lineTotals =0;
    $lineDiscountTotals =0;



    $invoiceItemsForSockArray = getStockUpdateLinesOfDocument($db, 11, $invoiceID);

    foreach ($invoiceItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 11, $invoiceID, $invoiceCode, 'Edit P.Invoice (12334)', 0, null, null, 0, null);
        if(!$insertStockUpdateStatementResult){throw new Exception();}

        $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00");
        if(!$insertStockStatementResult){throw new Exception();}

    }

    $invoiceOrderItemsForSockArray = getStockUpdateLinesOfConnectedDocument($db, 11, $invoiceID,9);

    foreach ($invoiceOrderItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, 0, 0, 0, 0, 0, 0, "0000-00-00", 11, $invoiceID, $invoiceCode, 'P.Invoice P.Order (Remove)', 9, $itemObject->fromActionID,  $itemObject->fromActionCode,  -$itemObject->fromActionQty,  $itemObject->fromActionField);
        if(!$insertStockUpdateStatementResult){throw new Exception();}


        $linkedForReservedItems = array();
        $stmt = $db->prepare("SELECT order_item_id,qty_invoiced FROM Purchase_Order_Item WHERE order_id=? AND item_id=?");
        $stmt->bind_param('ii',  $itemObject->fromActionID,$itemObject->itemID);
        $stmt->execute();
        $stmt->bind_result($linkedOrderItemID,$linkedForReserved);
        while ($stmt->fetch()) {

            if($linkedForReserved <= $itemObject->fromActionQty){
                $reverseFromActionQty = $linkedForReserved;
                $itemObject->fromActionQty -= $reverseFromActionQty;
            } else {
                $reverseFromActionQty = $itemObject->fromActionQty;
                $itemObject->fromActionQty = 0;
            }

            $lineReservation = new stdClass();
            $lineReservation->lineID = $linkedOrderItemID;
            $lineReservation->reserved = $reverseFromActionQty;

            array_push($linkedForReservedItems,$lineReservation);

        }
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        foreach ($linkedForReservedItems as $lineReservation){

            $reverseFromActionQty=-$lineReservation->reserved;

            $stmt = $db->prepare("UPDATE Purchase_Order_Item SET ".$itemObject->fromActionField." = ".$itemObject->fromActionField."+? WHERE order_item_id = ?");
            $stmt->bind_param('di', $reverseFromActionQty, $lineReservation->lineID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();
        }

    }


    $stmt = $db->prepare("DELETE FROM Purchase_Invoice_Item WHERE invoice_id=?");
    $stmt->bind_param('i',$invoiceID);
    $stmt->execute();
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
    $statement ="DELETE FROM Purchase_Invoice_Item WHERE invoice_id=$invoiceID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is',$deleteID,$statement);
    $stmt->execute();
    $stmt->close();

    foreach($invoiceItems as $invoiceItem) {

        $itemID = $invoiceItem['itemID'];
        if($itemID > 0) {
            $itemNotes = $invoiceItem['Notes'];
            $qty = floatval($invoiceItem['Qty']);
            $unitPrice = floatval($invoiceItem['UP']);
            $lineDiscount = $invoiceItem['LD'];
            $priceType = $invoiceItem['PC'];
            $globalDiscount = $invoiceItem['globalDiscount'];
            $vatTotal = $invoiceItem['vatLine'];
            $vatCode = $invoiceItem['VAT'];

            $subunits = getSubUnits($itemID,$db);
            $vatID = getVatID($vatCode,$db);

            if(strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage=str_replace("%","",$lineDiscount);
                $lineDiscount = ($qty/$subunits)*$unitPrice *($lineDiscountSelectedPercentage/100);
                $lineDiscount = floatval($lineDiscount);
            } else {
                $lineDiscountSelectedPercentage=0;
            }


            $lineTotals += $unitPrice*$qty/$subunits;
            $lineDiscountTotals +=$lineDiscount;

            $invoiceItemID = getNextKeySingleTransaction("Purchase_Invoice_Item", "invoice_item_id",$db);

            $batchNumber='0';

            $stmt = $db->prepare("INSERT INTO Purchase_Invoice_Item (invoice_item_id,invoice_id,item_id,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidss', $invoiceItemID, $invoiceID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes,$batchNumber);
            $stmt->execute();
            $stmt->close();

            $purchasedUnitPrice = ($unitPrice*$qty/$subunits - $lineDiscount - $globalDiscount)/($qty/$subunits);
            $leadTime = 0;
            $stmt = $db->prepare("INSERT INTO Item_Supplier (item_id, supplier_id, price, lead_time) VALUES(?,?,?,?) ON DUPLICATE KEY UPDATE price=?");
            $stmt->bind_param('iidid', $itemID, $customerID,$purchasedUnitPrice,$leadTime,$purchasedUnitPrice);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
            $stmt->close();


            $custTable = new CustomTable('Purchase_Invoice_Item',$invoiceItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($invoiceItem, $code->tableCode,$db);
            }

        }
    }

    $stockInvoicedItems = array();
    $stmt = $db->prepare("SELECT item_id,batch_number,warehouse_id,SUM(qty) FROM Purchase_Invoice_Item WHERE invoice_id=? GROUP BY item_id,batch_number,warehouse_id");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($itemID,$batchNumber,$warehouseID,$qty);
    while ($stmt->fetch()) {
        $object = new stdClass();
        $object->warehouseID = $warehouseID;
        $object->itemID = $itemID;
        $object->batchNumber = $batchNumber;
        $object->available = $qty;
        $object->reserved = $qty;
        $object->delivered = $qty;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = 0;
        $object->fromActionQty = 0;
        $object->fromActionID = 0;
        $object->fromActionCode = '';
        $object->fromActionField = '';

        array_push($stockInvoicedItems,$object);
    }
    $stmt->close();

    $orderedItemObjects = array();
    $stmt = $db->prepare("SELECT order_item_id,Purchase_Order_Item.order_id,order_code,delivery_method,item_id,qty,qty_delivered,qty_invoiced FROM Purchase_Order_Purchase_Invoice,Purchase_Orders,Purchase_Order_Item WHERE Purchase_Order_Purchase_Invoice.order_id=Purchase_Order_Item.order_id AND Purchase_Orders.order_id=Purchase_Order_Purchase_Invoice.order_id AND Purchase_Order_Purchase_Invoice.invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($orderItemID,$orderID,$orderCode,$warehouseID,$itemID,$qty,$qtyDelivered,$qtyInvoiced);
    while ($stmt->fetch()) {
        $object = new stdClass();
        $object->warehouseID = $warehouseID;
        $object->itemID = $itemID;
        $object->batchNumber = "0";
        $object->available = $qty - $qtyDelivered - $qtyInvoiced;
        $object->reserved = 0;
        $object->delivered = $qtyDelivered;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = $qtyInvoiced;
        $object->fromActionQty = 0;
        $object->fromActionID = $orderID;
        $object->fromActionCode = $orderCode;
        $object->fromActionField = 'qty_invoiced';
        $object->fromActionLineID = $orderItemID;


        array_push($orderedItemObjects,$object);
    }
    $stmt->close();

    foreach ($orderedItemObjects as $orderedItemObject) {

        foreach ($stockInvoicedItems as $stockInvoicedItem){

            if(strcmp($orderedItemObject->itemID,$stockInvoicedItem->itemID)==0
                && strcmp($orderedItemObject->warehouseID,$stockInvoicedItem->warehouseID)==0
                && strcmp($orderedItemObject->batchNumber,$stockInvoicedItem->batchNumber)==0)
            {

                if($orderedItemObject->available <= $stockInvoicedItem->reserved){
                    $reserved  = $orderedItemObject->available;
                    $objectReserved  = $stockInvoicedItem->reserved - $orderedItemObject->available;
                } else {
                    $reserved  = $stockInvoicedItem->reserved;
                    $objectReserved  = 0;
                }

                $stockInvoicedItem->reserved = $objectReserved;
                $fromActionQty = $reserved;
                $onorder  = -$reserved;

                $stmt = $db->prepare("UPDATE Purchase_Order_Item SET qty_invoiced=qty_invoiced+? WHERE order_item_id=?");
                $stmt->bind_param('di', $delivered, $orderedItemObject->fromActionLineID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();




                $insertStockStatementResult = insertStockRecord($db, $orderedItemObject->warehouseID, $orderedItemObject->itemID, $orderedItemObject->batchNumber, 0, 0, 0, $onorder, 0, 0, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $orderedItemObject->warehouseID, $orderedItemObject->itemID, $orderedItemObject->batchNumber, 0, 0, 0, $onorder, 0, 0, "0000-00-00", 11, $invoiceID, $invoiceCode, 'Edit P.Invoice (PO)', 9, $orderedItemObject->fromActionID, $orderedItemObject->fromActionCode, "$fromActionQty", 'qty_invoiced');
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            }

        }

    }

    foreach ($stockInvoicedItems as $stockInvoicedItem) {

        if($stockInvoicedItem->available > 0){

            $batchNumber = $stockInvoicedItem->batchNumber;
            $available = $stockInvoicedItem->available;

            $insertStockStatementResult = insertStockRecord($db, $stockInvoicedItem->warehouseID, $stockInvoicedItem->itemID, $stockInvoicedItem->batchNumber, $available, 0, 0, 0, 0, 0, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $stockInvoicedItem->warehouseID, $stockInvoicedItem->itemID, $stockInvoicedItem->batchNumber, $available, 0, 0, 0, 0, 0, "0000-00-00", 11, $invoiceID, $invoiceCode, 'Edit P.Invoice', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}

        }

    }

    $discount = floatval($discount);
    $discount+=$lineDiscountTotals;

    $stmt = $db->prepare("UPDATE Purchase_Invoices SET subtotal =? ,discount_amount=? WHERE invoice_id=?");
    $stmt->bind_param('ddi',$lineTotals,$discount,$invoiceID);
    $stmt->execute();
    $stmt->close();

    $custTable = new CustomTable('Purchase_Invoices',$invoiceID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode,$db);
    }

    $db->commit(true);

    echo"$invoiceID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Purchase_Invoices',$invoiceID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}





function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function getVatID($vatCode,$db){
    $z="";

    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $subunits = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {return $sub;}
    $stm1->close();
    return $subunits;


}

function updateCustomerBalance($customerID,$amount,$db){

    $stmt = $db->prepare("UPDATE  Suppliers SET balance = balance + ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>