<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
include_once("../../../../param.php");

$orderID = 0;

if(isset($_GET['orderID']) && intval($_GET['orderID']) > 0) {
    $orderID = $_GET['orderID'];
}

if(isset($_POST['orderID']) && intval($_POST['orderID']) > 0) {
    $orderID = $_POST['orderID'];
}

if($orderID > 0) {

    global $username, $password, $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $pickersArray = array();
    $stmt = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons");
    $stmt->execute();
    $stmt->bind_result($salespersonID,$salespersonCode,$firstName,$lastName);
    while ($stmt->fetch()) {$pickersArray[$salespersonID] = "$salespersonCode - $firstName $lastName";}
    $stmt->close();
    // echo "<pre>";
    // var_dump($pickersArray);
    // echo "</pre>";
    $stmt = $db->prepare("SELECT order_code,customer_id FROM Orders WHERE order_id = ? LIMIT 1");
    $stmt->bind_param('i', $orderID);
    $stmt->execute();
    $stmt->bind_result($orderCode,$customerID);
    while ($stmt->fetch()) {}
    $stmt->close();

    $customerID = intval($customerID);
    $stmt = $db->prepare("SELECT Customers.customer_code,customer_company_name FROM Customers WHERE customer_id = ? LIMIT 1");
    $stmt->bind_param('i', $customerID);
    $stmt->execute();
    $stmt->bind_result($customerCode,$customerName);
    while ($stmt->fetch()) {}
    $stmt->close();

    $lines = array();
    $stmt = $db->prepare("SELECT Order_Item.order_item_id,Order_Item.item_id,Items.item_code,Items.name,Order_Item.description,SUM(qty) FROM Order_Item,Items WHERE Order_Item.item_id = Items.item_id AND order_id = ? GROUP BY Order_Item.item_id ORDER BY Items.item_code ASC");
    $stmt->bind_param('i', $orderID);
    $stmt->execute();
    $stmt->bind_result($order_item_id, $item_id, $item_code, $name, $description, $qty);
    while ($stmt->fetch()) {

        $line = new stdClass();
        $line->order_item_id = $order_item_id;
        $line->item_id = $item_id;
        $line->item_code = $item_code;
        $line->name = $name;
        $line->description = $description;
        $line->qty = $qty;

        array_push($lines, $line);
    }
    $stmt->close();

    $pickLines = array();
    $stmt = $db->prepare("SELECT Pick_Item.item_id,SUM(Pick_Item.qty_to_pick),SUM(Pick_Item.qty),pick_code,Pick.status,Pick.pick_id,Pick.salesperson_id FROM Pick_Item,Pick,Pick_Order WHERE Pick_Order.pick_id = Pick.pick_id AND Pick_Item.pick_id=Pick.pick_id AND Pick_Order.order_id = ? AND Pick.status NOT LIKE 'Cancelled' GROUP BY Pick_Item.item_id");
    $stmt->bind_param('i', $orderID);
    $stmt->execute();
    $stmt->bind_result($item_id, $qty_to_pick,$qty_picked,$pickCode,$pickStatus,$pick_id,$salesperson_id);
    while ($stmt->fetch()) {
        $pickLines[$item_id]['qty'] = $qty_to_pick;
        $pickLines[$item_id]['qtyPicked'] = $qty_picked;
        $pickLines[$item_id]['pick'] = $pickCode;
        $pickLines[$item_id]['picker'] = $salesperson_id;
        $pickLines[$item_id]['pickStatus'] = $pickStatus;
        $pickLines[$item_id]['pick_id'] = $pick_id;
    }
    $stmt->close();


    if(count($lines) > 0) {

        echo "<center><h2 style='margin: 0px;'><b>$orderCode<br>$customerCode - $customerName</b></h2></center>";
        echo "<table id='datatable_fixed_column_split_picks' class='table  table-hover dataTable' width='100%' >";
        echo "<thead>";
        echo "<tr>";
        if(count($lines) == count($pickLines)){
            echo " <th class='hasinput text-center' ></th>";
        } else {
            echo " <th class='hasinput text-center' ><input type='checkbox' style='width: 20px;height:20px;' id='splitOrderItemPickCheckboxALL' onclick='$(\".splitOrderItemPickCheckbox\").prop(\"checked\",$(this).prop(\"checked\"));' checked/></th>";
        }
        echo " <th class='hasinput' ></th>";
        echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Code' /></th>";
        echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Details' /></th>";
        echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Qty' /></th>";
        // echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Notes' /></th>";
        echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Picked Qty' /></th>";
        echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Pick' /></th>";
        echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Picker' /></th>";
        echo " <th class='hasinput' ><input type='text' class='form-control text-center' placeholder='Status' /></th>";
        echo "</tr>";
        echo "<tr>";
        echo "<th class='text-center' style='width: 20px;'></th>";
        echo "<th class='text-center' style='width: 1%;'>#</th>";
        echo "<th class='text-center' >Code</th>";
        echo "<th class='text-center' >Details</th>";
        echo "<th class='text-center' style='width: 10%;'>Qty</th>";
        // echo "<th class='text-center' style='width: 10%;'>Notes</th>";
        echo "<th class='text-center' style='width: 10%;'>Picked Qty</th>";
        echo "<th class='text-center' style='width: 10%;'>Pick</th>";
        echo "<th class='text-center' style='width: 10%;'>Picker</th>";
        echo "<th class='text-center' style='width: 10%;'>Status</th>";
        echo "</tr>";
        echo "</thead>";

        $lineCounter=0;
        foreach ($lines as $line) {
            $lineCounter++;
            if(strcmp(''.$pickLines[$line->item_id]['pick'],"")!=0){
                echo "<tr style='background-color: #c7f7c6;'>";
                echo "<td><input type='checkbox' style='width: 20px;height:20px;' class='hasPick' value='$line->order_item_id'  checked disabled/></td>";
                echo "<td>" . $lineCounter . "</td>";
                echo "<td>" . $line->item_code . "</td>";
                echo "<td>" . $line->name . "</td>";
                echo "<td>" . $line->qty . "</td>";
                // echo "<td>" . $line->description . "</td>";
                echo "<td>" . intval($pickLines[$line->item_id]['qtyPicked']) . "</td>";
                echo "<td><a style='text-decoration: none;color: black;' target='_blank' href='//".HTML_PATH."/cop/backend/core/views/view/view_pick.php?pick_id=" . $pickLines[$line->item_id]['pick_id'] . "'>" . $pickLines[$line->item_id]['pick'] . "</a></td>";
                echo "<td>" . $pickersArray[intval($pickLines[$line->item_id]['picker'])] . "</td>";
                echo "<td>" . $pickLines[$line->item_id]['pickStatus'] . "</td>";
                echo "</tr>";
            } else {
                echo "<tr>";
                echo "<td><input type='checkbox' style='width: 20px;height:20px;' class='splitOrderItemPickCheckbox' value='$line->order_item_id' onchange='$(\"#splitOrderItemPickCheckboxALL\").prop(\"checked\",false);' checked/></td>";
                echo "<td>" . $lineCounter . "</td>";
                echo "<td>" . $line->item_code . "</td>";
                echo "<td>" . $line->name . "</td>";
                echo "<td>" . $line->qty . "</td>";
                // echo "<td>" . $line->description . "</td>";
                echo "<td></td>";
                echo "<td></td>";
                echo "<td></td>";
                echo "<td></td>";
                echo "</tr>";
            }



        }

        echo "</table>";
        echo "  <script type='text/javascript' >
                    $('#datatable_fixed_column_split_picks').DataTable({
                        \"sDom\": \"<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B  >r>\"+
                                \"t\"+
                                \"<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>\",
                        \"autoWidth\" : true,
                        \"pageLength\":-1,
                        \"order\": [[ 2, \"asc\" ]],
                    });
                    $('#datatable_fixed_column_split_picks thead th input[type=text]').unbind().on( 'keyup change', function () {

                        $('#datatable_fixed_column_split_picks').DataTable()
                        .column( $(this).parent().index()+':visible' )
                        .search( this.value )
                        .draw();
        
                    } );
                    
                    addCheckboxEventListeners();
                    lastChecked = null;
                    function handleCheck(e) {
                        
                        let inBetween = false;
                        const checkboxes = document.querySelectorAll('.splitOrderItemPickCheckbox');
                        if (e.shiftKey && lastChecked) {
                            checkboxes.forEach(checkbox => {
                                if (checkbox === this || checkbox === lastChecked) {
                                    inBetween = !inBetween;
                                }
                                if (inBetween) {
                                    checkbox.checked = lastCheckedValue;
                                }
                                
                            });
                        }
                        lastChecked = this;
                        lastCheckedValue = this.checked;
                    }
                
                    function addCheckboxEventListeners() {
                        const checkboxes = document.querySelectorAll('.splitOrderItemPickCheckbox');
                        checkboxes.forEach(checkbox => checkbox.addEventListener('click', handleCheck));
                    }
                    
                </script>";
        if(count($lines) == count($pickLines)){
            echo "<br>";
        } else {

            echo "<center>";
            echo "<table style='margin-top: 15px;'>";
            echo "<tr>";
            echo "<td>";
            echo "<select id='splitPickerID' class='form-control' style='width: 300px;'>";

            echo "<option value='0'>Select Picker</option>";
            $stmt = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons WHERE status = 'active' AND salesperson_id > 0 ORDER BY salesperson_code ASC,first_name ASC,last_name ASC");
            $stmt->execute();
            $stmt->bind_result($salesperson_id,$salesperson_code,$first_name,$last_name);
            while ($stmt->fetch()) {
                echo "<option value='$salesperson_id'>$salesperson_code - $first_name $last_name</option>";
            }
            $stmt->close();

            echo "</select>";
            echo "</td>";
            echo "<td>";
            echo "<button type='button' class='btn btn-success' style='font-size:13px; width: 110px; margin-left: 3px;padding 10px 7px;' onclick='sendPickForSplitOrder($orderID)'>Ready to Pick</button>";
            echo "</td>";
            echo "</tr>";
            echo "</table>";
            echo "<script type='text/javascript'>$('#splitPickerID').select2();</script>";
        }
    } else {
        echo "<center><h2>No Order Items Found</h2></center>";
    }
}







?>