<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
include_once("../../../../param.php");

$itemID = 0;

if(isset($_GET['itemID']) && intval($_GET['itemID']) > 0) {
    $itemID = $_GET['itemID'];
}

if(isset($_POST['itemID']) && intval($_POST['itemID']) > 0) {
    $itemID = $_POST['itemID'];
}

if($itemID > 0) {

    global $username, $password, $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $warehouses = array();
    $stmt = $db->prepare("SELECT warehouse_id,warehouse_code,name FROM Warehouses");
    $stmt->execute();
    $stmt->bind_result($warehouse_id, $warehouse_code, $warehouse_name);
    while ($stmt->fetch()) {
        $warehouse = new stdClass();
        $warehouse->warehouse_id = $warehouse_id;
        $warehouse->warehouse_code = $warehouse_code;
        $warehouse->warehouse_name = $warehouse_name;
        $warehouses[$warehouse_id] = $warehouse;
    }
    $stmt->close();

    $lines = array();
    $query = "SELECT warehouse_id,batch_number,order_id,order_code,order_date,SUM(reserved)
              FROM Stock_Updates,Orders 
              WHERE Stock_Updates.action_id=Orders.order_id 
              AND item_id = ? 
              AND action_type = 2 
              AND NOT Orders.status='Canceled' 
              AND `action_id` NOT IN (SELECT from_action_id FROM Stock_Updates WHERE item_id = 10002 AND from_action_type = 2) 
              GROUP BY action_code,warehouse_id, batch_number 
              HAVING SUM(reserved) > 0";

    $stmt = $db->prepare("$query");
    $stmt->bind_param('i', $itemID);
    $stmt->execute();
    $stmt->bind_result( $warehouse_id, $batch_number, $order_id, $order_code, $order_date, $reserved);
    while ($stmt->fetch()) {

        $warehouse = $warehouses[$warehouse_id];

        $line = new stdClass();
        $line->warehouse_code = $warehouse->warehouse_code;
        $line->warehouse_name = $warehouse->warehouse_name;
        $line->batch_number = $batch_number;
        $line->order_id = $order_id;
        $line->order_code = $order_code;
        $line->order_date = $order_date;
        $line->reserved = $reserved;
        array_push($lines, $line);
    }
    $stmt->close();


    if(count($lines) > 0) {

        usort($lines, function($a, $b) {
            return $a->order_date < $b->order_date;
        });

        echo "<table class='table table-bordered table-striped'>";
        echo "<tr style='font-weight: bold;color: white; font-size: 16px;'>";
        echo "<td class='order'>Order</td>";
        echo "<td class='order'>Date</td>";
        echo "<td class='order'>Warehouse</td>";
        echo "<td class='order'>Batch</td>";
        echo "<td class='order'>Location</td>";
        echo "<td class='order'>Reserved</td>";
        echo "</tr>";

        $totalReserved = 0;
        foreach ($lines as $line) {

            $batchBin = explode(';BIN;', "$line->batch_number");
            $batch = $batchBin[0];
            $bin = $batchBin[1];

            if (strcmp("$line->order_date", "0000-00-00") == 0){
                $line->order_date = "";
            } else {
                $line->order_date = date("d-m-Y", strtotime($line->order_date));
            }

            if(strcmp("$batch", "0") == 0){
                $batch = "";
            }

            if(strcmp("$bin", "0") == 0){
                $bin = "";
            }

            echo "<tr>";
            echo "<td>" . $line->order_code . "</td>";
            echo "<td>" . $line->order_date . "</td>";
            echo "<td>" . $line->warehouse_name . "</td>";
            echo "<td>" . $batch . "</td>";
            echo "<td>" . $bin . "</td>";
            echo "<td>" . $line->reserved . "</td>";
            echo "</tr>";

            $totalReserved += $line->reserved;
        }
        echo "<tr>";
        echo "<td class='order' style='font-weight: bold;color: white;' colspan='5' >Total Reserved</td>";
        echo "<td class='order' style='font-weight: bold;color: white;'>" . $totalReserved . "</td>";
        echo "</tr>";
        echo "</table>";
    } else {
        echo "<center><h2>No Reserved Orders found</h2></center>";
    }
}







?>