<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Items';

// Table's primary key
$primaryKey = "item_code";
$warehouseID=$_GET['warehouse_id'];
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(



    array( 'db' => '`i`.`item_code`', 'dt' =>  'code', 'field' =>'item_code' ),
    array( 'db' => '`i`.`name`', 'dt' => 'name', 'field' => 'name' ),
    array( 'db' => '`s`.`batch_number`', 'dt' => 'batch', 'formatter' => function( $d, $row ) {
        $batch = explode(';BIN;', $d)[0];
        if(strcmp($batch,'0')==0){$batch = '';}
        return $batch;
    } , 'field' => 'batch_number' ),
    array( 'db' => '`s`.`batch_number`', 'dt' => 'location', 'formatter' => function( $d, $row ) {
        $location = explode(';BIN;', $d)[1];
        if(strcmp($location,'0')==0){$location = '';}
        return $location;

    } , 'field' => 'batch_number' ),

    array( 'db' => '`s`.`available`', 'dt' => 'qty', 'field' => 'available' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Stock` AS `s` LEFT JOIN  `Items` AS `i` ON (`s`.`item_id` = `i`.`item_id`)";
$where = "`s`.`warehouse_id` ='$warehouseID' AND `s`.`available` > 0";
if(isset($_SESSION['Allow_Items']) && strcmp($_SESSION['Allow_Items'],'')!=0){
    if(strcmp($where,'')!=0){$where .= " AND ";}
    $where .= " `i`.`item_id` IN (".$_SESSION['Allow_Items'].")";
}
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>