<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Cancelled_Actions';
 
// Table's primary key
$primaryKey = "cancelled_id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`o`.`cancelled_id`', 'dt' =>  'id', 'field' =>'cancelled_id' ),
    array( 'db' => '`o`.`code`', 'dt' =>  'document_code', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'code' ),

    array( 'db' => '`o`.`type`', 'dt' =>  'document_type', 'formatter' => function( $d, $row ) {
        $docType = $d;
        $docType = rtrim($docType,'s');
        $noAttachment = $GLOBALS['no_attachment'];
        if(strcmp($docType,'Service_Call')==0){
            $class = "yearly";
            $docType = "settings";

        } else {
            $class = strtolower($docType);

        }
        if($noAttachment){$docType = 'mail';}

        $GLOBALS['class']=$class;
        $GLOBALS['docType']=$docType;
        $d = str_replace('_',' ',$d);

        return $d;
    }, 'field' =>'type' ),

    array( 'db' => '`o`.`time_canceled`', 'dt' =>  'time_canceled', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')==0){
            return '';
        } else {
            return date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i');
        }
        }, 'field' =>'time_canceled' ),

    array( 'db' => '`o`.`date`', 'dt' =>  'document_Date', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00')==0){
            return '';
        } else {
            return date_format( date_create_from_format('Y-m-d', $d), 'd-m-Y');
        }
    }, 'field' =>'date' ),

    array( 'db' => '`c`.`customer_code`', 'dt' =>  'document_customer', 'formatter' => function( $d, $row ) {
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT customer_company_name FROM Customers WHERE customer_code='$d'");
        $stm1-> execute();
        $stm1-> bind_result($name);
        while ($stm1->fetch()) {

        }
        $stm1->close();

        return "$d - $name";
        }, 'field' =>'customer_code' ),
    array( 'db' => '`s`.`salesperson_code`', 'dt' =>  'document_salesperson', 'formatter' => function( $d, $row ) {
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
        $stm1-> execute();
        $stm1-> bind_result($fname,$lname);
        while ($stm1->fetch()) {

        }
        $stm1->close();

        return "$d - $fname $lname";
        }, 'field' =>'salesperson_code' ),
    array( 'db' => '`o`.`user_id`', 'dt' =>  'canceled_by', 'formatter' => function( $d, $row ) {
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$d'");
        $stm1-> execute();
        $stm1-> bind_result($code, $fname,$lname);
        while ($stm1->fetch()) {

        }
        $stm1->close();

        return "$code - $fname $lname";
    }, 'field' =>'user_id' ),
    array( 'db' => '`o`.`subtotal`', 'dt' =>  'subtotal', 'formatter' => function( $d, $row ) {if($d>0){return number_format(floatval($d),2);}}, 'field' =>'subtotal' ),
    array( 'db' => '`o`.`discount_amount`', 'dt' =>  'discount', 'formatter' => function( $d, $row ) {if($d>0){return number_format(floatval($d),2);}}, 'field' =>'discount_amount' ),
    array( 'db' => '`o`.`vat_amount`', 'dt' =>  'vat', 'formatter' => function( $d, $row ) {if($d>0){return number_format(floatval($d),2);}}, 'field' =>'vat_amount' ),
    array( 'db' => '`o`.`grand_total`', 'dt' =>  'total', 'formatter' => function( $d, $row ) {if($d>0){return number_format(floatval($d),2);}}, 'field' =>'grand_total' ),


    array( 'db' => '`o`.`cancelled_id`', 'dt' =>  'image', 'formatter' => function( $d, $row ) {

        $class = $GLOBALS['class'];
        $docType = $GLOBALS['docType'];
        if(strcmp($docType,'Attachment')==0){$imageType = 'pdf';} else {$imageType = $docType;}
        if(strcmp($docType,'mail')==0){$imageType = 'file';}

        return "<td><img class='custom-rounded-image ".$class." center-canvas' src='//".HTML_PATH."/cop/backend/themes/".THEME_NAME."/img/".strtolower($imageType)."icon.png' width='30' height='30'></td>";
    }, 'field' =>'cancelled_id' ),


);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
$where = '';

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Cancelled_Actions` AS `o` LEFT JOIN `Customers` AS `c` ON(`o`.`customer_id`=`c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON(`o`.`salesperson_id`=`s`.`salesperson_id`) ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>