<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Customers';
 
// Table's primary key
$primaryKey = "customer_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
       array( 'db' => '`c`.`logo`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
           if(isset($d) && strcmp($d,'')!=0)
           {


               return '<img class="center-canvas" style="width:auto;height:25px;max-width:50px" src="//' . HTML_PATH . '/cop/media/customersLogos/'.$d.'"></td>';
           }
           else{
               return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/customerdefault.jpg" width="25" height="25"></td>';
           }
           return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/customerdefault.jpg" width="25" height="25"></td>';},
            'field' => 'logo' ),
     array( 'db' => '`c`.`customer_code`',       'dt' =>  'code', 'field' =>'customer_code' ),
       array( 'db' => '`c`.`customer_company_name`',       'dt' => 'name', 'field' => 'customer_company_name' ),
     array( 'db' => '`c`.`mobile`',       'dt' => 'phone' , 'field' => 'mobile' ),
        array( 'db' => '`c`.`email`',       'dt' => 'email','field' => 'email' ),
    array( 'db' => '`c`.`customer_id`', 'dt' => 'address', 'formatter' => function( $d, $row ) {
        global $username,$password,$database;
        $address="";
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city FROM CustomerAddress WHERE customer_id='$d'");
        $stm->execute();
        $stm->bind_result($addressLine1,$addressLine2,$postCode,$city);

        while ($stm->fetch()) {
            $address="$addressLine1 $addressLine2  $postCode $city";

        }
        $stm->close();



        return $address;},
        'field' => 'customer_id' ),
    array( 'db' => '`c`.`customer_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'" class="tableRowForm" target="_blank"  action="//'.HTML_PATH .'/cop/backend/core/views/view/view_crm_customer.php" method="post" style="display:inline;">
           		<input type="hidden" class="customer_id" name="customer_id" value="'.$d.'">		
			</form>
			';},
        'field' => 'customer_id' )
);


// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Customers` AS `c`";
$where='';
if(isset($_GET['group_id']))
{
    $groupID=$_GET['group_id'];
    $where=" `c`.customer_id IN(SELECT customer_id AS customer_id FROM Customer_CustomersGroup WHERE group_id='$groupID')";
}
//$where ="`a`.`primary_address`='yes'";

require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>