<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Projects';

// Table's primary key
$primaryKey = "project_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'project_id',
        'dt' => 'project_id',
        'field' => 'project_id'
    ),

    array(
        'db' => 'project_code',
        'dt' => 'code',
        'field' => 'project_code'
    ),
    array(
        'db' => 'project_name',
        'dt' => 'name',
        'field' => 'project_name'
    ),
    array(
        'db' => 'active',
        'dt' => 'active',
        'field' => 'active'
    ),

    array( 'db' => '`project_id`', 'dt' =>  'form', 'formatter' => function( $d, $row ) {
        $code = $row["project_code"];
        $name = $row["project_name"];
        $active = $row["active"];
        $button = "<a onclick='openEditModal(\"$d\",\"$code\",\"$name\",\"$active\");'>
                        <button type='submit' class='btn btn-primary' style='width:80px'> Edit</button>
                    </a>
                    ";
        return $button;
    }, 'field' =>'project_id'

    )

);

global $username, $password, $database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);



$joinQuery = "FROM `Projects`";
$where='';

require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>