<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
require_once('../../../../param.php');
// DB table to use
$table = 'Receipts';

// Table's primary key
$primaryKey = "receipt_code";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`r`.`receipt_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $GLOBALS['tender_id']=$d;
        return '';}, 'field' => 'receipt_id' ),
    array( 'db' => '`r`.`receipt_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['tender_id'];
        return '<img class="custom-rounded-image receipt center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/receipticon.png" width="30" height="30" onclick="actionHistory('.$id.',\'Receipts\')" title="Track Receipt" ></td>';},
        'field' => 'receipt_code' ),
    array( 'db' => '`r`.`receipt_code`', 'dt' =>  'code', 'field' =>'receipt_code' ),
    array( 'db' => '`r`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'field' => 'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
    array( 'db' => '`r`.`receipt_date`', 'dt' => 'date' ,  'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'receipt_date' ),

    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            return "$d - $fname $lname";



        },


        'field' => 'salesperson_code' ),


    array( 'db' => '`r`.`payment_method`', 'dt' => 'method', 'field' => 'payment_method' ),
    array( 'db' => '`r`.`amount`', 'dt' => 'amount', 'formatter' => function( $d, $row ) {
        global $currencySymbol;
        return $currencySymbol. number_format($d,2);},
        'field' => 'amount' ),
    array( 'db' => '`r`.`status`', 'dt' => 'status', 'field' => 'status' ),

    array( 'db' => '`r`.`receipt_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_receipt.php" method="post" style="display: inline-block; margin-bottom: 3px;">
                    <input type="hidden" name="receipt_id" value="'.$d.'">	           			                   
                    <input style="font-size:13px;" type="submit" class="btn btn-orange" value="View" style="width:60px">
                </form>
                <form id="'.$d.'"action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_receipt.php" method="post" target="_blank" style="display: inline-block; margin-bottom: 3px;">
           		    <input type="hidden" name="receipt_id" value="'.$d.'">	           			                   
			        <input style="font-size:13px;width:60px;" type="submit" class="btn btn-primary" value="Edit" >
			    </form>';},
        'field' => 'receipt_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


//$where = "NOT status ='Canceled' ";

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = '';
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `r`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
$joinQuery = "FROM `Receipts` AS `r` LEFT JOIN `Customers` AS `c` ON (`r`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`r`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>