<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'SC_Priorities';

// Table's primary key
$primaryKey = "priority_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => '`s`.`priority_code`',
        'dt' => 'code',
        'field' => 'priority_code'
    ),
    array(
        'db' => '`s`.`priority_name`',
        'dt' => 'name',
        'field' => 'priority_name'
    ),
    array(
        'db' => '`s`.`priority_level`',
        'dt' => 'priority_level',
        'field' => 'priority_level'
    ),
    array(
    'db' => '`s`.`priority_color`',
    'dt' => 'priority_color',
    'field' => 'priority_color'
),

    array(
    'db' => '`s`.`priority_id`',
    'dt' => 'form',
    'field' => 'priority_id'
    ),
    
    array(
        'db' => '`s`.`priority_code`',
        'dt' => 'code_with_edit',
        'formatter' => function( $d, $row ) {
            $priorityID = $row['priority_id'];
            $priorityField = 'code';
           return "
           <div 
           id='editable-$priorityID' 
           data-field-name='priority_code' 
           data-id='$priorityID' 
           style='position: relative; cursor: pointer;'
           onmouseover='$(this).find(\".fa-pencil\").show();'
           onmouseleave='$(this).find(\".fa-pencil\").hide();'
           onclick='openEditField($priorityID, \"$priorityField\", this);'>
               <span id='value-$priorityField-$priorityID'>$d</span>
               <span id='pen-$priorityField-$priorityID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <input type='text' class='form-control text-center' id='input-$priorityField-$priorityID' value='' style='display:none;'>
           <button id='save-$priorityField-$priorityID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'priority_code'
    ),
    
    array(
        'db' => '`s`.`priority_name`',
        'dt' => 'name_with_edit',
        'formatter' => function( $d, $row ) {
            $priorityID = $row['priority_id'];
            $priorityField = 'name';
            $displayValue = !empty($d) ? $d :'&nbsp;';

          return "
          <div 
          id='editable-$priorityID' 
          data-id='$priorityID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($priorityID, \"$priorityField\", this);'>
              <span id='value-$priorityField-$priorityID'>$displayValue </span>
              <span id='pen-$priorityField-$priorityID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <input type='text' class='form-control text-center' id='input-$priorityField-$priorityID' value='' style='display:none;'>
          <button id='save-$priorityField-$priorityID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'priority_name'
    ),
    
    array(
        'db' => '`s`.`priority_level`',
        'dt' => 'level_with_edit',
        'formatter' => function( $d, $row ) {
            $priorityID = $row['priority_id'];
            $priorityField = 'level';
          return "
          <div 
          id='editable-$priorityID' 
          data-id='$priorityID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($priorityID, \"$priorityField\", this);'>
              <span id='value-$priorityField-$priorityID'>$d</span>
              <span id='pen-$priorityField-$priorityID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <input type='number' class='form-control text-center' id='input-$priorityField-$priorityID' value='' style='display:none;'>
          <button id='save-$priorityField-$priorityID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'priority_level'
    ),

array(
        'db' => '`s`.`priority_color`',
        'dt' => 'priority_color_with_edit',
        'formatter' => function( $d, $row ) {
            $priorityID = $row['priority_id'];
            $priorityField = 'color';
            $colorisChecked = empty($d) ? 'checked' : '';
            $displayValue = !empty($d) ? $d : '#ffffff'; 
            $displayColor = !empty($d) ? $d : 'transparent'; 
          return " <div 
              id='editable-$priorityID' 
              data-id='$priorityID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='initColorChange(\"noColor-$priorityField-$priorityID\",\"priorityColor-$priorityField-$priorityID\",\"input-$priorityField-$priorityID\");openEditField($priorityID, \"$priorityField\", this);'>
                  <span style='color:$displayColor;background-color:$displayColor;border: 1px solid black;width:100px; !important' class='form-control' id='value-$priorityField-$priorityID'>$displayValue</span>
                  <span id='pen-$priorityField-$priorityID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <div id='inputDiv-$priorityField-$priorityID' style='display:none;'>
                <label >No Color:<input type='checkbox' id='noColor-$priorityField-$priorityID' style='margin: 0 5px;vertical-align: middle;width:35px;height:20px;' $colorisChecked > </label>
                <input type='color' class='form-control' id='priorityColor-$priorityField-$priorityID' style='width: 20%;' value='$displayValue'>
                <input type='hidden' class='form-control text-center' id='input-$priorityField-$priorityID' value='' style='display:none;'>
              <button id='save-$priorityField-$priorityID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
           <div>
          ";
        },
        'field' => 'priority_color'
    )
);

// SQL server connection information
global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `SC_Priorities` AS `s`";  // No joins needed for prioritys table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>