<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once('../../../../param.php');
// DB table to use
$table = 'Service_Call';

// Table's primary key
$primaryKey = "service_call_id";

$salespersonID = $_GET['salespersonID'];
$status=$_GET['status'];
$user =$_GET['user'];
$groupID =$_GET['groupID'];
$serialNumberID=$_GET['serialNumberID'];
$serviceCallNewID;
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`s`.`service_call_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $GLOBALS['serviceCallNewID']=$d;
        return '<img class="custom-rounded-image monthly center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/settingsicon.png" width="30" height="30"></td>';},
        'field' => 'service_call_id' ),
    array( 'db' => '`s`.`service_call_code`', 'dt' => 'code', 'field' => 'service_call_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
    array( 'db' => '`t`.`type_name`', 'dt' => 'type', 'field' => 'type_name' ),


    array( 'db' => '`s`.`topic`', 'dt' => 'topic' , 'field' => 'topic' ),

    array( 'db' => '`response`.`lresponse`', 'dt' => 'lresponse' , 'formatter' => function( $d, $row ) {
        return "<span style='font-weight:bold;color:#333'>$d</span>";}, 'field' => 'lresponse' ),
    array( 'db' => '`response`.`lresponsetime`', 'dt' => 'lresponsetime' , 'formatter' => function( $d, $row ) {
        if(isset($d)) {
            $d = date('d-m-Y H:i:s', strtotime($d));
        }
        return "<span style='font-weight:bold;color:#333'>$d</span>";}, 'field' => 'lresponsetime' ),

    array( 'db' => '`scp`.`priority_name`', 'dt' => 'priority', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"Emergency") == 0)
        {
            return '<span style="color:#b22222">'.$d.' </span>';
        }
        else if(strcmp($d,"High") == 0)
        {
            return '<span style="color:steelblue">'.$d.' </span>';
        }
        else
        {
            return $d;
        }

    },'field' => 'priority_name' ),
    array( 'db' => '`sa`.`salesperson_code`', 'dt' => 'sal', 'formatter' => function( $d, $row ) {
        $GLOBALS['salepersonCode']=$d;
        return"";

    }, 'field' => 'salesperson_code' ),
    array( 'db' => '`sa`.`salesperson_code`', 'dt' => 'salespersonid', 'formatter' => function( $d, $row ) {

        $p = $GLOBALS['serviceCallNewID'];
        $salesP=$GLOBALS['salepersonCode'];

        $options=" <select class='form-control serviceCallAssign'  id='serviceCallAssign' name='serviceCallAssign' onchange='changeAssignTo(this,$p)'>";
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT salesperson_id,salesperson_code,CONCAT(salesperson_code,' ',first_name,' ',last_name),status FROM SalesPersons");
        $stm->execute();
        $stm->bind_result($salespersonID,$salespersonCode,$salespersonName,$status);

        while ($stm->fetch()) {
            if(strcmp($salesP,$salespersonCode)==0){
                if(strcmp($status,'disabled')!=0) {
                    $options .= "<option onclick='' value='$salespersonID' selected>$salespersonName</option>";
                } else {
                    $options .= "<option onclick='' value='$salespersonID' selected disabled>$salespersonName</option>";
                }
            }
            else{
                if(strcmp($status,'disabled')!=0) {
                    $options .= "<option onclick='' value='$salespersonID'>$salespersonName </option>";
                }
            }

        }
        $stm->close();

        $options.="</select>";
        return $options;

    }, 'field' => 'salesperson_code' ),
    array( 'db' => '`st`.`status_name`', 'dt' => 'statusid', 'formatter' => function( $d, $row ) {

        $p = $GLOBALS['serviceCallNewID'];
   $options=" <select class='form-control serviceCallStatus'  id='serviceCallStatus' name='serviceCallStatus' onchange='changeStatus(this,$p)'>";
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT status_id,status_name FROM SC_Status");
        $stm->execute();
        $stm->bind_result($statusID,$statusName);

        while ($stm->fetch()) {
            if(strcmp($d,$statusName)==0){
                $options.= "<option onclick='' value='$statusID' selected>$statusName</option>";
            }
            else{
                $options.= "<option onclick='' value='$statusID'>$statusName </option>";
            }

        }
        $stm->close();

        $options.="</select>";
      return $options;

    }, 'field' => 'status_name' ),
    array( 'db' => '`s`.`service_call_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {

        return '<form id="'.$d.'" class="tableRowForm" target="_blank"  action="//'.HTML_PATH .'/cop/backend/modules/service/views/service_call.php" method="post" style="display:inline;">
           		<input type="hidden" class="service_call_id" name="service_call_id" value="'.$d.'">		
			</form>
			'

            ;},
        'field' => 'service_call_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Service_Call` AS `s` LEFT JOIN `SC_Types` AS `t` ON (`s`.`type_id` = `t`.`type_id` ) LEFT JOIN `SC_Status` AS `st` ON (`s`.`status_id` = `st`.`status_id` ) LEFT JOIN `Customers` AS `c` ON (`c`.`customer_id` = `s`.`customer_id`) LEFT JOIN `SalesPersons` AS `sa` ON (`s`.`assign_to` = `sa`.`salesperson_id` ) LEFT JOIN `SC_Priorities` AS `scp` ON (`s`.`priority_id` = `scp`.`priority_id` ) LEFT JOIN (SELECT service_call_id AS `serid`,details AS `lresponse`,MAX(date) AS `lresponsetime` FROM  `Service_Call_Reply` AS `p` GROUP BY service_call_id) AS `response`  ON `response`.serid= `s`.service_call_id";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
if(isset($salespersonID) &&strcmp($salespersonID,"")!=0 &&isset($status)&&strcmp($status,"")!=0)
{
    $where="`s`.assign_to=$salespersonID AND `s`.status_id=$status";
}
else if(isset($user))
{
    $where="`s`.salesperson_id=$user";
}
else if(isset($groupID))
{
    $where="`c`.customer_id IN(SELECT customer_id AS customer_id FROM Customer_CustomersGroup WHERE group_id='$groupID')";
}
else if(isset($serialNumberID))
{
    $where="`s`.serial_number_id=$serialNumberID";
}
else{
    $where='';
}


if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `s`.`assign_to` IN (".$_SESSION['Allow_Salespersons'].")";
}


echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>