<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Warehouse_Transactions';
// Table's primary key
$primaryKey = "warehouse_transaction_id";
$types = "'Transfer Pending Confirmation'";
$types .= ",'Canceled Transfer Pending Confirmation'";
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`t`.`warehouse_transaction_id`', 'dt' => 'id', 'formatter' => function( $d, $row ) {$GLOBALS['warehouse_transaction_id']=$d;return $d;}, 'field' => 'warehouse_transaction_id' ),
    array( 'db' => '`t`.`type`', 'dt' => 'type', 'formatter' => function( $d, $row ) {$GLOBALS['reqType']=$d;return $d;}, 'field' => 'type' ),
    array( 'db' => '`t`.`warehouse_transaction_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $type = $GLOBALS['reqType'];

        switch ($type){
            case 'Load Request':
                $icon = 'unloadicon';
                $class= 'tender';
                break;
            case 'Unload Request':
                $icon = 'loadicon';
                $class= 'order';
                break;
            default:
                $icon = 'transfericon';
                $class= 'invoice';

        }

        return '<img class="custom-rounded-image '.$class.' center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/'.$icon.'.png" width="30" height="30"></td>';},
        'field' => 'warehouse_transaction_code' ),
    array( 'db' => '`t`.`warehouse_transaction_code`', 'dt' => 'excode', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['warehouse_transaction_id'];
        return getExecutionCode($id,$d);},
        'field' => 'warehouse_transaction_code' ),
    array( 'db' => '`t`.`warehouse_transaction_code`', 'dt' => 'exform', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['warehouse_transaction_id'];
        $forms = getExecutionForms($d);
        if(strcmp($forms,'Confirmation Pending')==0){
            $GLOBALS['pending'] = true;
        } else {
            $GLOBALS['pending'] = false;
        }
        return $forms;},
        'field' => 'warehouse_transaction_code' ),
     array( 'db' => '`t`.`warehouse_transaction_code`', 'dt' =>  'code', 'field' =>'warehouse_transaction_code' ),

    array( 'db' => '`t`.`warehouse_id_from`', 'dt' => 'from', 'formatter' => function( $d, $row ) {
        return  getWarehouseCode($d);},
        'field' => 'warehouse_id_from' ),
    array( 'db' => '`t`.`warehouse_id_to`', 'dt' => 'to', 'formatter' => function( $d, $row ) {
        return  getWarehouseCode($d);},
        'field' => 'warehouse_id_to' ),
     array( 'db' => '`t`.`transaction_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
         return  date_format( date_create_from_format('Y-m-d', $d), 'd-m-Y');},
         'field' => 'transaction_date' ),

            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),

    array( 'db' => '`t`.`action_time`', 'dt' => 'actionTime' , 'formatter' => function( $d, $row ) {
        $timezone = 'Europe/Athens';
        date_default_timezone_set($timezone);
        $timestamp = strtotime($d);
        $local_time = $timestamp + date('Z');
        $local_date = date('d-m-Y H:i:s', $local_time);
        return $local_date;},
        'field' => 'action_time' ),

     array( 'db' => '`t`.`warehouse_transaction_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {


         $type = $GLOBALS['reqType'];

         if($GLOBALS['pending']  && strpos($type, 'Canceled') === false){
             $extraButton = '
             <form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer.php" method="post" style="display: inline-block;">
           		<input type="hidden" name="wt_id" value="'.$d.'">
			<button type="submit" class="btn btn-success"  style="width:80px;font-size:13px;border-radius: 5px;margin: 1px;">Confirm</button>
			</form>
             ';
         }
                return '<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_warehouse_transaction.php" method="post" style="display: inline-block;"> 
           		<input type="hidden" name="warehouse_transaction_id" value="'.$d.'">
			<input type="submit" class="btn btn-primary" value="View" style="width:60px;font-size:13px;border-radius: 5px;margin: 1px;">
			</form>
			<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer_request.php" method="post" style="display: inline-block;">
           		<input type="hidden" name="wt_id" value="'.$d.'">
			<input type="submit" class="btn btn-invoice" value="Edit" style="width:60px;font-size:13px;border-radius: 5px;margin: 1px;">
			</form>'.$extraButton;
         },
            'field' => 'warehouse_transaction_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Warehouse_Transactions` AS `t` LEFT JOIN `SalesPersons` AS `s` ON (`t`.`salesperson_id` = `s`.`salesperson_id`)";
$extraWhere = " `t`.`type` IN ($types) ";
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($extraWhere,'')!=0){$extraWhere.= " AND ";}
    $extraWhere .= " `t`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}

if (isset($_GET['fromWarehouseCodeFilter']) && !empty($_GET['fromWarehouseCodeFilter'])) {
    $fromWarehouseCodeFilter = trim($_GET['fromWarehouseCodeFilter']);
    if (!empty($extraWhere)) {
        $extraWhere .= " AND ";
    }
    $joinQuery .= " INNER JOIN Warehouses AS w1 ON w1.warehouse_id = `t`.`warehouse_id_from` ";
    $extraWhere .= " w1.warehouse_code LIKE '" . $fromWarehouseCodeFilter . "%'";
}

if (isset($_GET['toWarehouseCodeFilter']) && !empty($_GET['toWarehouseCodeFilter'])) {
    $toWarehouseCodeFilter = trim($_GET['toWarehouseCodeFilter']);
    if (!empty($extraWhere)) {
        $extraWhere .= " AND ";
    }
    $joinQuery .= " INNER JOIN Warehouses AS w2 ON w2.warehouse_id = `t`.`warehouse_id_to` ";
    $extraWhere .= " w2.warehouse_code LIKE '" . $toWarehouseCodeFilter . "%'";
}

require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$extraWhere)
     );


function getWarehouseCode($warehouseID) {
            global $username,$password,$database;

            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db1->set_charset("utf8");

            $stm1 = $db1->prepare("SELECT warehouse_code FROM Warehouses WHERE warehouse_id='$warehouseID'");
            $stm1-> execute();
            $stm1-> bind_result($warehouseCode);
            while ($stm1->fetch()) {
                return $warehouseCode;
            }
            $stm1->close();
            return $warehouseCode;


        }

function getExecutionCode($warehouseTransactionID,$warehouseTransactionCode) {
    global $username,$password,$database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT Warehouse_Transactions.warehouse_transaction_code FROM Warehouse_Transactions_Request_Transactions,Warehouse_Transactions WHERE Warehouse_Transactions_Request_Transactions.transaction_id=Warehouse_Transactions.warehouse_transaction_id AND Warehouse_Transactions_Request_Transactions.request_id='$warehouseTransactionID' ORDER BY Warehouse_Transactions_Request_Transactions.timestamp DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($warehouseCode);
    while ($stm1->fetch()) {
        return "<b>$warehouseCode</b>";
    }
    $stm1->close();

    $stm1 = $db1->prepare("SELECT warehouse_transaction_code FROM Warehouse_Transactions WHERE details LIKE 'From Request $warehouseTransactionCode%'");
    $stm1-> execute();
    $stm1-> bind_result($warehouseCode);
    while ($stm1->fetch()) {
        return $warehouseCode;
    }
    $stm1->close();

    return $warehouseCode;


}

function getExecutionForms($warehouseTransactionCode) {
    global $username,$password,$database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT transaction_id FROM Warehouse_Transactions_Request_Transactions,Warehouse_Transactions WHERE Warehouse_Transactions_Request_Transactions.request_id=Warehouse_Transactions.warehouse_transaction_id AND Warehouse_Transactions.warehouse_transaction_code='$warehouseTransactionCode' ORDER BY Warehouse_Transactions_Request_Transactions.timestamp DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($d);
    while ($stm1->fetch()) {
        return '<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_warehouse_transaction.php" method="post" style="display: inline-block;" class="transferred"> 
           		<input type="hidden" name="warehouse_transaction_id" value="'.$d.'">
			<input type="submit" class="btn btn-primary" value="View" style="width:60px;font-size:13px;border-radius: 5px;margin: 1px;">
			</form>
			<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer.php" method="post" style="display: inline-block;">
           		<input type="hidden" name="wt_id" value="'.$d.'">
			<input  type="submit" class="btn btn-success" value="Edit" style="width:60px;font-size:13px;border-radius: 5px;margin: 1px;">
			</form>
			';    }
    $stm1->close();

    $stm1 = $db1->prepare("SELECT warehouse_transaction_id FROM Warehouse_Transactions WHERE details LIKE 'From Request $warehouseTransactionCode%'");
    $stm1-> execute();
    $stm1-> bind_result($d);
    while ($stm1->fetch()) {
        return '<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_warehouse_transaction.php" method="post" style="display: inline-block;" class="transferred"> 
           		<input type="hidden" name="warehouse_transaction_id" value="'.$d.'">
			<input  type="submit" class="btn btn-primary" value="View" style="width:60px;font-size:13px;border-radius: 5px;margin: 1px;">
			</form>
			<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer.php" method="post" style="display: inline-block;">
           		<input type="hidden" name="wt_id" value="'.$d.'">
			<input  type="submit" class="btn btn-invoice" value="Edit" style="width:60px;font-size:13px;border-radius: 5px;margin: 1px;">
			</form>
			';
    }
    $stm1->close();


    $type = $GLOBALS['reqType'];
    if(strpos("$type", 'Canceled') === false){
        return 'Confirmation Pending';
    } else {
        return '';
    }


}

     ?>