<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'ZE_Z_Report';
 
// Table's primary key
$primaryKey = "lock_number";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => 'DISTINCT(`z`.`lock_number`)', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image return center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/ordericon.png" width="30" height="30"></td>';},
        'field' => 'lock_number' ),
     array( 'db' => '`z`.`lock_number`', 'dt' =>  'code', 'field' =>'lock_number' ),
    array( 'db' => '`z`.`start_z_time`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y H:i:s',strtotime($d));},'field' => 'start_z_time' ),
     array( 'db' => '`z`.`z_date`', 'dt' => 'stDate' , 'formatter' => function( $d, $row ) {
         return date('d-m-Y H:i:s',strtotime($d));},'field' => 'z_date' ),
    array( 'db' => '`s`.`salesperson_code`', 'dt' =>  'spCode', 'field' =>'salesperson_code' ),
    array( 'db' => '`s`.`first_name`', 'dt' =>  'fist', 'field' =>'first_name' ),
    array( 'db' => '`s`.`last_name`', 'dt' =>  'last', 'field' =>'last_name' ),

     array( 'db' => '`z`.`lock_number`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
//                return '<form style="display:inline;" id="'.$d.'"  action="//'.HTML_PATH .'/cop/backend/core/views/view/view_z_report.php" method="post">
//           		<input type="hidden" name="z_report_number" value="'.$d.'">
//			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
//			</form>
//
//
//			';
         if(file_exists(ROOT.'media/pdfs/zreports/ZReport'.$d.'.pdf')){
             $pdfButton =
                 "<form method='POST' action='//".HTML_PATH."/cop/readPDF.php' target='_blank' style='display:inline;' >
                   <input type='hidden' name='code' value='$d'/>
                   <input type='hidden' name='type' value='zreports'/>
                    <button type='submit' class='btn btn-tender' style='text-transform: capitalize;width:70px;display:inline;' id='invoicePDFButton'><i class='fa fa-file-pdf-o'></i>&nbsp; PDF</button>
                 </form>";
         } else {
             $pdfButton = "";
         }

        return '<button style="font-size:13px;display:inline;" type="button" class="btn btn-return" style="width:70px" onclick="actionHistory(\''.$d.'\')">view</button>'.$pdfButton;

     },
            'field' => 'lock_number' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `ZE_Z_Report` AS `z` LEFT JOIN `SalesPersons` AS `s` ON (`z`.`salesperson_id` = `s`.`salesperson_id`)";
if (isset($_GET['onlyReceipt']) && strcmp($_GET['onlyReceipt'],'')!=0){
    $onlyThis = $_GET['onlyReceipt'];
    if (strcmp($onlyThis,'Receipts')==0){
        $extraWhere = "  `z`.`document_type`='$onlyThis' AND `z`.`document_id` NOT IN(SELECT receipt_id FROM Receipts WHERE status='Confirmed')";
    }else{
        $extraWhere = " `z`.`document_type`='$onlyThis'";
    }
}else{
    $extraWhere = "";
}

$groupBy = '`z`.`lock_number`';
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$extraWhere,$groupBy)
     );
     
     ?>