<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Warehouse_Transactions';
//$warehouseID =$_GET['warehouseID'];
// Table's primary key
$primaryKey = "warehouse_transaction_id";
$lockNumberZreport = $_GET['lockNumber'];
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`t`.`warehouse_transaction_code`', 'dt' =>  'code', 'field' =>'warehouse_transaction_code' ),
    array( 'db' => '`t`.`type`', 'dt' => 'type', 'field' => 'type' ),
    array( 'db' => '`t`.`warehouse_id_from`', 'dt' => 'from', 'formatter' => function( $d, $row ) {
        return  getWarehouseCode($d);},
        'field' => 'warehouse_id_from' ),
    array( 'db' => '`t`.`warehouse_id_to`', 'dt' => 'to', 'formatter' => function( $d, $row ) {
        return  getWarehouseCode($d);},
        'field' => 'warehouse_id_to' ),
    array( 'db' => '`t`.`transaction_date`', 'dt' => 'date' , 'field' => 'transaction_date' ),
    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
    array( 'db' => '`t`.`warehouse_transaction_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_warehouse_transaction.php" method="post" style="display: inline-block;"> 
           		<input type="hidden" name="warehouse_transaction_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
			</form>
			<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer.php" method="post" style="display: inline-block;">
           		<input type="hidden" name="wt_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-success" value="Edit" style="width:60px">
			</form>
			';},
        'field' => 'warehouse_transaction_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = '';

if(isset($lockNumberZreport) && strcmp($lockNumberZreport,'')!=0){
    global $username,$password,$database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $arrayFilterOrders = array();
    $stm = $db->prepare("SELECT document_id FROM ZE_Z_Report WHERE lock_number='$lockNumberZreport' AND document_type='Warehouse_Transactions' ");
    $stm->execute();
    $stm->bind_result($docID);
    while ($stm->fetch()) {
        array_push($arrayFilterOrders,$docID);
    }
    $stm->close();

    if (count($arrayFilterOrders)>0){
        $arrayFilterOrdersImplode = implode(',',$arrayFilterOrders);
        if(strcmp($where,'')!=0){$where.= " AND ";}
        $where .= " `t`.`warehouse_transaction_id` IN ($arrayFilterOrdersImplode)";
    }else{
        if(strcmp($where,'')!=0){$where.= " AND ";}
        $where .= " 0=1";
    }


//    if(strcmp($where,'')!=0){$where.= " AND ";}
//    $where .= " `zer`.`lock_id` = '$lockNumberZreport'";
}

$joinQuery = "FROM `Warehouse_Transactions` AS `t`  LEFT JOIN `SalesPersons` AS `s` ON (`t`.`salesperson_id` = `s`.`salesperson_id`) ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);
function getWarehouseCode($warehouseID) {
    global $username,$password,$database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT warehouse_code FROM Warehouses WHERE warehouse_id='$warehouseID'");
    $stm1-> execute();
    $stm1-> bind_result($warehouseCode);
    while ($stm1->fetch()) {
        return $warehouseCode;
    }
    $stm1->close();
    return $warehouseCode;


}
?>