<?php
include_once '../../../param.php';

class CopNavigation
{
    private $codeFilter;
    private $idColumn;
    private $codeColumn;
    private $table;
    private $where;
    private $buttonLabels;
    private $class;
    private $viewEdit;

    function setCodeFilter($codeFilter){$this->codeFilter = $codeFilter;}
    function setIdColumn($idColumn){$this->idColumn = $idColumn;}
    function setCodeColumn($codeColumn){$this->codeColumn = $codeColumn;}
    function setTable($table){$this->table = $table;}
    function setWhere($where){
        if(strcmp(trim($where),'')!=0){
            $this->where = str_replace('AND AND','AND',' AND '.$where);
        }


    }
    function setClass($class){$this->class = $class;}
    function setViewEdit($viewEdit){$this->viewEdit = $viewEdit;}
    function setButtonLabels($buttonLabels){$this->buttonLabels = $buttonLabels;}

    public function __construct($table,$redirectFileName, $codeFilter,$where=''){

        $buttonLabels = str_replace('Purchase_','',$table);
        $buttonLabels = str_replace('_Draft','',$buttonLabels);
        $buttonLabels = trim($buttonLabels,'s');
        $class = strtolower($buttonLabels);

        $idColumn   = $class."_id";
        $codeColumn = $class."_code";

        switch ($buttonLabels) {
            case 'Order':
                $class = 'primary';
                break;
            case 'Receipt':
                $class = 'orange';
                break;
            case 'Warehouse':
                $class = 'primary';
                break;
            case 'Warehouse_Transaction':
                $class = 'invoice';
                break;
            case 'Customer_Stock_Taking':
                $class = 'purple';
                break;
            default:
                $class = strtolower($buttonLabels);
        }

        $this->setTable($table);
        $this->setIdColumn($idColumn);
        $this->setCodeColumn($codeColumn);
        $this->setCodeFilter($codeFilter);
        $this->setWhere($where);
        $this->setClass($class);
        $this->setButtonLabels($buttonLabels);
        $this->setViewEdit($redirectFileName);

    }

    public function simpleNavigationTable($idGetParameter = '',$directory=''){

        if(strcmp($idGetParameter,'')==0){
            $idGetParameter = $this->idColumn;
        }

        global $username,$password,$database;
        $db = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");


        $stm5 = $db->prepare("SELECT $this->idColumn FROM $this->table WHERE $this->codeColumn > '$this->codeFilter' $this->where ORDER BY $this->codeColumn ASC LIMIT 1");
        $stm5->execute();
        $stm5->bind_result($nextID);
        while ($stm5->fetch()) {}
        $stm5->close();

        if(strcmp($nextID,'')==0 || $nextID == 0 ){
            $stm5 = $db->prepare("SELECT $this->idColumn FROM $this->table ORDER BY $this->codeColumn ASC LIMIT 1");
            $stm5->execute();
            $stm5->bind_result($nextID);
            while ($stm5->fetch()) {}
            $stm5->close();
        }

        $stm5 = $db->prepare("SELECT $this->idColumn FROM $this->table WHERE $this->codeColumn < '$this->codeFilter' $this->where ORDER BY $this->codeColumn DESC LIMIT 1");
        $stm5->execute();
        $stm5->bind_result($prevID);
        while ($stm5->fetch()) {}
        $stm5->close();

        if(strcmp($prevID,'')==0 || $prevID == 0){
            $stm5 = $db->prepare("SELECT $this->idColumn FROM $this->table ORDER BY $this->codeColumn DESC LIMIT 1");
            $stm5->execute();
            $stm5->bind_result($prevID);
            while ($stm5->fetch()) {}
            $stm5->close();
        }

        if(strcmp($directory,'')==0){$directory = "backend/core/views/view";}

        echo "
                    <table style='border-collapse: collapse;' class='pull-right'>
                        <tr>
                            <td>&nbsp;</td>
                            <td >
                                <a class='btn btn-$this->class' style='width: 60px;padding: 4px;' title='Previous $this->buttonLabels' href='//".HTML_PATH."/cop/$directory/$this->viewEdit.php?$idGetParameter=$prevID'>
                                    <i class='fa fa-angle-left'></i> Prev.
                                </a>
                            </td>
                            <td>&nbsp;</td>
                            <td >
                               <a class='btn btn-$this->class' style='width: 60px;padding: 4px;' title='Next $this->buttonLabels' href='//".HTML_PATH."/cop/$directory/$this->viewEdit.php?$idGetParameter=$nextID'>
                                    Next <i class='fa fa-angle-right'></i>
                               </a>
                            </td>
                            <td>&nbsp;</td>
                        </tr>
                     </table>
        ";
    }
}