<?php

/**
 * Created by PhpStorm.
 * User: hp
 * Date: 11/02/2016
 * Time: 10:53
 */
class Customer
{
    public $customerID;
    public $customerCode;
    public $companyName;
    public $reportName;
    public $logo;
    public $registrationCode;
    public $mobile;
    public $website;
    public $email;
    public $description;
    public $typeOfBusiness;
    public $ticCode;
    public $vatCode;
    public $creditLimit;
    public $typeOfCustomer;
    public $balance;
    public $addressCodeEurosoft;


    public $customerPriceLists = array();
    public $customerAddresses = array();
    public $customerGroups = array();
    public $customerPriceGroups = array();
    public $customerSchedules = array();
    public $customForms = array();




    public function __construct($customerID, $customerCode, $companyName, $reportName="", $logo="", $registrationCode="", $mobile="", $website="", $email="", $description="", $typeOfBusiness="", $ticCode="", $vatCode="", $creditLimit="", $typeOfCustomer="", $balance="", $addressCodeEurosoft='')
    {
        $this->customerID = $customerID;
        $this->customerCode = $customerCode;
        $this->companyName = $companyName;
        $this->reportName = $reportName;
        $this->logo = $logo;
        $this->registrationCode = $registrationCode;
        $this->mobile = $mobile;
        $this->website = $website;
        $this->email = $email;
        $this->description = $description;
        $this->typeOfBusiness = $typeOfBusiness;
        $this->ticCode = $ticCode;
        $this->vatCode = $vatCode;
        $this->creditLimit = $creditLimit;
        $this->typeOfCustomer = $typeOfCustomer;
        $this->balance = $balance;
        $this->addressCodeEurosoft = $addressCodeEurosoft;
    }

    /**
     * @return mixed
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }

    /**
     * @param mixed $customerID
     */
    public function setCustomerID($customerID)
    {
        $this->customerID = $customerID;
    }

    /**
     * @return mixed
     */
    public function getCustomerCode()
    {
        return $this->customerCode;
    }

    /**
     * @param mixed $customerCode
     */
    public function setCustomerCode($customerCode)
    {
        $this->customerCode = $customerCode;
    }

    /**
     * @return mixed
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }

    /**
     * @param mixed $companyName
     */
    public function setCompanyName($companyName)
    {
        $this->companyName = $companyName;
    }

    /**
     * @return mixed|string
     */
    public function getReportName()
    {
        return $this->reportName;
    }

    /**
     * @param mixed|string $reportName
     */
    public function setReportName($reportName)
    {
        $this->reportName = $reportName;
    }

    /**
     * @return mixed|string
     */
    public function getLogo()
    {
        return $this->logo;
    }

    /**
     * @param mixed|string $logo
     */
    public function setLogo($logo)
    {
        $this->logo = $logo;
    }

    /**
     * @return mixed
     */
    public function getRegistrationCode()
    {
        return $this->registrationCode;
    }

    /**
     * @param mixed $registrationCode
     */
    public function setRegistrationCode($registrationCode)
    {
        $this->registrationCode = $registrationCode;
    }

    /**
     * @return mixed
     */
    public function getMobile()
    {
        return $this->mobile;
    }

    /**
     * @param mixed $mobile
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;
    }

    /**
     * @return mixed
     */
    public function getWebsite()
    {
        return $this->website;
    }

    /**
     * @param mixed $website
     */
    public function setWebsite($website)
    {
        $this->website = $website;
    }

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param mixed $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param mixed $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return mixed
     */
    public function getTypeOfBusiness()
    {
        return $this->typeOfBusiness;
    }

    /**
     * @param mixed $typeOfBusiness
     */
    public function setTypeOfBusiness($typeOfBusiness)
    {
        $this->typeOfBusiness = $typeOfBusiness;
    }

    /**
     * @return mixed
     */
    public function getTicCode()
    {
        return $this->ticCode;
    }

    /**
     * @param mixed $ticCode
     */
    public function setTicCode($ticCode)
    {
        $this->ticCode = $ticCode;
    }

    /**
     * @return mixed
     */
    public function getVatCode()
    {
        return $this->vatCode;
    }

    /**
     * @param mixed $vatCode
     */
    public function setVatCode($vatCode)
    {
        $this->vatCode = $vatCode;
    }

    /**
     * @return mixed
     */
    public function getCreditLimit()
    {
        return $this->creditLimit;
    }

    /**
     * @param mixed $creditLimit
     */
    public function setCreditLimit($creditLimit)
    {
        $this->creditLimit = $creditLimit;
    }

    /**
     * @return mixed
     */
    public function getTypeOfCustomer()
    {
        return $this->typeOfCustomer;
    }

    /**
     * @param mixed $typeOfCustomer
     */
    public function setTypeOfCustomer($typeOfCustomer)
    {
        $this->typeOfCustomer = $typeOfCustomer;
    }

    /**
     * @return mixed
     */
    public function getBalance()
    {
        return $this->balance;
    }

    /**
     * @param mixed $balance
     */
    public function setBalance($balance)
    {
        $this->balance = $balance;
    }

    /**
     * @return mixed|string
     */
    public function getAddressCodeEurosoft()
    {
        return $this->addressCodeEurosoft;
    }

    /**
     * @param mixed|string $addressCodeEurosoft
     */
    public function setAddressCodeEurosoft($addressCodeEurosoft)
    {
        $this->addressCodeEurosoft = $addressCodeEurosoft;
    }

    public function getCustomerPriceGroups()
    {
        return $this->customerPriceGroups;
    }


    public function setCustomerPriceGroups($customerPriceGroups)
    {
        $this->customerPriceGroups = $customerPriceGroups;
        return $this;
    }

    public function addCustomerPriceGroup($customerPriceGroup)
    {
        array_push($this->customerPriceGroups,$customerPriceGroup);
        return $this;
    }


    public function getCustomerSchedules()
    {
        return $this->customerSchedules;
    }


    public function setCustomerSchedules($customerSchedules)
    {
        $this->customerSchedules = $customerSchedules;
        return $this;
    }

    public function addCustomerSchedule($customerSchedule)
    {
        array_push($this->customerSchedules,$customerSchedule);
        return $this;
    }

    public function getCustomerAddresses()
    {
        return $this->customerAddresses;
    }


    public function setCustomerAddresses($customerAddresses)
    {
        $this->customerAddresses = $customerAddresses;
        return $this;
    }

    public function addCustomerAddress($customerAddress)
    {
        array_push($this->customerAddresses,$customerAddress);
        return $this;
    }


    public function getCustomerGroups()
    {
        return $this->customerGroups;
    }


    public function setCustomerGroups($customerGroups)
    {
        $this->customerGroups = $customerGroups;
        return $this;
    }

    public function addCustomerGroup($customerGroup)
    {
        array_push($this->customerGroups,$customerGroup);
        return $this;
    }


    public function getCustomForms()
    {
        return $this->customForms;
    }


    public function setCustomForms($customForms)
    {
        $this->customForms = $customForms;
        return $this;
    }

    public function addCustomerCustomForm($customerCustomForm)
    {
        array_push($this->customForms,$customerCustomForm);
        return $this;
    }

    /**
     * @return array
     */
    public function getCustomerPriceLists()
    {
        return $this->customerPriceLists;
    }

    /**
     * @param array $customerPriceLists
     * @return Customer
     */
    public function setCustomerPriceLists($customerPriceLists)
    {
        $this->customerPriceLists = $customerPriceLists;
        return $this;
    }

    public function getCustomerPrimaryPriceList()
    {

        if(!empty($this->customerPriceLists)){
            return $this->customerPriceLists[0];
        } else {
            return null;
        }

    }

    public function addCustomerPriceList($customerPriceList)
    {
        array_push($this->customerPriceLists,$customerPriceList);
        return $this;
    }




}