<?php

// -- Andreas Spanos @ 05/07/2019 : Added Item Images to Report. -- //
// -- Andreas Spanos @ 08/07/2019 : Added Barcode to Report. -- //
// -- Andreas Spanos @ 25/07/2019 : Made images larger. -- //

error_reporting(100);
include_once("../../../../param.php");
require(ROOT . 'libs/phpexcel/vendor/autoload.php');

$orderID = trim($_POST['orderID']);
$orderCode = trim($_POST['orderCode']);

$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT order_code,order_date,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,delivery_address_id FROM Orders WHERE order_id='$orderID'");
$stm->execute();
$stm->bind_result($orderCode, $orderDate, $salespersonID,$subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddress);
while ($stm->fetch()) {}
$stm->close();

if(strcmp("$orderDate",'0000-00-00')!=0 && strcmp("$orderDate",'')!=0) {
    $orderDate = date_format(date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
} else {
    $orderDate = '';
}
$subtotal   = number_format(floatVal($subtotal),2);
$grandTotal = number_format(floatVal($grandTotal),2);
$vatAmount  = number_format(floatVal($vatAmount),2);


$stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
$stm->execute();
$stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
while ($stm->fetch()) {}
$stm->close();


$stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
$stm->execute();
$stm->bind_result($customerCode, $customerName);
while ($stm->fetch()) {}
$stm->close();


$stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
$stm->execute();
$stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);
while ($stm->fetch()) {}
$stm->close();

$stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddress'");
$stm->execute();
$stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
while ($stm->fetch()) {}
$stm->close();

$stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
$stm->execute();
$stm->bind_result($salespersonDisplayName);
while ($stm->fetch()) {}
$stm->close();



$displayDate =$orderDate;


$objPHPExcel = new PHPExcel();


$objPHPExcel->getActiveSheet()->mergeCells('D1:F1');
$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
$objPHPExcel->getActiveSheet()->mergeCells('D11:F11');



$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('D1', 'ΠΑΡΑΓΓΕΛΙΑ - ORDER')
    //-- COMPANY DETAILS --//
    ->setCellValue('J1', $line1)
    ->setCellValue('J2', $line2)
    ->setCellValue('J3', $line3)
    ->setCellValue('J4', $line4)
    ->setCellValue('J5', $line5)
    ->setCellValue('J6', $line6)
    ->setCellValue('J7', $line7)
;

$objPHPExcel->setActiveSheetIndex(0)
    // -- ORDER DETAILS --//
    ->setCellValue('A9' , 'Order Details')
    ->setCellValue('A10', 'Αρ. Παραγγελίας / Order No: ')
    ->setCellValue('C10', $orderCode)
    ->setCellValue('A11', 'Ημερ. / Date: ')
    ->setCellValue('C11', $orderDate)
    ->setCellValue('A12', 'Κωδικός Πωλητή / Salesperson Code: ')
    ->setCellValue('C12', $salespersonDisplayName)
    ->setCellValue('A13', 'Κατάστημα / Store: ')
    ->setCellValue('C13', '')
    ->setCellValue('A14', '')
;

$objPHPExcel->setActiveSheetIndex(0)
    // -- BILLING ADDRESS -- //
    ->setCellValue('D9' , 'Billing Address')
    ->setCellValue('D10', 'Account Code: '. $customerCode)
    ->setCellValue('D11', $customerName)
;
$row = 11;
if(strcmp($addressLine1,'')!=0 && strcmp($addressLine1,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $row, $addressLine1);
    $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
    $objPHPExcel->getActiveSheet()->getStyle('D'.$row.':F'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        )
    );

}
if(strcmp($addressLine2,'')!=0 && strcmp($addressLine2,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $row, $addressLine2);
    $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
    $objPHPExcel->getActiveSheet()->getStyle('D'.$row.':F'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        )
    );

}
if(strcmp($city,'')!=0 && strcmp($city,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $row, $city);
    $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
    $objPHPExcel->getActiveSheet()->getStyle('D'.$row.':F'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        )
    );

}
if(strcmp($landline,'')!=0 && strcmp($landline,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $row, $landline);
    $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
    $objPHPExcel->getActiveSheet()->getStyle('D'.$row.':F'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        )
    );
}


$objPHPExcel->setActiveSheetIndex(0)
    // -- DELIVERY ADDRESS -- //
    ->setCellValue('J9' , 'Delivery Address')
    ->setCellValue('J10', 'Account Code: '. $customerCode)
    ->setCellValue('J11', $customerName)
;

$row = 11;
if(strcmp($addressLine1D,'')!=0 && strcmp($addressLine1D,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('J' . $row, $addressLine1D);
}
if(strcmp($addressLine2D,'')!=0 && strcmp($addressLine2D,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('J' . $row, $addressLine2D);
}
if(strcmp($cityD,'')!=0 && strcmp($cityD,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('J' . $row, $cityD);
}
if(strcmp($landlineD,'')!=0 && strcmp($landlineD,'null')!=0) {
    $row++;
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('J' . $row, $landlineD);
}
;


$objDrawing = new PHPExcel_Worksheet_Drawing();
$objDrawing->setName('logo');
$objDrawing->setDescription('logo');
$objDrawing->setPath(ROOT . 'media/pdfimage/logo.png');
$objDrawing->setCoordinates('A1');
$objDrawing->setWidthAndHeight(300, 300);
$objDrawing->setOffsetY(100);
$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());


$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$row2 = $objPHPExcel->getActiveSheet()->getHighestRow()+2;

$highlightRow = $row;
$highlightRow2 = $row2;
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "No.")
    ->setCellValue('A'.$row2,"Αρ.")
    ->setCellValue('B'.$row, "ΕΙΚΟΝΑ")
    ->setCellValue('B'.$row2,"IMAGE")
    ->setCellValue('C'.$row, "ΓΡΑΜΜΟΚΩΔΙΚΑΣ")
    ->setCellValue('C'.$row2,"BARCODE")
    ->setCellValue('D'.$row, "ΚΩΔΙΚΟΣ")
    ->setCellValue('D'.$row2, "CODE")
    ->setCellValue('E'.$row, "ΠΕΡΙΓΡΑΦΗ")
    ->setCellValue('E'.$row2, "DESCRIPTION")
    ->setCellValue('F'.$row, "ΜΟΝ. ΜΕΤΡ.")
    ->setCellValue('F'.$row2, "UOM")
    ->setCellValue('G'.$row, "ΠΟΣΩΤΗΤΑ")
    ->setCellValue('G'.$row2, "QTY")
    ->setCellValue('H'.$row, "ΤΙΜΗ")
    ->setCellValue('H'.$row2, "(€)PRICE")
    ->setCellValue('I'.$row, "ΕΚΠΤΩΣΗ")
    ->setCellValue('I'.$row2, "(%)DISC.")
    ->setCellValue('J'.$row, "ΠΟΣΟ")
    ->setCellValue('J'.$row2, "(€)AMOUNT")
;


$vatsArray = Array();
$stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
$stm->execute();
$stm->bind_result($vatID,$vatCode,$percentage);
while ($stm->fetch()) {
    $vatObject= new stdClass();
    $vatObject->id=$vatID;
    $vatObject->code=$vatCode;
    $vatObject->percentage=$percentage;
    $vatObject->vatAmount=0;
    $vatObject->goods=0;
    array_push($vatsArray,$vatObject);
}
$stm->close();


$counter = 0;
$stm = $db->prepare("SELECT Order_Item.item_id,Items.sales_units,qty,Items.thumbnail_url,Items.subunits,unit_price,Items.vat_id,Vats.vat_code,Order_Item.vat_amount,item_code,global_discount,line_discount,name FROM Order_Item,Items,Vats WHERE Vats.vat_id = Order_Item.vat_id AND Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
$stm->execute();
$stm->bind_result($itemID, $uom,$qty,$image,$subunits, $unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode,$globalDiscount,$lineDiscount,$name);


$items = array();
while ($stm->fetch()){

    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stm2 = $db2->prepare("SELECT barcode FROM Item_Barcode WHERE item_id='$itemID'");
    $stm2->execute();
    $stm2->bind_result($barcode);
    while ($stm2->fetch()){}
    $stm2->close();

    $counter++;
    $lineTotal = $unitPrice * $qty;

    if(floatval($subunits)==0){$subunits=1;}
    if(floatval($unitPrice) > 0){
        $discount_line = ($globalDiscount+$lineDiscount)/($unitPrice*$qty/$subunits)*100;
    } else {
        $discount_line = 0;
    }

    $unitPrice = number_format(floatVal($unitPrice),2);
    $lineTotal = number_format(floatVal($lineTotal),2);

    $item = new stdClass();
    $item->counter   = $counter;
    $item->code      = $itemCode;
    $item->name      = $name;
    $item->uom       = $uom;
    $item->qty       = $qty;
    $item->barcode   = $barcode;
    $item->unitPrice = $unitPrice;
    $item->vatCode   = $vatCode;
    $item->discount  = $discount_line;
    $item->lineTotal = $lineTotal;
    $item->image     = $image;

    array_push($items, $item);

    foreach($vatsArray as $vatObject){
        if($vatObject->id==$vatID){
            $vatObject->vatAmount+=$vatLineAmount;
            $vatObject->goods+=$lineTotal;
        }
    }
}
$stm->close();


foreach ($items as $item){

    if(strcmp($item->image,'')!=0) {
        if(file_exists(ROOT . 'media/productImages/' . $item->image . '.jpg')) {
            $imageURL = ROOT . 'media/productImages/' . $item->image . '.jpg';
        } else {
            $imageURL = ROOT . 'backend/themes/'.THEME_NAME.'/img/itemdefaulticon.jpg';
        }
    } else {
        $imageURL = ROOT . 'backend/themes/'.THEME_NAME.'/img/itemdefaulticon.jpg';
    }


    $row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
    $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A'.$row, $item->counter)
        ->setCellValue('C'.$row, $item->barcode)
        ->setCellValue('D'.$row, $item->code)
        ->setCellValue('E'.$row, $item->name)
        ->setCellValue('F'.$row, $item->uom)
        ->setCellValue('G'.$row, $item->qty)
        ->setCellValue('H'.$row, '€'.number_format(floatVal($item->unitPrice),2))
        ->setCellValue('I'.$row, $item->discount.'%')
        ->setCellValue('J'.$row, '€'.number_format(floatVal($item->lineTotal),2))
    ;

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('item');
    $objDrawing->setDescription('item');
    $objDrawing->setPath($imageURL);
    $objDrawing->setCoordinates('B'.$row);
    $objDrawing->setWidthAndHeight(100, 100); // Previous 50 , 50
    $objDrawing->setOffsetX(32); // Previous 62
    $objDrawing->setOffsetY(10);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
    $objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(100); // Previous 50

    $objPHPExcel->getActiveSheet()->getStyle('C'.$row)->getNumberFormat()->setFormatCode('0');

    $objPHPExcel->getActiveSheet()->getStyle('A'.$row.':J'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => '000000')
                )
            )
        )
    );

    $objPHPExcel->getActiveSheet()->getStyle('H'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            )
        )
    );

    $objPHPExcel->getActiveSheet()->getStyle('J'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            )
        )
    );
}




$stm = $db->prepare("SELECT subtotal,  discount_amount, vat_amount, grand_total FROM Orders WHERE order_id='$orderID'");
$stm->execute();
$stm->bind_result($sub_total, $discount_amount, $vat_amount, $grand_total);
while ($stm->fetch()) {}
$stm->close();

$styleRow = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$remarksRow = $objPHPExcel->getActiveSheet()->getHighestRow()+1;



$net_total = $sub_total-$discount_amount;
$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;
$objPHPExcel->getActiveSheet()->mergeCells('F'.$row.':H'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, 'VAT Summary / Συνοπτική περιγραφή Φ.Π.Α. ')
    ->setCellValue('F'.$row, ' Καθαρή Αξία / Net Value')
    ->setCellValue('J'.$row, '€'.number_format(floatVal($net_total),2));
;



$objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':D'.$row);

$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);
$objPHPExcel->getActiveSheet()->getStyle('A'.$styleRow.':D'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        )
    )
);


$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$objPHPExcel->getActiveSheet()->mergeCells('F'.$row.':H'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, 'Code')
    ->setCellValue('B'.$row, '%')
    ->setCellValue('C'.$row, 'Goods')
    ->setCellValue('D'.$row, 'VAT')
    ->setCellValue('F'.$row, ' Φ.Π.Α. / VAT Amount')
    ->setCellValue('J'.$row, '€'.number_format(floatVal($vat_amount),2));
;


$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
        'borders' => array(
            'outline' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '000000')
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FFFFFF'),
            'size'  => 10
        )
    )
);

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$objPHPExcel->getActiveSheet()->mergeCells('F'.$row.':H'.$row);
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('F'.$row, ' Γενικό Σύνολο / Grand Total')
    ->setCellValue('J'.$row, '€'.number_format(floatVal($grand_total),2));
;

$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
        'borders' => array(
            'outline' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('B1:G1')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('E'.$styleRow.':J'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('J'.$styleRow.':J'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('G1:J14')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('A1:J14')->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A'.$highlightRow.':J'.$highlightRow2)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '000000')
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FFFFFF'),
            'size'  => 10
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('D1:E13')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        )
    )
);


foreach($vatsArray as $vatObject) {

    if($vatObject->goods>0) {

        $vatObject->goods = number_format(floatVal($vatObject->goods),2);
        $vatObject->vatAmount = number_format(floatVal($vatObject->vatAmount),2);

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A'.$row, $vatObject->code)
            ->setCellValue('B'.$row, $vatObject->percentage)
            ->setCellValue('C'.$row, $vatObject->goods)
            ->setCellValue('D'.$row, $vatObject->vatAmount)
        ;
        $objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray(
            array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
                )
            )
        );

    }

}

$objPHPExcel->getActiveSheet()->getStyle("A1:J".$row)->getFont()->setBold( true );
foreach(range('C','G') as $columnID) {
    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
        ->setAutoSize(true);
}

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(24);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Order'.$orderCode.'.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');


?>