<?php
require_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomerAddress.php");
require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
include_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");


$db = new mysqli(localhost,username,password,database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$dbhelper = DBCustomer::getInstance();
$edit=false;
$copyContract=false;
if(isset($_POST['contract_id'])) {

	$contractID=$_POST['contract_id'];

	$edit=true;

}
if(isset($_POST['copy_contract']) && strcmp($_POST['copy_contract'], 'yes')==0) {
    $copyContract=true;
}

if(isset($_GET['contract_id'])) {

    $contractID = $_GET['contract_id'];
    $edit = true;

}

if(isset($_GET['customer_id']))
{
    $customerID = $_GET['customer_id'];
    $customer=$dbhelper->getCustomerByID($customerID);
}

if(isset($_GET['serial_number_id']))
{
    $serialNumberID = $_GET['serial_number_id'];

    $stm =$db->prepare("SELECT serial_number,item_id FROM Serial_Numbers WHERE serial_number_id ='$serialNumberID'");
    $stm-> execute();
    $stm-> bind_result($serialNumber,$itemID);
    while ($stm->fetch()) {

    }
    $stm-> close();

    $stm =$db->prepare("SELECT item_code,name,item_sku FROM Items WHERE item_id ='$itemID'");
    $stm-> execute();
    $stm-> bind_result($itemCode,$itemName,$itemSKU);
    while ($stm->fetch()) {

    }
    $stm-> close();
}

$windowClose = '';
if(isset($_GET['window']) && strcmp($_GET['window'],'close')==0){
    $windowClose = 'window.close();';
}



if($edit) {

    $contract=$dbhelper->getContract($contractID);

    $customer=$dbhelper->getCustomerByID($contract->customerID);

    $db = new mysqli(localhost,username,password,database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm =$db->prepare("SELECT serial_number FROM Serial_Numbers WHERE serial_number_id ='$contract->serialNumberID'");
    $stm-> execute();
    $stm-> bind_result($serialNumber);
    while ($stm->fetch()) {

    }
    $stm-> close();



    $stm =$db->prepare("SELECT item_code,name,item_sku FROM Items WHERE item_id ='$contract->itemID'");
    $stm-> execute();
    $stm-> bind_result($itemCode,$itemName,$itemSKU);
    while ($stm->fetch()) {

    }
    $stm-> close();


}

$allowContractSchedulesModule = false;
$stm =$db->prepare("SELECT allow_contract_schedules FROM Allow_Modules LIMIT 1");
$stm-> execute();
$stm-> bind_result($allowContractSchedules);
while ($stm->fetch()) {
    if(strcmp($allowContractSchedules,"yes")==0) {
        $allowContractSchedulesModule = true;
    }
}
$stm-> close();


$custForm = new CustomForm('Contracts',$contractID);
$custTable = new CustomTable('Contracts',$contractID);

?>
		<div id="main" role="main">
			
			<!-- Start CUSTOM CODE-->
			<!-- RIBBON -->
			<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>
				<!-- breadcrumb -->
				<ol class="breadcrumb">
					<?php
					if($edit && !$copyContract)
					{
						echo"<li class='txt-color-white'>Home / Edit Contract</li>";
					}
					else
					{
						echo"<li class='txt-color-white'>Home / New Contract</li>";
					}
					?>
				</ol>
				<!-- end breadcrumb -->
			</div>
			<!-- END RIBBON -->

			<!-- MAIN CONTENT -->
			<div id="content">

<div class="row">
	<div class="col-xs-12 col-sm-8 col-md-9 col-lg-4">
		<h3 class="page-title txt-color-blueDark header-margin">
			<img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/itemdefaulticon.jpg" width="25" height="25">
            <?php if($edit && !$copyContract){echo "Edit";}else{echo "New";}?> Contract
			</h3>
	</div>
    <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
        <?php if($edit && !$copyContract){
            echo "<a href='//".HTML_PATH."/cop/backend/core/views/manage/manage_contracts.php' ><span class='pull-right show-stat-buttons'> <span > <button  class='btn btn-primary btn-block'><i class='fa fa-arrow-left'></i>&nbsp; Contract List</button> </span></a>";
        } ?>
    </div>
    <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
        <?php if($edit && !$copyContract){
            echo "<a href='//".HTML_PATH."/cop/backend/core/views/addedit/new_contract.php' ><span class='pull-right show-stat-buttons'> <span > <button  class='btn btn-primary btn-block'><i class='fa fa-plus'></i>&nbsp; New Contract</button> </span></a>";
        } ?>
    </div>
    <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
        <?php if($edit && !$copyContract){
        echo "<span class='pull-right show-stat-buttons'> <span > <button data-toggle='modal' data-target='#confirmCopyContract' class='btn btn-primary btn-block'><i class='fa fa-circle-o-notch'></i>&nbsp; Copy Contract</button> </span>";
        } ?>
    </div>
    <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <button id="saveButton" onclick="saveProduct()" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; Save Contract</button> </span>
	</div>
</div>

<!-- row -->
<section id="widget-grid" class="">
					
            <div class="row">
					
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark no-margin" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Contract Form</h2>

                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <form action="" id="checkout-form" class="smart-form">
                                    <fieldset style="padding-top:10px;">
                                        <div class="row">
                                            <section class="col col-6 no-margin" style="padding-right:2px" >
                                                <section>
                                                    <img style="display:inline;width:30px;height:30px;" class="" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/itemdefaulticon.jpg" width="25" height="25">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Basic Details</h3>
                                                </section>
                                                <table id="basicDetailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0" >
                                                    <thead >
                                                    </thead>
                                                    <tbody >

                                                    <tr >
                                                        <td class="custom-td-label-medium">

                                                            <label style="display:inline;" class="label-bold form-label-space" >Find Customer: </label>
                                                        </td>
                                                        <td class="custom-td-label-medium">
                                                            <input style='display:inline;' class='text-center form-control' id='customerSearch' name='customerSearch' type='text' value='<?php if($edit|| isset($customer))
                                                            {
                                                                echo "$customer->customerCode - $customer->companyName";
                                                            }
                                                            ?>'>

                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label-medium">


                                                            <input type="hidden" id="customerID" value="<?php if($edit || isset($customer)){echo "$customer->customerID";} ?>"/>
                                                            <label class="label-bold form-label-space"> Customer Code: </label>
                                                        </td>
                                                        <td class="custom-td-label-medium">
                                                            <label  style='color:#4682c4' class="label-text  bold" id='customerCode'><?php if($edit|| isset($customer)){echo "$customer->customerCode";} ?>  </label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label-medium">

                                                            <label class="label-bold form-label-space"> Customer Name: </label>
                                                        </td>
                                                        <td class="custom-td-label-medium">
                                                            <label style='color:#4682c4' class="label-text bold" id='customerName'><?php if($edit|| isset($customer)){echo "$customer->companyName";} ?>  </label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label-medium">




                                                            <?php
                                                            if($edit || isset($customer)) {
                                                                global $username, $password, $database;
                                                                $db2 = new mysqli('localhost', $username, $password, $database);
                                                                if (mysqli_connect_errno()) {
                                                                    printf("Connect failed: %s\n", mysqli_connect_error());
                                                                    exit();
                                                                }
                                                                $addresses = array();
                                                                $db2->set_charset("utf8");
                                                                $stm5 = $db2->prepare("SELECT customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customer->customerID'");
                                                                $stm5->execute();
                                                                $stm5->bind_result($customerAddressID, $addressCode, $customerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
                                                                while ($stm5->fetch()) {
                                                                    $address = new CustomerAddress($customerAddressID, $addressCode, $customerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress);
                                                                    array_push($addresses, $address);


                                                                }
                                                                $stm5->close();
                                                            }
                                                            ?>
                                                            <label class="label-bold"> Delivery Address: </label>
                                                        </td>
                                                        <td>
                                                            <select  class='form-control' id='customerAddressID' name='customerAddressID'>
                                                                <?php
                                                                if($edit || isset($customer)) {
                                                                    foreach ($addresses as $address) {
                                                                        if ($address->id == $contract->customerAddressID) {
                                                                            echo "<option value=\"" . $address->id . "\" selected>".$address->addressLine1. "</option>";
                                                                        } else {
                                                                            echo "<option value=\"" . $address->id . "\">".$address->addressLine1. "</option>";
                                                                        }
                                                                    }
                                                                }
                                                                else{
                                                                    echo"<option></option>";
                                                                }


                                                                ?>


                                                            </select>



                                                        </td>


                                                    </tr>

                                                    <tr >
                                                        <input  class='text-center form-control slim-input' id='contractID' name='contractID' type='hidden' <?php if(!$copyContract){echo "value='$contract->contractID'";} else {echo"value=''";} ?>>

                                                        <input  class='text-center form-control slim-input' id='serialNumberTransactionLogID' name='serialNumberTransactionLogID' type='hidden' <?php if(!$copyContract){ echo "value='$contract->serialNumberTransactionLogID'";} else {echo"value=''";} ?>>
                                                        <input  class='text-center form-control slim-input' id='serialNumberID' name='serialNumberID' type='hidden' <?php if(isset($serialNumberID) && $serialNumberID > 0 && !$copyContract){echo"value='$serialNumberID'";} else if(!$copyContract){echo "value='$contract->serialNumberID'";} else {echo"value=''";} ?>>
                                                        <td class="custom-td-label-medium" style='width:30% !important;'><label class="label-bold  align-left">Serial Number: </label></td>
                                                        <td class="custom-td-label-medium"  style='width:70% !important;'><input  class=' text-center form-control slim-input' id='serialNumber' name='serialNumber' type='text'  <?php if(!$copyContract){echo"value='$serialNumber'";} else {echo"value=''";}?> ></td>
                                                    </tr>

                                                    <tr>
                                                        <input type="hidden" name="itemID" id="itemID" <?php if(isset($itemID) && $itemID > 0 && !$copyContract){echo"value='$itemID'";} else if(!$copyContract){echo"value='$contract->itemID'";} else {echo"value=''";}?>/>


                                                        <td class="custom-td-label-medium" >
                                                            <label style="display:inline;" class="label-bold form-label-space" >Find Item: </label>
                                                        </td>
                                                        <td class="custom-td-label-medium" >
                                                            <input style='display:inline;' class='text-center form-control' id='itemSearch' name='itemSearch' type='text' value="<?php if(!$copyContract){echo"$itemCode";}?>" >

                                                        </td>
                                                    </tr>
                                                    <tr>




                                                        <td class="custom-td-label-medium" style='width:30% !important;'>
                                                                <label class="label-bold form-label-space"> Item Code: </label>
                                                        </td>

                                                        <td class="custom-td-label-medium" style='width:70% !important;'>
                                                                <label  style='color:#4682c4' class="label-text  bold" id='itemCode'><?php if(!$copyContract){echo"$itemCode";}?></label>
                                                        </td>

                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label-medium" style='width:30% !important;'>
                                                                <label class="label-bold form-label-space" style="display:inline"> Item Name: </label>
                                                        </td>
                                                        <td class="custom-td-label-medium" style='width:70% !important;'>
                                                                <label style='color:#4682c4;display:inline' class="label-text bold" id='itemDetails'><?php if(!$copyContract){echo"$itemName";}?></label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label-medium" style='width:30% !important;'>
                                                            <label class="label-bold form-label-space" style="display:inline"> Item SKU: </label>
                                                        </td>
                                                        <td class="custom-td-label-medium" style='width:70% !important;'>
                                                            <label style='color:#4682c4;display:inline' class="label-text bold" id='itemSKU'><?php if(!$copyContract){echo"$itemSKU";}?></label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label-medium" style='width:30% !important;'>
                                                            <label class="label-bold form-label-space" style="display:inline"> Remarks: </label>
                                                        </td>
                                                        <td class="custom-td-label-medium" style='width:70% !important;'>
                                                            <textarea id="contractNotes" name="contractNotes" class="form-control contractNotes" style="height: 150px;"><?php echo"$contract->notes";?></textarea>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>

                                            </section>
                                            <section class="col col-6 no-margin" style="border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;padding-right:2px;">
                                                <section>
                                                    <img style="width:30px;height:30px;display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/infoicon.png" width="25" height="25">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> More Details</h3>
                                                </section>

                                                <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                    <thead >
                                                    </thead>
                                                    <tbody>
                                                    <tr >
                                                        <td class="custom-td-label-medium"><label class="label-bold  align-left" >Under Contract: </label></td>
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select style="text-align-last:center;" class='form-control slim-input'  id='underContract' name='underContract'>
                                                                    <?php
                                                                    if($edit&&strcmp($contract->valid,"yes")==0)
                                                                    {

                                                                        echo"<option value='yes' selected>Yes </option>
                                                                                         <option value='no' >No </option>";


                                                                    }
                                                                    else
                                                                    {
                                                                        echo"<option value='yes'>Yes </option>
                                                                                         <option value='no' selected>No </option>";
                                                                    }
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold lalign">Date of Contract: </label></td>
                                                        <td>
                                                            <section class="col col-6 no-margin form-control">
                                                                <input type="text" id="dateOfContractStart" value="<?php

                                                                if($edit&&strcmp($contract->startDate,'')!=0&&strcmp($contract->startDate,'0000-00-00')!=0)
                                                                {
                                                                    $old_date_timestamp = strtotime($contract->startDate);
                                                                    $dateNew = date('d/m/Y', $old_date_timestamp);
                                                                    echo $dateNew;
                                                                }
                                                                else {
                                                                    echo "";
                                                                }?>" data-dateformat="dd/mm/yy" class="form-control text-center "
                                                                       data-mask="99/99/9999" data-mask-placeholder= "-">

                                                            </section>
                                                            <section class="col col-6 no-margin form-control">
                                                                <input type="text" id="dateOfContractEnd" value="<?php

                                                                if($edit&&strcmp($contract->endDate,'')!=0&&strcmp($contract->endDate,'0000-00-00')!=0)
                                                                {
                                                                    $old_date_timestamp = strtotime($contract->endDate);
                                                                    $dateNew = date('d/m/Y', $old_date_timestamp);
                                                                    echo $dateNew;
                                                                }
                                                                else {
                                                                    echo "";
                                                                }?>" data-dateformat="dd/mm/yy" class="form-control text-center "
                                                                       data-mask="99/99/9999" data-mask-placeholder= "-">

                                                            </section>

                                                        </td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold lalign">Type of Contract: </label></td>
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select style="text-align-last:center;" class='form-control slim-input'  id='typeOfContract' name='typeOfContract'>
                                                                    <?php



                                                                    global $username,$password,$database;


                                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $db->set_charset("utf8");
                                                                    // WHERE compani code in  Session

                                                                    $stm = $db->prepare("SELECT contract_type_id,contract_type_code,contract_type_name FROM Contract_Types ORDER BY contract_type_id");
                                                                    $stm-> execute();
                                                                    $stm-> bind_result($contractTypeID,$contractTypeCode,$contractTypeName);
                                                                    while ($stm->fetch()) {

                                                                        if($edit&&strcmp($contract->contactTypeID,$contractTypeID)==0)
                                                                        {
                                                                            echo "<option value='$contractTypeID' selected>$contractTypeName</option>";
                                                                        }
                                                                        else {
                                                                            echo "<option value='$contractTypeID'>$contractTypeName</option>";
                                                                        }

                                                                    }
                                                                    $stm-> close();
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                        </td>
                                                    </tr>

                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold lalign">Price of Contract: </label></td>
                                                        <td  class="custom-td-input"><input  type="text"  class="form-control text-center slim-input" name="priceOfContract" id="priceOfContract" <?php if($edit){echo"value='$contract->price''";} ?>>
                                                        </td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold lalign">Payment Due Date: </label></td>
                                                        <td class="custom-td-input-large"><input data-dateformat="dd/mm/yy" data-mask="99/99/9999" data-mask-placeholder= "-" type="text" class="form-control text-center slim-input" name="paymentDueDate" id="paymentDueDate" value="<?php

                                                            if($edit&&strcmp($contract->dueDate,'')!=0&&strcmp($contract->dueDate,'0000-00-00')!=0)
                                                            {
                                                                $old_date_timestamp = strtotime($contract->dueDate);
                                                                $dateNew = date('d/m/Y', $old_date_timestamp);
                                                                echo $dateNew;
                                                            }
                                                            else {
                                                                echo "";
                                                            }?>" >
                                                        </td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold lalign">Type of Payment: </label></td>
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select style="text-align-last:center;" class='form-control slim-input'  id='typeOfPayment' name='typeOfPayment'>
                                                                    <?php



                                                                    global $username,$password,$database;


                                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $db->set_charset("utf8");
                                                                    // WHERE compani code in  Session

                                                                    $stm = $db->prepare("SELECT paymenttype_id,paymenttype_code,name FROM PaymentTypes ORDER BY paymenttype_id");
                                                                    $stm-> execute();
                                                                    $stm-> bind_result($paymentTypeID,$paymentTypeCode,$paymentName);
                                                                    while ($stm->fetch()) {

                                                                        if($edit&&strcmp($contract->paymentTypeID,$paymentTypeID)==0)
                                                                        {
                                                                            echo "<option value='$paymentTypeID' selected>$paymentName</option>";
                                                                        }
                                                                        else {
                                                                            echo "<option value='$paymentTypeID'>$paymentName</option>";
                                                                        }

                                                                    }
                                                                    $stm-> close();
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  lalign" >Month of Payment: </label></td>
                                                        <td class="custom-td-input-large"><input data-dateformat="dd/mm/yy" data-mask="99/99/9999" data-mask-placeholder= "-" type="text" class="form-control text-center slim-input" name="monthOfPayment" id="monthOfPayment" value="<?php

                                                            if($edit&&strcmp($contract->paymentDate,'')!=0&&strcmp($contract->paymentDate,'0000-00-00')!=0)
                                                            {
                                                                $old_date_timestamp = strtotime($contract->paymentDate);
                                                                $dateNew = date('d/m/Y', $old_date_timestamp);
                                                                echo $dateNew;
                                                            }
                                                            else {
                                                                echo "";
                                                            }?>" >
                                                        </td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  lalign" >Way of Payment: </label></td>
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select style="text-align-last:center;" class='form-control slim-input'  id='wayOfPayment' name='wayOfPayment'>
                                                                    <?php



                                                                    global $username,$password,$database;


                                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $db->set_charset("utf8");
                                                                    // WHERE compani code in  Session

                                                                    $stm = $db->prepare("SELECT paymenttype_id,paymenttype_code,name FROM PaymentTypeWays ORDER BY paymenttype_id");
                                                                    $stm-> execute();
                                                                    $stm-> bind_result($paymentTypeID,$paymentTypeCode,$paymentName);
                                                                    while ($stm->fetch()) {

                                                                        if($edit&&strcmp($contract->wayOfPaymentID,$paymentTypeID)==0)
                                                                        {
                                                                            echo "<option value='$paymentTypeID' selected>$paymentName</option>";
                                                                        }
                                                                        else {
                                                                            echo "<option value='$paymentTypeID'>$paymentName</option>";
                                                                        }

                                                                    }
                                                                    $stm-> close();
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                    </tr>

                                                    <tr >
                                                        <td class="custom-td-label-small"><label class="label-bold align-left" >Troubleshooting: </label></td>
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select style="text-align-last:center;" class='form-control slim-input'  id='troubleshooting' name='troubleshooting'>
                                                                    <?php



                                                                    global $username,$password,$database;


                                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $db->set_charset("utf8");
                                                                    // WHERE compani code in  Session

                                                                    $stm = $db->prepare("SELECT troubleshooting_id,troubleshooting_code,troubleshooting_name FROM Troubleshootings ORDER BY troubleshooting_id");
                                                                    $stm-> execute();
                                                                    $stm-> bind_result($troubleshootingID,$toubleshootingCode,$troubleshootingName);
                                                                    while ($stm->fetch()) {

                                                                        if($edit&&strcmp($contract->troubleShootingID,$troubleshootingID)==0)
                                                                        {
                                                                            echo "<option value='$troubleshootingID' selected>$troubleshootingName</option>";
                                                                        }
                                                                        else {
                                                                            echo "<option value='$troubleshootingID'>$troubleshootingName</option>";
                                                                        }

                                                                    }
                                                                    $stm-> close();
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label-small"><label class="label-bold align-left">Assigned Salesperson: </label></td>
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select style="text-align-last:center;" class='form-control slim-input'  id='assignedSalesperson' name='assignedSalesperson'>
                                                                    <?php


                                                                    global $username,$password,$database;


                                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $db->set_charset("utf8");
                                                                    // WHERE compani code in  Session

                                                                    $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons ORDER BY salesperson_id");
                                                                    $stm-> execute();
                                                                    $stm-> bind_result($salespersonID,$salespersonCode,$fistName,$lastName);
                                                                    while ($stm->fetch()) {

                                                                        if($edit&&strcmp($contract->salepersonID,$salespersonID)==0)
                                                                        {
                                                                            echo "<option value='$salespersonID' selected>$fistName $lastName</option>";
                                                                        }
                                                                        else {
                                                                            echo "<option value='$salespersonID'>$fistName $lastName</option>";
                                                                        }

                                                                    }
                                                                    $stm-> close();
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                    </tr>

                                                    <tr >
                                                        <td class="custom-td-label-small"><label class="label-bold  align-left" >Assigned Technician: </label></td>
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select style="text-align-last:center;" class='form-control slim-input'  id='assignedTechnician' name='assignedTechnician'>
                                                                    <?php


                                                                    global $username,$password,$database;


                                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $db->set_charset("utf8");
                                                                    // WHERE compani code in  Session

                                                                    $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons ORDER BY salesperson_id");
                                                                    $stm-> execute();
                                                                    $stm-> bind_result($salespersonID,$salespersonCode,$fistName,$lastName);
                                                                    while ($stm->fetch()) {

                                                                        if($edit&&strcmp($contract->technicianID,$salespersonID)==0)
                                                                        {
                                                                            echo "<option value='$salespersonID' selected>$fistName $lastName</option>";
                                                                        }
                                                                        else {
                                                                            echo "<option value='$salespersonID'>$fistName $lastName</option>";
                                                                        }

                                                                    }
                                                                    $stm-> close();
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                    </tr>


                                                    </tbody>
                                                </table>
                                                <?php
                                                $custTable->editCustomTableValues();
                                                $custForm->editCustomFormValues();
                                                ?>
                                                </section>





                                            </div>


                                    </fieldset>
                                </form>


                            </div>
                        </div>
                    </div>

                </article>

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="<?php if(!$edit || $copyContract){echo "display:none;";} else {echo "display:block;";}?>" >
                    <!-- new widget -->
                    <div class="jarviswidget no-margin"  data-widget-editbutton="false"  data-widget-colorbutton="false" data-widget-deletebutton="false">
                        <header>
                            <ul class="nav nav-tabs pull-left in" id="myTab">
                                <li class="active">
                                    <a data-toggle="tab" href="#ser1"><i class="fa fa-file-pdf-o"></i> <span class="hidden-mobile hidden-tablet">Contract Attachments</span></a>
                                </li>
                            </ul>
                        </header>

                        <!-- widget div-->
                        <div >

                            <div class="widget-body no-padding">
                                <!-- content -->
                                <div id="myTabContent" class="tab-content">

                                    <div class="tab-pane fade active in no-padding-bottom" id="ser1">
                                        <div class="row no-space">

                                            <div class='col-sm-12' style="padding-right:5px;" >
                                                <div style="">
                                                    <div style="padding:10px;">

                                                        <form  style='border: 1px solid #4682b4;margin-top:5px;margin-bottom:5px;height:200px;min-height: 0px !important;' action="//<?php echo HTML_PATH ?>/cop/backend/core/controllers/upload/uploadContractAttachment.php?contractID=<?php echo $contractID ?>" enctype= 'multipart/form-data' class='dropzone' id='contractDropzone'></form>

                                                    </div>
                                                </div>

                                            </div>


                                        </div>
                                    </div>
                                    <!-- end s1 tab pane -->


                                </div>
                                <!-- end content -->
                            </div>

                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->

                </article>

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="<?php if(!$edit || $copyContract){echo "display:none;";} else if(!$allowContractSchedulesModule){echo "display:none;";} else {echo "display:block;";}?>" >

                    <div class="jarviswidget"   data-widget-editbutton="false"  data-widget-colorbutton="false" data-widget-deletebutton="false">
                        <header>
                            <ul class="nav nav-tabs pull-left in" id="myTab">
                                <li class="active">
                                    <a data-toggle="tab" href="#ser2"><i class="fa fa-file-pdf-o"></i> <span class="hidden-mobile hidden-tablet">Contract Schedules</span></a>
                                </li>
                            </ul>
                        </header>
                        <!-- widget div-->
                        <div >

                            <div class="widget-body no-padding">
                                <!-- content -->
                                <div id="myTabContent" class="tab-content">

                                    <div class="tab-pane fade active in no-padding-bottom" id="ser2">
                                        <div class="row no-space">

                                            <div class='col-sm-12' >
                                                <div style="">
                                                    <div style="padding:10px;">

                                                        <table id="datatable_fixed_column_contract_schedules" class="table table-hover dataTable" width="100%">

                                                            <thead>
                                                            <tr>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Name" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Type" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter SC Type" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Days" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Months" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Dates " />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Assigned " />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Date" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Time" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Time" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Date" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Date" />
                                                                </th>
                                                                <th class="hasinput" style="">
                                                                    <input type="text" class="form-control text-center" placeholder="Filter Status" />
                                                                </th>
                                                                <th class="hasinput" style="">
		                                                            <span class="pull-right show-stat-buttons"> <span > <a onclick="newScheduleModal();" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; Add Schedule</a> </span>
                                                                </th>
                                                            </tr>
                                                            <tr>
                                                                <th class='text-center' >Name</th>
                                                                <th class='text-center' >Type</th>
                                                                <th class='text-center' >SC Type</th>
                                                                <th class='text-center' >Days</th>
                                                                <th class='text-center' >Months</th>
                                                                <th class='text-center' >Month Dates</th>
                                                                <th class='text-center' >Assigned To</th>
                                                                <th class='text-center' >Start Date</th>
                                                                <th class='text-center' >Start Time</th>
                                                                <th class='text-center' >End Time</th>
                                                                <th class='text-center' >Last Execution</th>
                                                                <th class='text-center' >Next Execution</th>
                                                                <th class='text-center' >Status</th>
                                                                <th class='text-center' >Actions</th>
                                                            </tr>
                                                            </thead>
                                                        </table>

                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    
                                </div>
                    </div>

                </article>

                <!--Modal-->
                <div class="modal fade" id="contractScheduleModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
                    <div class="modal-dialog" style="width:70%;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <!--                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->
                                <center>
                                    <h4 class="modal-title"style="margin-left:10px;"><i class="fa fa-calendar"></i><strong style="padding-left:5px;">&nbsp;Contract Schedule </strong></h4>
                                </center>
                            </div>

                            <div class="modal-body"  style="margin-top:5px;padding-top:5px;">
                                <table class="table">
                                    <tr>
                                        <td colspan="2" style="width: 33%;">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Schedule Name:</label>
                                        </td>
                                        <td colspan="2" style="width: 66%;">
                                            <input type="text" class="form-control text-center" id="scheduleName" name="scheduleName" placeholder="Schedule Name" style="margin-bottom:10px;">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;">Schedule Type:</label>
                                        </td>
                                        <td colspan="2">
                                            <select class="form-control text-center scheduleUpdateDateField" id="scheduleType" name="scheduleType" style="margin-bottom:10px;">
                                                <option value="Single Date">Single Date</option>
                                                <option value="Daily">Daily</option>
                                                <option value="Weekly">Weekly</option>
                                                <option value="Monthly">Monthly</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Schedule Status:</label>
                                        </td>
                                        <td colspan="2">
                                            <select class="form-control text-center scheduleUpdateDateField" id="scheduleStatus" name="scheduleStatus" style="margin-bottom:10px;">
                                                <option value="Active">Active</option>
                                                <option value="Disabled">Disabled</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Assign to:</label>
                                        </td>
                                        <td colspan="2">
                                            <select class="form-control text-center scheduleUpdateDateField" id="scheduleSalesperson" name="scheduleSalesperson" style="margin-bottom:10px;">
                                                <?php
                                                    echo "<option value='0'>-</option>";
                                                    global $username,$password,$database;
                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                    if (mysqli_connect_errno()) {
                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                        exit();
                                                    }
                                                    $db->set_charset("utf8");

                                                    $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons WHERE NOT SalesPersons.salesperson_id = 0 ORDER BY salesperson_code");
                                                    $stm-> execute();
                                                    $stm-> bind_result($salespersonID,$salespersonCode,$fistName,$lastName);
                                                    while ($stm->fetch()) {
                                                        echo "<option value='$salespersonID'>$salespersonCode - $fistName $lastName</option>";
                                                    }
                                                    $stm-> close();
                                                ?>
                                            </select>

                                    </tr>
                                    <tr style="height: 85px;">
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Referred to:</label>
                                        </td>
                                        <td colspan="2" >
                                            <select class="form-control text-center scheduleUpdateDateField" id="scheduleScReferred" name="scheduleScReferred[]" style="margin-bottom:10px;" multiple="multiple">
                                                <?php
                                                global $username,$password,$database;
                                                $db = new mysqli(localhost,$username,$password,$database);
                                                if (mysqli_connect_errno()) {
                                                    printf("Connect failed: %s\n", mysqli_connect_error());
                                                    exit();
                                                }
                                                $db->set_charset("utf8");

                                                $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons WHERE NOT SalesPersons.salesperson_id = 0 ORDER BY salesperson_code");
                                                $stm-> execute();
                                                $stm-> bind_result($salespersonID,$salespersonCode,$fistName,$lastName);
                                                while ($stm->fetch()) {
                                                    echo "<option value='$salespersonID'>$salespersonCode - $fistName $lastName</option>";
                                                }
                                                $stm-> close();
                                                ?>
                                            </select>

                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> SC Type:</label>
                                        </td>
                                        <td colspan="2">
                                            <select class="form-control text-center scheduleUpdateDateField" id="scheduleScType" name="scheduleScType" style="margin-bottom:10px;">
                                                <?php
                                                global $username,$password,$database;
                                                $db = new mysqli(localhost,$username,$password,$database);
                                                if (mysqli_connect_errno()) {
                                                    printf("Connect failed: %s\n", mysqli_connect_error());
                                                    exit();
                                                }
                                                $db->set_charset("utf8");
                                                $stm = $db->prepare("SELECT type_id,type_code,type_name FROM SC_Types ORDER BY type_code");
                                                $stm-> execute();
                                                $stm-> bind_result($typeID,$typeCode,$typeName);
                                                while ($stm->fetch()) {
                                                    echo "<option value='$typeID'>$typeCode - $typeName</option>";
                                                }
                                                $stm-> close();
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Start Date:</label>
                                        </td>
                                        <td colspan="2">
                                            <input type="date" class="form-control text-center scheduleUpdateDateField" id="scheduleStartDate" name="scheduleStartDate" placeholder="Start Date" style="margin-bottom:10px;" value="<?php echo date('Y-m-d',strtotime(date('Y-m-d') . "+1 days"));?>">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Start/End Time:</label>
                                        </td>
                                        <td style="width: 33%;">
                                            <input type="time" class="form-control text-center scheduleUpdateDateField" id="scheduleStartTime" name="scheduleStartTime" placeholder="Start Time" style="margin-bottom:10px;" value="07:00">
                                        </td>
                                        <td style="width: 33%;">
                                            <input type="time" class="form-control text-center scheduleUpdateDateField" id="scheduleEndTime" name="scheduleEndTime" placeholder="End Time" style="margin-bottom:10px;" value="08:00">
                                        </td>
                                    </tr>


                                    <tr style="padding-bottom: 20px;" id="intervalConfigurationTd">
                                        <td colspan="2">
                                            <label class="label-bold form-label-space pull-left" style="text-align: left !important;white-space: nowrap;"> Interval Configuration:</label>
                                        </td>
                                        <td id="scheduleMonthsElementTd">
                                            <div id="scheduleMonthsElement">
                                                <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Months in Year:</label>
                                                <button class="btn btn-warning pull-right" style="display: inline-block;padding: 1px 4px;margin:1px;border-radius: 5px;" onclick="selectScheduleSpecificMonths([]);"> Clear </button>
                                                <button class="btn btn-primary pull-right" style="display: inline-block;padding: 1px 4px;margin:1px;border-radius: 5px;" onclick="selectScheduleSpecificMonths([1,2,3,4,5,6,7,8,9,10,11,12]);">&nbsp; All &nbsp;</button>
                                                <button class="btn btn-primary pull-right" style="display: inline-block;padding: 1px 4px;margin:1px;border-radius: 5px;" onclick="selectScheduleSpecificMonths([5,6,7,8,9,10]);">Summer</button>
                                                <button class="btn btn-primary pull-right" style="display: inline-block;padding: 1px 4px;margin:1px;border-radius: 5px;" onclick="selectScheduleSpecificMonths([11,12,1,2,3,4]);">Winter</button>
                                                <select id="scheduleMonths" name="scheduleMonths[]" class="form-control text-center scheduleUpdateDateField" style="margin-bottom:20px;" multiple="multiple">
                                                    <option value="1">January</option>
                                                    <option value="2">February</option>
                                                    <option value="3">March</option>
                                                    <option value="4">April</option>
                                                    <option value="5">May</option>
                                                    <option value="6">June</option>
                                                    <option value="7">July</option>
                                                    <option value="8">August</option>
                                                    <option value="9">September</option>
                                                    <option value="10">October</option>
                                                    <option value="11">November</option>
                                                    <option value="12">December</option>
                                                </select>
                                            </div>
                                        </td>
                                        <td id="scheduleDaysElementTd">
                                            <div id="scheduleDaysElement">
                                                <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Days of Week:</label>
                                                <select id="scheduleDays" name="scheduleDays[]" class="form-control text-center scheduleUpdateDateField" style="margin-bottom:20px;" multiple="multiple">
                                                    <option value="1">Monday</option>
                                                    <option value="2">Tuesday</option>
                                                    <option value="3">Wednesday</option>
                                                    <option value="4">Thursday</option>
                                                    <option value="5">Friday</option>
                                                    <option value="6">Saturday</option>
                                                    <option value="7">Sunday</option>
                                                </select>
                                            </div>
                                            <div id="scheduleDaysOfMonthElement">
                                                <label class="label-bold form-label-space pull-left" style="text-align: left !important;"> Dates of Month:</label>
                                                <select id="scheduleDaysOfMonth" name="scheduleDaysOfMonth[]" class="form-control text-center scheduleUpdateDateField" style="margin-bottom:20px;" multiple="multiple">
                                                    <?php
                                                    for($i=1;$i<=31;$i++)
                                                    {
                                                        echo "<option value='$i'>$i</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                                <input type="hidden" id="contractScheduleID" name="contractScheduleID" value="0">
                                <input type="hidden" id="scheduleLastExecutionDate" name="scheduleLastExecutionDate" value="0000-00-00">
                                <input type="hidden" id="scheduleNextExecutionDate" name="scheduleNextExecutionDate" value="0000-00-00">
                                <br><br><br><br>
                                <center>
                                <table class="table table-bordered" style="width: fit-content;white-space: nowrap;">
                                    <tr>
                                        <td style="width: 50%;">
                                            <center><label class="label-bold form-label-space" style="text-align: center !important;"> Last Execution Date </label></center>
                                        </td>
                                        <td style="width: 50%;">
                                            <center><label class="label-bold form-label-space" style="text-align: center !important;"> Next Execution Date </label></center>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span style="font-weight: bold;" id="scheduleLastExecutionDateDisplay">-</span>
                                        </td>
                                        <td>
                                            <span style="font-weight: bold;" id="scheduleNextExecutionDateDisplay">-</span>
                                        </td>
                                    </tr>
                                </table>
                                </center>
                            </div>

                            <footer class="modal-footer">
<!--                                <button class="btn btn-primary" onclick="generatePreDateContractScheduleServiceCalls();">Generate Pre-Date Service Calls</button>-->
                                <button onclick="deleteContractSchedule();" id="deleteContractScheduleButton" class="btn btn-danger pull-left" type="button" style="margin-right:10px;display:none;"><i class="fa fa-times"></i> Delete Schedule</button>
                                <button onclick="$('#contractScheduleModal').modal('hide');" class="btn btn-default pull-left" type="button" style="margin-right:10px;">Close</button>
                                <button onclick="saveContractSchedule();" class="btn btn-success pull-right" type="button" style="margin-right:10px;"><i class="fa fa-check"></i> Save Schedule</button>
                            </footer>
                        </div><!--/.modal-content-->
                    </div><!--/.modal-dialog-->
                </div><!--/.modal-->


            </div>



					<!-- end row -->




				
				</section>
		</div>
		</div>

<div class="modal fade" id="confirmCopyContract" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
                <h4 class="modal-title" style="margin-left:10px;"><i class="fa fa-lg fa-fw fa-warning"></i><strong style="padding-left:5px;">Copy of Contract</strong></h4>
            </div>

            <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                <section>
                    <label> The Copy of this Contract will redirect you to a new page.<br> In order to complete the process,<br><b>After Editing</b>, you need to <b>Save</b> the New (Copied) <b>Contract</b></label>
                </section>
            </div>
            <footer class="modal-footer" >

                <form style='margin:0' method='POST' action='//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/new_contract.php' target='_blank' >
                    <?php echo "
                        <input type='hidden' name='contract_id' value='$contractID'/>
                        <input type='hidden' name='copy_contract' value='yes'/>

                        "
                    ?>

                    <button class="btn btn-primary" type="submit" style="margin-right:20px;" onclick="this.style.visibility = 'hidden';$('#confirmCopyContract').modal('toggle');">
                        Proceed
                    </button>
                    <button onclick="$('#confirmCopyContract').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">
                        Cancel
                    </button>
                </form>
            </footer>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<style>

	td input {
		width:100%;
	}

	table#datatable_fixed_column tr td img { display:none;}
	table#datatable_fixed_column tr:hover td img { display:inline-block;}

    table#datatable_fixed_column {
        border: solid 1px #407bad;
    }

    table#datatable_fixed_column thead  {
        border: solid 1px #407bad;
    }

    table#datatable_fixed_column thead th {
          background-color: #4682B4;
          color: white;
        font-family: arial, sans-serif;
    }

    table#datatable_fixed_column tr td {
        padding-left:4px;
        padding-right:4px;
    }

    td.index {
        font-weight:bold;
    }

    tr td textarea {
        white-space: normal;
        text-align: justify;
        -moz-text-align-last: center; /* Firefox 12+ */
        text-align-last: center;
    }


    #detailsTable thead th {
        background-color: white !important;
        border:none;
        height:0px;
    }

</style>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
		
	<script type="text/javascript">

        function generatePreDateContractScheduleServiceCalls(){
            var scheduleID = $('#contractScheduleID').val();
            var contractID = '<?php echo $contractID ?>';

            $.ajax({
                url: "//<?php echo HTML_PATH ?>/cop/backend/modules/contractSchedules/controllers/generatePreDateContractScheduleServiceCalls.php",
                type: "POST",
                data: {
                    scheduleID: scheduleID,
                    contractID: contractID
                },
                success: function(data){
                    console.log(data);
                }
            });
        }

        function selectScheduleSpecificMonths(months){
            $('#scheduleMonths').val(months).trigger('change');
        }
        function initContractSchedulesTable(){
            var responsiveHelper_datatable_fixed_column = undefined;
            var breakpointDefinition = {tablet : 1024, phone : 480};

            /* COLUMN FILTER  */
            $('#datatable_fixed_column_contract_schedules').DataTable({
                "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                    "t"+
                    "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
                "autoWidth" : true,
                "processing": false,
                "serverSide": true,
                "ajax": "//<?php echo HTML_PATH ?>/cop/backend/modules/contractSchedules/controllers/getContractSchedules.php?contractID=<?php echo $contractID ?>",
                "columns": [
                    { "data": "details" },
                    { "data": "type_of_schedule" },
                    { "data": "service_call_type" },
                    { "data": "days" },
                    { "data": "months" },
                    { "data": "days_of_month" },
                    { "data": "salesperson" },
                    { "data": "start_date" },
                    { "data": "start_time" },
                    { "data": "end_time" },
                    { "data": "last_run_date" },
                    { "data": "next_run_date" },
                    { "data": "schedule_status" },
                    { "data": "actions" }
                ],
                "deferRender": true,
                "order": [[ 11, "asc" ],[ 1, "asc" ],[ 10, "asc" ]],
                "buttons": ["copyHtml5",
                    "excelHtml5",
                    "csvHtml5",
                    {
                        extend: 'pdfHtml5',
                        orientation: 'landscape',
                        pageSize: 'LEGAL'
                    }
                ],
                "preDrawCallback" : function() {
                    // Initialize the responsive datatables helper once.
                    if (!responsiveHelper_datatable_fixed_column) {
                        responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column_contract_schedules'), breakpointDefinition);
                    }
                },
                "rowCallback" : function(nRow, aData) {

                    if (aData.status == "Inactive" || aData.status == "Inactive") {
                        $(nRow).addClass("canceled");
                        $(nRow).css("background-color", "#FAAD93");
                    }


                    responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
                },
                "drawCallback" : function(oSettings) {
                    responsiveHelper_datatable_fixed_column.respond();
                },
                "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {


                }

            });

            // Apply the filter
            $("#datatable_fixed_column_contract_schedules thead th input[type=text]").on( 'keyup change', function () {

                $('#datatable_fixed_column_contract_schedules').DataTable()
                    .column( $(this).parent().index()+':visible' )
                    .search( this.value )
                    .draw();

            } );
            /* END COLUMN FILTER */

            $("#scheduleMonths").select2({
                placeholder: "Select Months",
                allowClear: true
            });

            $("#scheduleDays").select2({
                placeholder: "All Days",
                allowClear: true
            });

            $("#scheduleDaysOfMonth").select2({
                placeholder: "All Dates",
                allowClear: true
            });

            $('#scheduleSalesperson').select2({
                placeholder: "Select Salesperson",
                allowClear: true
            });

            $('#scheduleScType').select2({
                allowClear: false
            });

            $('#scheduleScReferred').select2({
                placeholder: "Select Referred",
                allowClear: true
            });

            $('#scheduleType').change(function(){
                if($(this).val() == "Single Date"){
                    $('#scheduleMonths').prop('disabled', true).val('');
                    $('#scheduleDays').prop('disabled', true).val('');
                    $('#scheduleDaysOfMonth').prop('disabled', true).val('');

                    $('#scheduleMonthsElement').hide();
                    $('#scheduleDaysElement').hide();
                    $('#scheduleDaysOfMonthElement').hide();

                    $('#intervalConfigurationTd').hide();
                    $('#scheduleMonthsElementTd').attr('colspan', '');
                    $('#scheduleDaysElementTd').show();
                }
                else if($(this).val() == "Daily"){
                    $('#scheduleMonths').prop('disabled', false);
                    $('#scheduleDays').prop('disabled', true).val('');
                    $('#scheduleDaysOfMonth').prop('disabled', true).val('');

                    $('#scheduleMonthsElement').show();
                    $('#scheduleDaysElement').hide();
                    $('#scheduleDaysOfMonthElement').hide();

                    $('#intervalConfigurationTd').show();
                    $('#scheduleDaysElementTd').hide();
                    $('#scheduleMonthsElementTd').attr('colspan', '2');

                }
                else if($(this).val() == "Weekly"){
                    $('#scheduleMonths').prop('disabled', false);
                    $('#scheduleDays').prop('disabled', false);
                    $('#scheduleDaysOfMonth').prop('disabled', true).val('');

                    $('#scheduleMonthsElement').show();
                    $('#scheduleDaysElement').show();
                    $('#scheduleDaysOfMonthElement').hide();

                    $('#intervalConfigurationTd').show();
                    $('#scheduleDaysElementTd').show();
                    $('#scheduleMonthsElementTd').attr('colspan', '');
                }
                else if($(this).val() == "Monthly"){
                    $('#scheduleMonths').prop('disabled', false);
                    $('#scheduleDays').prop('disabled', true).val('');
                    $('#scheduleDaysOfMonth').prop('disabled', false);

                    $('#scheduleMonthsElement').show();
                    $('#scheduleDaysElement').hide();
                    $('#scheduleDaysOfMonthElement').show();

                    $('#intervalConfigurationTd').show();
                    $('#scheduleDaysElementTd').show();
                    $('#scheduleMonthsElementTd').attr('colspan', '');

                }
            }).trigger('change');

            $('.scheduleUpdateDateField').change(function(){
                calculateNextExecutionDate();
            });

        }

        function calculateNextExecutionDate(){
            var scheduleType = $('#scheduleType').val();
            var scheduleStartDate = $('#scheduleStartDate').val();
            var scheduleStartTime = $('#scheduleStartTime').val();
            var scheduleEndTime = $('#scheduleEndTime').val();
            var scheduleMonths = $('#scheduleMonths').val();
            var scheduleDays = $('#scheduleDays').val();
            var scheduleDaysOfMonth = $('#scheduleDaysOfMonth').val();
            var lastExecutionDate = $('#scheduleLastExecutionDate').val();

            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/modules/contractSchedules/controllers/calculateNextExecutionDate.php',
                data: {
                    scheduleType: scheduleType,
                    scheduleStartDate: scheduleStartDate,
                    scheduleStartTime: scheduleStartTime,
                    scheduleEndTime: scheduleEndTime,
                    scheduleMonths: scheduleMonths,
                    scheduleDays: scheduleDays,
                    lastExecutionDate: lastExecutionDate,
                    scheduleDaysOfMonth: scheduleDaysOfMonth
                },
                success: function (result) {

                    if(isNaN(new Date(result))){
                        $('#scheduleNextExecutionDate').val("0000-00-00");
                        var nextExecutionDate = "-";
                    } else {
                        $('#scheduleNextExecutionDate').val(result);
                        var nextExecutionDate = formatDate(result);
                    }

                    $('#scheduleNextExecutionDateDisplay').html(nextExecutionDate);
                }
            });


        }

        function formatDate(date){
            var formatedDate = new Date(date);
            var dd = formatedDate.getDate();
            var mm = formatedDate.getMonth() + 1;
            var yyyy = formatedDate.getFullYear();
            if(dd < 10){dd = '0' + dd;}
            if(mm < 10){mm = '0' + mm;}
            var nextExecutionDateDisplay = dd + '/' + mm + '/' + yyyy;

            return nextExecutionDateDisplay;
        }

        function newScheduleModal(){
            var contractTechnician = $('#assignedTechnician').val();

            $('#contractScheduleID').val(0);
            $('#scheduleName').val('');
            $('#scheduleType').val('Single Date').trigger('change');
            $('#scheduleStartDate').val('<?php echo date('Y-m-d',strtotime(date('Y-m-d') . "+1 days")); ?>');
            $('#scheduleStartTime').val('08:00');
            $('#scheduleEndTime').val('09:00');
            $('#scheduleMonths').val('').trigger('change');
            $('#scheduleDays').val('').trigger('change');
            $('#scheduleDaysOfMonth').val('').trigger('change');
            $('#scheduleStatus').val('Active');
            $('#scheduleSalesperson').val(contractTechnician).trigger('change');
            $('#scheduleScReferred').val('').trigger('change');
            $('#scheduleLastExecutionDate').val('0000-00-00');
            $('#scheduleNextExecutionDate').val('0000-00-00');
            $('#scheduleScType').val($("#scheduleScType option:first").val()).trigger('change');
            $('#scheduleLastExecutionDateDisplay').html('-');
            $('#scheduleNextExecutionDateDisplay').html('-');
            $('#deleteContractScheduleButton').hide();
            $('#contractScheduleModal').modal('show');
        }

        function editContractSchedule(contractScheduleID){
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/modules/contractSchedules/controllers/getSingleContractScheduleJson.php',
                data: {contractScheduleID: contractScheduleID},
                success: function (result) {

                    var response = JSON.parse(result);
                    if(response.status === 1) {

                        $('#scheduleLastExecutionDateDisplay').html(response.scheduleLastExecutionDateDisplay);
                        $('#scheduleNextExecutionDateDisplay').html(response.scheduleNextExecutionDateDisplay);
                        $('#scheduleLastExecutionDate').val(response.scheduleLastExecutionDate);
                        $('#scheduleNextExecutionDate').val(response.scheduleNextExecutionDate);
                        $('#contractScheduleID').val(response.contractScheduleID);
                        $('#scheduleName').val(response.scheduleName);
                        $('#scheduleStartDate').val(response.scheduleStartDate);
                        $('#scheduleStartTime').val(response.startTime);
                        $('#scheduleEndTime').val(response.endTime);
                        $('#scheduleType').val(response.typeOfSchedule).trigger('change');
                        $('#scheduleMonths').val(response.scheduleMonths).trigger('change');
                        $('#scheduleDays').val(response.scheduleDays).trigger('change');
                        $('#scheduleDaysOfMonth').val(response.scheduleDaysOfMonth).trigger('change');
                        $('#scheduleSalesperson').val(response.assignSalespersonID).trigger('change');
                        $('#scheduleScReferred').val(response.referred).trigger('change');
                        $('#scheduleScType').val(response.scTypeID).trigger('change');
                        $('#scheduleStatus').val(response.scheduleStatus);

                        $('#deleteContractScheduleButton').show();
                        $('#contractScheduleModal').modal('show');
                    } else {
                        $.smallBox({
                            title : "Error!",
                            content : response.error,
                            color : "#b22222",
                            timeout: 3000,
                            icon : "fa fa-user swing animated"
                        });
                    }
                }
            });
        }

        function saveContractSchedule(){
            var contractScheduleID = $('#contractScheduleID').val();
            var scheduleStatus = $('#scheduleStatus').val();
            var scheduleSalesperson = $('#scheduleSalesperson').val();
            var scheduleScReferred = $('#scheduleScReferred').val();
            var contractID = $('#contractID').val();
            var scheduleName = $('#scheduleName').val();
            var scheduleType = $('#scheduleType').val();
            var scheduleStartDate = $('#scheduleStartDate').val();
            var scheduleStartTime = $('#scheduleStartTime').val();
            var scheduleEndTime = $('#scheduleEndTime').val();
            var scheduleMonths = $('#scheduleMonths').val();
            var scheduleDays = $('#scheduleDays').val();
            var scheduleDaysOfMonth = $('#scheduleDaysOfMonth').val();
            var scheduleNextExecutionDate = $('#scheduleNextExecutionDate').val();
            var scheduleScType = $('#scheduleScType').val();

            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/modules/contractSchedules/controllers/addEditContractSchedule.php',
                data: {
                    contractScheduleID: contractScheduleID,
                    contractID: contractID,
                    scheduleName: scheduleName,
                    scheduleType: scheduleType,
                    scheduleStartDate: scheduleStartDate,
                    scheduleStartTime: scheduleStartTime,
                    scheduleEndTime: scheduleEndTime,
                    scheduleMonths: scheduleMonths,
                    scheduleDays: scheduleDays,
                    scheduleDaysOfMonth: scheduleDaysOfMonth,
                    scheduleStatus: scheduleStatus,
                    scheduleSalesperson: scheduleSalesperson,
                    scheduleScReferred: scheduleScReferred,
                    scheduleScType: scheduleScType,
                    scheduleNextExecutionDate: scheduleNextExecutionDate
                },
                success: function (result) {
                    var response = JSON.parse(result);
                    if(response.status === 1) {
                        $('#contractScheduleModal').modal('hide');
                        $('#datatable_fixed_column_contract_schedules').DataTable().ajax.reload();
                    } else {
                        $.smallBox({
                            title : "Error!",
                            content : "Something Went Wrong",
                            color : "#b22222",
                            timeout: 3000,
                            icon : "fa fa-user swing animated"
                        });
                        console.log(result);
                    }
                }
            });
        }

        function deleteContractSchedule(){
            var contractScheduleID = $('#contractScheduleID').val();
            var scheduleName = $('#scheduleName').val();
            if(confirm("You are about to Delete Schedule " + scheduleName + ". Are you sure?")) {
                $.ajax({
                    type: "POST",
                    url: '//<?php echo HTML_PATH ?>/cop/backend/modules/contractSchedules/controllers/deleteContractSchedule.php',
                    data: {
                        contractScheduleID: contractScheduleID
                    },
                    success: function (result) {
                        var response = JSON.parse(result);
                        if (response.status === 1) {
                            $('#contractScheduleModal').modal('hide');
                            $('#datatable_fixed_column_contract_schedules').DataTable().ajax.reload();
                        } else {
                            $.smallBox({
                                title: "Error!",
                                content: "Something Went Wrong",
                                color: "#b22222",
                                timeout: 3000,
                                icon: "fa fa-user swing animated"
                            });
                            console.log(result);
                        }
                    }
                });
            }
        }

		function saveProduct()
		{
			$("#saveButton").attr("disabled", true);
			var contractID =$('#contractID').val();
			var serialNumberTransactionLogID =$('#serialNumberTransactionLogID').val();
            var serialNumberID= $('#serialNumberID').val();
			var customerID = $('#customerID').val();
            var customerAddressID = $('#customerAddressID').val();
            var itemID = $('#itemID').val();
            var dateOfContractStart = $('#dateOfContractStart').val();
            var dateOfContractEnd = $('#dateOfContractEnd').val();
            var typeOfContract = $('#typeOfContract').val();
            var underContract = $('#underContract').val();
            var priceOfContract = $('#priceOfContract').val();
            var paymentDueDate = $('#paymentDueDate').val();
            var typeOfPayment = $('#typeOfPayment').val();
            var monthOfPayment = $('#monthOfPayment').val();
            var wayOfPayment = $('#wayOfPayment').val();
            var troubleshooting = $('#troubleshooting').val();
            var assignedSalesperson = $('#assignedSalesperson').val();
            var assignedTechnician = $('#assignedTechnician').val();
            var contractNotes = $('#contractNotes').val();

            <?php
            $custForm->declareJsonVariables();
            $custTable->declareCustomTableJsonVariables();
            ?>

            var run = true;

            if(!customerID || !serialNumberID || !itemID){
                run = false;
            }
            if(run){
			    $.ajax({
				type: "POST",

				<?php
				if($edit && !$copyContract)
				{
				 echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_contract.php',";
				}
				else
				{
				 echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_contract.php',";
				}
	           ?>
				data: {
                    'contractID':contractID,
				    'serialNumberTransactionLogID':serialNumberTransactionLogID,
					'serialNumberID':serialNumberID,
					'customerID':customerID,
					'customerAddressID':customerAddressID,
					'itemID':itemID,
                    'dateOfContractStart':dateOfContractStart,
                    'dateOfContractEnd':dateOfContractEnd,
                    'typeOfContract':typeOfContract,
                    'underContract':underContract,
                    'priceOfContract':priceOfContract,
                    'paymentDueDate':paymentDueDate,
                    'typeOfPayment':typeOfPayment,
                    'monthOfPayment':monthOfPayment,
                    'wayOfPayment':wayOfPayment,
                    'troubleshooting':troubleshooting,
                    'assignedSalesperson':assignedSalesperson,
                    'contractNotes':contractNotes,
                    'assignedTechnician':assignedTechnician
                    <?php
                    $custForm->passJsonVariables();
                    $custTable->passCustomTableJsonVariables();
                    ?>
				},

				success: function (result) {
					//do somthing here
					$.smallBox({
						title : "Success!",
						content : "Product successfully saved",
						color : "#739E73",
						timeout: 3000,
						icon : "fa fa-gift swing animated"
					});

                    <?php echo $windowClose; ?>

					window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/new_contract.php?contract_id=" + result);
				}
			});
            } else {
                $.smallBox({
                    title: "Error!",
                    content: "Please complete Contract data",
                    color: "#b22222",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                $("#saveButton").attr("disabled", false);
            }

			//	alert(JSON.stringify(addresses));

			//	alert(JSON.stringify(contractPrices));
		}

        function initCustomerCodeAutocomplete()
        {
            $("#customerSearch").autocomplete({
                source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
                autoFocus: true,
                select: function (event, ui) {
                    $('#customerID').val(ui.item.customer_id);
                    $('#customerCode').text(ui.item.customer_code);
                    $('#customerName').text(ui.item.customer_company_name);
                    $('#balance').text(ui.item.balance);

                    var optionsAsString = "";
                    for(var i = 0; i < ui.item.addresses.length; i++) {
                        if(i==0)
                        {
                            optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\" selected>" + ui.item.addresses[i].addressLine1 + "</option>";
                        }
                        else{
                            optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\">" + ui.item.addresses[i].addressLine1 + "</option>";
                        }


                    }
                    $("select[name='customerAddressID']").find('option').remove().end().append($(optionsAsString));

                    return true;
                }
            });
        }
        function initAutocomplete()
        {
            $("#itemSearch").autocomplete({
                source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/invoice_autocomplete.php",
                autoFocus: true,
                open: function(){
                    $('.ui-autocomplete').css('width', '400px');
                },
                select: function (event, ui) {

                    // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                    $('#itemID').val(ui.item.item_id); // Hidden input on form
                    $('#itemSearch').val(ui.item.item_code);
                    $('#itemCode').text(ui.item.item_code);
                    $('#itemDetails').text(ui.item.name);
                    $('#itemSKU').text(ui.item.item_sku);

                }
            });
        }

        function initAutocompleteSerialNumber()
        {
            $("#serialNumber").autocomplete({
                source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/serial_number_autocomplete.php?unique=true",
                autoFocus: true,
                open: function(){
                    $('.ui-autocomplete').css('width', '400px');
                },
                select: function (event, ui) {

                    // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                    $('#serialNumberID').val(ui.item.serial_number_id); // Hidden input on form
                    $('#itemID').val(ui.item.item_id); // Hidden input on form
                    $('#itemSearch').val(ui.item.item_code);
                    $('#itemCode').text(ui.item.item_code);
                    $('#itemDetails').text(ui.item.name);


                }
            });
        }


		$(document).ready(function() {
			
			pageSetUp();
            initCustomerCodeAutocomplete();
            initAutocomplete();
            initAutocompleteSerialNumber();
            initContractSchedulesTable();

            //-----------------------------------------Contract Dropzone--------------------------------------------------------

            Dropzone.autoDiscover = false;

            $("#contractDropzone").dropzone({
                //url: "/file/post",
                maxFiles: 10,
                addRemoveLinks : true,
                maxFilesize:15,
                dictResponseError: 'Error uploading file!',
                init: function() {

                    var thisDropzone = this;

//                    this.on("thumbnail", function(file) {
//                        //  alert("test");
//                        file.previewElement.addEventListener("click", function() {
//                            alert(file.name);
//                        });
//                    });

                    $.getJSON('//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getContractAttachments.php?contractID=<?php echo $contractID?>', function(data) { // get the json response

                        $.each(data, function(key,value){ //loop through it


                            var mockFile = { name: value.name, size: value.size }; // here we get the file name and size as response
                            var thumbnail = '';

                            if(value.name.toLowerCase().includes(".jpg") || value.name.toLowerCase().includes(".jpeg") || value.name.toLowerCase().includes(".png")){
                                thumbnail = "//<?php echo HTML_PATH ?>/cop/media/contractAttachments/"+value.name;
                            } else if(value.name.toLowerCase().includes(".mp4") || value.name.toLowerCase().includes(".3gp") || value.name.toLowerCase().includes(".wmv")|| value.name.toLowerCase().includes(".wav")) {
                                thumbnail = "//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/videoicon.png";
                            } else if(value.name.toLowerCase().includes(".pdf")) {
                                thumbnail = "//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/pdficon.png";
                            } else  {
                                thumbnail = "//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/generaldoc.png";
                            }


                            thisDropzone.options.addedfile.call(thisDropzone, mockFile);

                            thisDropzone.options.thumbnail.call(thisDropzone, mockFile, thumbnail );//uploadsfolder is the folder where you have all those uploaded files

                            mockFile.previewElement.addEventListener("click", function() {
                                window.open('//<?php echo HTML_PATH ?>/cop/media/contractAttachments/' + mockFile.name,'_blank');
                            });
                        });
                    });
                } ,
                removedfile: function(file) {
                    var name = file.name;
                    $.ajax({
                        type: 'POST',
                        url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/delete/deleteContractAttachment.php',
                        data: {attachmentName:name,contractID:<?php if($edit){echo $contractID;}else{echo 0;}?>},
                        dataType: 'html'

                    });

                    var _ref;
                    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
                }
            }).get(0).dropzone.on("addedfile", function(file)
            {

            });

            $("#contractDropzone").sortable({
                items:'.dz-preview',
                cursor: 'move',
                opacity: 0.5,
                containment: '#contractDropzone',
                distance: 20,
                tolerance: 'pointer',
                update: function( event, ui ) {

                    var fileNames = [];

                    $('#contractDropzone .dz-filename span').each(function(i, selected){
                        fileNames[i] = $(this).html();
                    });

                    //$.ajax({
                    //    type: 'POST',
                    //    url: '../reorderCustomerAttachments.php',
                    //    data: {filenames:fileNames,customerID:<?php //echo $customerID?>//},
                    //    success: function (result) {
                    //    }
                    //});
                }
            });
        });



		</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/notification/SmartNotification.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/dropzone/dropzone.min.js"></script>