<?php
include_once("../../../../param.php");

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$groupSelection = "<option value=''></option>";
$allowedGroups = $_SESSION['Allow_CustomerGroups'];
$whereGroups='';
if(!empty($allowedGroups)) {
    $whereGroups = "WHERE group_id IN ($allowedGroups)";
}
$stm = $db->prepare("SELECT CONCAT(group_code, ' - ', name) as display_name, group_id 
                            FROM CustomerGroups 
                            $whereGroups
                            ORDER BY group_code");
$stm->execute();
$stm->bind_result($groupName, $groupID);
while ($stm->fetch()) {
    $groupSelection .= "<option value='$groupID'>$groupName</option>";
}
$stm->close();

$subgroupSelection = $groupSelection;
?>


<div id="main" role="main">
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Sub Customer Groups</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    <i class="fa fa-users"></i> Sub Customer Groups
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons">
                    <span>
                        <a href="javascript:void(0);" class="btn btn-primary btn-block" onclick="openNewModal();">
                            <i class="fa fa-plus"></i>&nbsp; New Sub Customer Group
                        </a>
                    </span>
                </span>
            </div>
        </div>

        <!-- widget grid -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Sub Customer Groups Table</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Group" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Subgroup" />
                                        </th>
                                        <th class="hasinput" style="width:15%">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class="text-center">Group</th>
                                        <th class="text-center">Subgroup</th>
                                        <th class="text-center">Actions</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="newSubCustomerGroup" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document" style="width: 600px;">
        <div class="modal-content">
            <div class="modal-header">
                <center>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                        <span aria-hidden="true" id="closeModalBtn">&times;</span>
                    </button>
                    <h4 class="modal-title" style="display: inline-block;"><strong>New Group Relation</strong></h4>
                </center>
            </div>
            <div class="modal-body">
                <input type="hidden" id="editGroupId">
                <input type="hidden" id="editSubgroupId">
                <table class="table table-bordered">
                    <tr>
                        <td style="width:25%">Group:</td>
                        <td>
                            <select class="form-control text-center" id="groupSelection">
                                <?php echo $groupSelection; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Subgroup:</td>
                        <td>
                            <select class="form-control text-center" id="subgroupSelection">
                                <?php echo $subgroupSelection; ?>
                            </select>
                        </td>
                    </tr>
                </table>

                <br>
                <center>
                    <button type="button" id="saveButton" style="width:100px" class="btn btn-success" onclick="saveSubCustomerGroup()">Save</button>
                </center>
            </div>
        </div>
    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">
    function openNewModal() {
        clearModalFields();
        $('#newSubCustomerGroup .modal-title').html('<strong>New Sub Customer Group</strong>');
        $('#saveButton').text('Save');
        $('#newSubCustomerGroup').modal('show');
    }

    function clearModalFields() {
        $('#editGroupId').val('');
        $('#editSubgroupId').val('');
        $('#groupSelection').val('').trigger('change');
        $('#subgroupSelection').val('').trigger('change');
    }

    function openEditModal(groupId, subgroupId) {
        clearModalFields();
        $('#editGroupId').val(groupId);
        $('#editSubgroupId').val(subgroupId);

        $('#groupSelection').val(groupId).trigger('change');
        $('#subgroupSelection').val(subgroupId).trigger('change');

        $('#newSubCustomerGroup .modal-title').html('<strong>Edit Sub Customer Group</strong>');
        $('#saveButton').text('Update');
        $('#newSubCustomerGroup').modal('show');
                
           
    }

    function highlightDataError(element) {
        element.css('border-color', '#b22222').css('background-color', '#fff0f0');
        element.focus();
        element.on('input', function() {
            $(this).css('border-color', '').css('background-color', '');
        });
    }

    function saveSubCustomerGroup() {
        var groupId = $('#groupSelection').val();
        var subgroupId = $('#subgroupSelection').val();
        var editGroupId = $('#editGroupId').val();
        var editSubgroupId = $('#editSubgroupId').val();

        if (!groupId || !subgroupId) {
            $.smallBox({
                title: "Warning!",
                content: "Please fill in all required fields",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-warning swing animated"
            });

            if (!groupId) highlightDataError($('#groupSelection'));
            if (!subgroupId) highlightDataError($('#subgroupSelection'));
            return;
        }

         var url = $('#editGroupId').val() ?
            '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/edit/edit_sub_customer_group.php' :
            '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/add/add_sub_customer_group.php';

        $.ajax({
            type: "POST",
            url: url,
            data: {
                'groupId': groupId,
                'subgroupId': subgroupId,
                'editGroupId':editGroupId,
                'editSubgroupId':editSubgroupId
            },

            success: function(result) {
                if (result === "success") {
                    $.smallBox({
                        title: "Success!",
                        content: "Group relation successfully " + ($('#editGroupId').val()  ? "updated" : "saved"),
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-check swing animated"
                    });
                    $('#newSubCustomerGroup').modal('hide');
                    $('#datatable_fixed_column').DataTable().draw(null, false);
                } else if (result === "existingRelation") {
                    $.smallBox({
                        title: "Warning!",
                        content: "This relationship already exists",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-warning swing animated"
                    });
                } else if (result === "selfReference") {
                    $.smallBox({
                        title: "Warning!",
                        content: "A group cannot be a subgroup of itself",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-warning swing animated"
                    });
                } else if (result === "circularReference") {
                    $.smallBox({
                        title: "Warning!",
                        content: "Cannot create circular relationship.",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-warning swing animated"
                    });
                } else {
                    $.smallBox({
                        title: "Error!",
                        content: "Failed to save group relation",
                        color: "#C46A69",
                        timeout: 3000,
                        icon: "fa fa-times swing animated"
                    });
                }
                $('#saveButton').prop('disabled', false);
            }
        });
    }

    $(document).ready(function() {
        pageSetUp();

        $('#groupSelection, #subgroupSelection').select2({
            minimumInputLength: 2

        });

        $('#closeModalBtn').on('click', function() {
            $('#newSubCustomerGroup').modal('hide');
        });

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/getAll/getAllSubCustomerGroups.php",
            },
            "columns": [
                { "data": "group_column" },
                { "data": "subgroup_column" },
                { "data": "form" }
            ],
            "deferRender": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
    });
</script>