<?php
include_once("../../../../param.php");
global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$customerSelection =  "<option value=''></option>";
$stm = $db->prepare("SELECT CONCAT(customer_code, ' - ', customer_company_name) , customer_id FROM Customers ORDER BY customer_code");
$stm->execute();
$stm->bind_result($customerName, $customerID);
while ($stm->fetch()) {
    $customerSelection .= "<option value='$customerID'>$customerName</option>";
}
$stm->close();

$subcustomerSelection = $customerSelection;
?>

<div id="main" role="main">
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Sub Customers</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    <i class="fa fa-users"></i> Sub Customers
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"><span><a href="javascript:void(0);" class="btn btn-primary btn-block" onclick="openNewModal();"><i class="fa fa-plus"></i>&nbsp; New Sub Customer</a></span></span>
            </div>
        </div>

        <!-- widget grid -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Sub Customers Table</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Customer" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Sub Customer" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Type" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Position" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Notes" />
                                        </th>
                                        <th class="hasinput" style="width:15%">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class="text-center">Customer</th>
                                        <th class="text-center">Sub Customer</th>
                                        <th class="text-center">Type</th>
                                        <th class="text-center">Position</th>
                                        <th class="text-center">Notes</th>
                                        <th class="text-center">Actions</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>
    </div>
</div>
<style>
    .modal-dialog {
        width: 90%;
        max-width: 800px;
    }

    .modal-content {
        height: auto; /* Allow the content to adjust its height */
    }
</style>
<!-- Modal -->
<div class="modal fade" id="newSubCustomer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <center>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                        <span aria-hidden="true" id="closeModalBtn">&times;</span>
                    </button>
                    <h4 class="modal-title" style="display: inline-block;"><strong>New Sub Customer</strong></h4>
                </center>
            </div>
            <div class="modal-body">
                <input type="hidden" id="editType">
                <input type="hidden" id="editCustomerId">
                <input type="hidden" id="editSubcustomerId">
                <table class="table table-bordered">
                    <tr>
                        <td>Customer:</td>
                        <td>
                            <select class="form-control text-center" id="customerSelection" >
                                <?php echo $customerSelection; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Sub Customer:</td>
                        <td>
                            <select class="form-control text-center"  id="subcustomerSelection">
                                <?php echo $subcustomerSelection; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Type:</td>
                        <td>
                            <select class="form-control text-center" id="type">
                                <option value="sub">Sub Account</option>
                                <option value="rep">Representative</option>
                            </select>
                        </td>

                    </tr>
                    <tr>
                        <td>Position:</td>
                        <td><input class="form-control text-center" type="number" id="position"></td>
                    </tr>
                    <tr>
                        <td>Notes:</td>
                        <td><textarea class="form-control" id="notes" rows="3"></textarea></td>
                    </tr>
                </table>

                <br>
                <center>
                    <button type="button" id="saveButton" style="width:100px" class="btn btn-success" onclick="saveSubCustomer()">Save</button>
                </center>
            </div>
        </div>
    </div>
</div>

<style>

</style>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">
    function openNewModal() {
        clearModalFields();
        $('#newSubCustomer .modal-title').html('<strong>New SubCustomer</strong>');
        $('#saveButton').text('Save');
        $('#newSubCustomer').modal('show');
    }

    function clearModalFields() {
        $('#editType').val('');
        $('#editCustomerId').val('');
        $('#editSubcustomerId').val('');
        $('#customerSelection').val('').trigger("change");
        $('#subcustomerSelection').val('').trigger("change");
        $('#type').val('').trigger("change");
        $('#position').val('');
        $('#notes').val('');
    }

    function openEditModal(customerId, subcustomerId, type) {
        clearModalFields();
        $.ajax({
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getSubCustomer.php',
            type: 'POST',
            data: {
                'customerId': customerId,
                'subcustomerId': subcustomerId,
                'type': type
            },
            dataType: 'json',
            success: function(response) {
                if (response != null) {
                    $('#editCustomerId').val(response.customer_id);
                    $('#editSubcustomerId').val(response.subcustomer_id);
                    $('#customerSelection').val(response.customer_id).trigger("change");
                    $('#subcustomerSelection').val(response.subcustomer_id).trigger("change");
                    $('#type').val(response.type).trigger("change");
                    $('#editType').val(response.type);

                    $('#position').val(response.position);
                    $('#notes').val(response.notes);

                    $('#newSubCustomer .modal-title').html('<strong>Edit Sub Customer</strong>');
                    $('#saveButton').text('Update');
                    $('#newSubCustomer').modal('show');
                }
            }
        });
    }

    function highlightDataError(element) {
        element.css('border-color', '#b22222').css('background-color', '#fff0f0');
        element.focus();
        element.on('input', function() {
            $(this).css('border-color', '').css('background-color', '');
        });
    }

    function saveSubCustomer() {
        //the key before change
        var editCustomerId = $('#editCustomerId').val();
        var editSubcustomerId = $('#editSubcustomerId').val();
        var editType = $('#editType').val();

        var customerId = $('#customerSelection').val();
        var subcustomerId =  $('#subcustomerSelection').val();
        var type = $('#type').val();
        var position = $('#position').val();
        var notes = $('#notes').val();

        if (!customerId || !subcustomerId || !type ) {
            $.smallBox({
                title: "Warning!",
                content: "Please fill in all required fields",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-warning swing animated"
            });

            if (!customerId) highlightDataError($('#customerSelection'));
            if (!subcustomerId) highlightDataError($('#subcustomerSelection'));
            if (!type) highlightDataError($('#type'));
            return;
        }

        var url = $('#editCustomerId').val() ?
            '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/edit/edit_sub_customer.php' :
            '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/add/add_sub_customer.php';

        $.ajax({
            type: "POST",
            url: url,
            data: {
                'editType' :editType,
                'editSubcustomerId' :editSubcustomerId,
                'editCustomerId': editCustomerId,
                'customerId': customerId,
                'subcustomerId': subcustomerId,
                'type': type,
                'position': position,
                'notes': notes
            },
            success: function(result) {
                if (result === "success") {
                    $.smallBox({
                        title: "Success!",
                        content: "Sub Customer successfully " + ($('#editCustomerId').val() ? "updated" : "saved"),
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-check swing animated"
                    });
                    $('#newSubCustomer').modal('hide');
                    $('#datatable_fixed_column').DataTable().draw(null, false);
                } else if (result === "existingRelation") {
                    $.smallBox({
                        title: "Warning!",
                        content: "This relationship already exists",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-warning swing animated"
                    });
                } else if (result === "selfReference") {
                    $.smallBox({
                        title: "Warning!",
                        content: "A customer cannot be a Sub Customer of itself",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-warning swing animated"
                    });
                } else if (result === "circularReference") {
                    $.smallBox({
                        title: "Warning!",
                        content: "Cannot create circular relationship.",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-warning swing animated"
                    });
                } else {
                    $.smallBox({
                        title: "Error!",
                        content: "Failed to save Sub Customer",
                        color: "#C46A69",
                        timeout: 3000,
                        icon: "fa fa-times swing animated"
                    });
                }
                $('#saveButton').prop('disabled', false);
            }
        });
    }

    $(document).ready(function() {
        pageSetUp();

        $('#customerSelection').select2({
            minimumInputLength: 2
        });

        $('#subcustomerSelection').select2({
            minimumInputLength: 2
        });

        $('#closeModalBtn').on('click', function() {
            $('#newSubCustomer').modal('hide');
        });

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/getAll/getAllSubCustomers.php",
            },
            "columns": [
                { "data": "customer" },
                { "data": "subcustomer" },
                { "data": "type" },
                { "data": "position" },
                { "data": "notes" },
                { "data": "form" }
            ],
            "deferRender": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
    });
</script>