<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Html;


include_once("../../../../param.php");
require_once (ROOT . "libs/phpSpreadsheet/vendor/autoload.php");

$year          = $_POST['year'];

$salesPersonWhere = '';
if(!empty($_POST['salesPersonIDs'])){
    $salesPersonIDs = $_POST['salesPersonIDs'];

    if(str_contains($salesPersonIDs, ',')) {
        $salesPersonWhere = " WHERE s.salesperson_id IN ($salesPersonIDs) ";
    }
    else{
        $salesPersonWhere = " WHERE s.salesperson_id = ".$salesPersonIDs;
    }

}

if(empty($year)){
    $year = date('Y');
}

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT salesperson_code, CONCAT(first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id = ?  LIMIT 1");
$stm->bind_param("i", $salesPersonID);
$stm->execute();
$stm->bind_result($salesPersonCode, $salesPersonName);
while($stm->fetch()){}
$stm->close();
$db->close();

//$salesPersonCustomerGroup = getCustomerGroupForSalesperson($salesPersonWhere);
$todayDate = date('d/m/Y');
$header = "<table>
              <tr>
                <td><b>Date of Issue: $todayDate</b></td>
                <td><b>Year: $year</b></td>
              </tr>
            </table>";



$visitsData = getVisitsData($year,$salesPersonWhere);


$yearlyHTML = $header.generateYearlyReport($visitsData);
$htmlCodesByPeriod = [];
$htmlCodesByPeriod['yearly'] = $yearlyHTML;
for ($month = 1; $month <= 12; $month++) {
    $report = generateMonthlyReport($month,$year, $visitsData);
    if(!empty($report)){
        $htmlCodesByPeriod["month_$month"] = $header.$report;

    }
}

 $result = exportToExcel($htmlCodesByPeriod);


echo $result;

function getVisitsData($year,$salesPersonWhere){
    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stm = $db->prepare("SELECT c.customer_id, c.customer_code, c.customer_company_name, v.visit_date, s.salesperson_id, s.salesperson_code, CONCAT(s.first_name, ' ', s.last_name) AS salesperson_name
                                FROM Customers AS c
                                LEFT JOIN Visits AS v ON c.customer_id = v.customer_id AND YEAR(v.visit_date) = ? 
                                LEFT JOIN Customer_CustomersGroup AS ccg ON c.customer_id = ccg.customer_id 
                                LEFT JOIN Allow_CustomerGroups AS acg ON ccg.group_id = acg.group_id 
                                INNER JOIN SalesPersons AS s ON acg.salesperson_id = s.salesperson_id OR v.salesperson_id = s.salesperson_id 
                                 $salesPersonWhere 
                                ORDER BY s.salesperson_id, v.visit_date, c.customer_code ASC;");


    $stm->bind_param("s",$year);
    $stm->execute();
    $stm->bind_result($customerID, $customerCode, $customerName, $visitDate, $salesPersonID,$salesPersonCode,$salesFullName);

    $visitsData = [];
    while ($stm->fetch()) {
        if (!isset($visitsData[$customerID])) {
            $visit = new stdClass();
            $visit->customerCode = $customerCode;
            $visit->customerName = $customerName;
            $visit->months = [];
            $visit->salesPersonID = $salesPersonID;
            $visit->salesPersonCode = $salesPersonCode;
            $visit->salesPersonName = $salesFullName;
            $visitsData[$customerID] = $visit;
        }

        if ($visitDate) {
            $time = date('H:i', strtotime($visitDate));
            $month = (int) date('n', strtotime($visitDate));
            $day = (int) date('j', strtotime($visitDate));
            if (!isset($visitsData[$customerID]->months[$month])) {
                $visitsData[$customerID]->months[$month] = [];
            }
            $visitsData[$customerID]->months[$month][$day] = $time;
        }
    }

//    $salesPersonIDs=[];
//    foreach ($visitsData as $visit) {
//        $salesPersonIDs[] = $visit->salesPersonID;
//    }
//    $salesPersonIDs = array_unique($salesPersonIDs)  ;
//    foreach($salesPersonIDs as $salesPersonID) {
//        $otherCustomerIDs = $salesPersonCustomerGroup["$salesPersonID"];
//        foreach ($otherCustomerIDs as $customerID) {
//            if (!isset($visitsData[$customerID])) {
//                $visit = new stdClass();
//                $visit->customerCode = $customerID->code;
//                $visit->customerName = $customerID->name;
//                $visit->months = [];
//                $visit->salesPersonID = $salesPersonID;
//                $visit->salesPersonCode = $salesPersonCode;
//                $visit->salesPersonName = $salesFullName;
//                $visitsData[$customerID] = $visit;
//            }
//        }
//    }
    $stm->close();

//    usort($visitsData, function ($a, $b) {
//        return strcmp($a->salespersonID, $b->salespersonID);
//    });

    return $visitsData;

}
function generateYearlyReport( $visitsData){
    $result = '';
    $months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

    $counter = 1;
    $previousSalesPersonID = null;
    $totalYearlyPerSalesperson = 0;
    $totalYearly=0;

    foreach ($visitsData as $visit) {
        if ($previousSalesPersonID !== $visit->salesPersonID) {
            if ($previousSalesPersonID !== null) {
                $result .= "</table>";
                $result = str_replace("<span id='total_{$previousSalesPersonID}'>0</span>", "$totalYearlyPerSalesperson", $result);
                $counter=1;
                $totalYearlyPerSalesperson = 0;

            }
//            $result .= "<p> ({$visit->salesPersonCode}) {$visit->salesPersonName} - <b>Total Visits:&nbsp;  <span id='total_{$visit->salesPersonID}'>0</span></b></p>";


            $result.=  '<table style="border-collapse: collapse; width: 100%; ">';
            $result .= "<tr ><th style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>
                <p> ({$visit->salesPersonCode}) {$visit->salesPersonName} - <b>Total Visits:&nbsp;  <span id='total_{$visit->salesPersonID}'>0</span></b></p>
            </th>
            </tr>";

            $result .= "<tr ><th style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>A/A</th>
                <th  style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>Customer Code</th>
                <th  style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>Customer Name</th>";

            for ($i = 0; $i < count($months); $i++) {
                $result .= "<th  style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>{$months[$i]}</th>";
                $result .= "<th  style='border: 1px solid black;text-align: center; padding: 12px;background:#d3d3d3;'>Total</th>";
            }

            $result .= "</tr>";
            $previousSalesPersonID = $visit->salesPersonID;

        }

        $result.= "<tr>";
        $result.= "<td  style='border: 1px solid black;text-align: center; padding: 12px;'>$counter</td>";
        $result.= "<td  style='border: 1px solid black;text-align: left; padding: 12px;'>$visit->customerCode</td>";
        $result.= "<td  style='border: 1px solid black;text-align: left; padding: 12px;'>$visit->customerName</td>";
        for ($m = 1; $m <= 12; $m++) {
            $visitDays = array();
            if (isset($visit->months[$m])) {
                $visitDays = array_keys($visit->months[$m]);
            }
            $visitDays = array_unique($visitDays);
            $totalMonth = count($visitDays);
            $totalYearlyPerSalesperson += $totalMonth;
            $totalYearly += $totalMonth;
            $visitDays = implode(", ", $visitDays);
            $result.= "<td  style='border: 1px solid black;text-align: right; padding: 12px;'>$visitDays</td>";
            $result.= "<td  style='border: 1px solid black;text-align: right; padding: 12px;'>$totalMonth</td>";
        }

        $result.= "</tr>";
        $counter++;

    }

    if ($previousSalesPersonID !== null) {
        $result = str_replace("<span id='total_{$previousSalesPersonID}'>0</span>", "$totalYearlyPerSalesperson", $result);
        $result .= "</table>";

    }

    $result .= "<table style='width:100%; border: 1px solid #ddd;'>
        <tr>
            <td style='padding: 10px; text-align: left; font-size: 15px; background-color: #cadbf7;'><b>Total Yearly Visits:</b></td>
            <td style='padding: 10px; text-align: left; font-size: 15px; background-color: #cadbf7;'>$totalYearly    </td>
        </tr>
    </table>";



    return $result;

}

function generateMonthlyReport($month, $year, $visitsData) {
    $daysInMonth =    date("t", mktime(0, 0, 0, $month, 10, $year));
    $result = '';
    $counter = 1;
    $totalMonthly = 0;
    $totalMonthlyPerSalesPerson = 0;
    $previousSalesPersonID=null;
    foreach ($visitsData as $visit) {
        if (!isset($visit->months[$month])) {
            continue;
        }
        if ($previousSalesPersonID !== $visit->salesPersonID) {
            if ($previousSalesPersonID !== null) {
                $result .= "</table>";
                $result = str_replace("<span id='total_{$previousSalesPersonID}'>0</span>", "$totalMonthlyPerSalesPerson", $result);
                $counter=1;
                $totalMonthlyPerSalesPerson = 0;

            }
//            $result .= "<p> ({$visit->salesPersonCode}) {$visit->salesPersonName} - <b>Total Visits:&nbsp;  <span id='total_{$visit->salesPersonID}'>0</span></b></p>";
            $result .= '<table style="border-collapse: collapse; width: 100%;">';
            $result .= "<tr ><th style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>
                <p> ({$visit->salesPersonCode}) {$visit->salesPersonName} - <b>Total Visits:&nbsp;  <span id='total_{$visit->salesPersonID}'>0</span></b></p>
            </th>
            </tr>";
            $result .= "<tr>
        <th style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>A/A</th>
        <th style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>Customer Code</th>
        <th style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>Customer Name</th>";

            for ($day = 1; $day <= $daysInMonth; $day++) {
                $result .= "<th style='border: 1px solid black;text-align: center; padding: 12px;background:#cadbf7;'>$day</th>";
            }
            $result .= "<th style='border: 1px solid black;text-align: center; padding: 12px;background:#d3d3d3;'>Total</th></tr>";
            $previousSalesPersonID = $visit->salesPersonID;

        }


        $result .= "<tr>";
        $result .= "<td style='border: 1px solid black;text-align: center; padding: 12px;'>$counter</td>";
        $result .= "<td style='border: 1px solid black;text-align: left; padding: 12px;'>$visit->customerCode</td>";
        $result .= "<td style='border: 1px solid black;text-align: left; padding: 12px;'>$visit->customerName</td>";

        $totalVisits = 0;
        for ($day = 1; $day <= $daysInMonth; $day++) {
            $visitTimes = [];
            if (isset($visit->months[$month][$day])) {
                $visitTimes[] = $visit->months[$month][$day];
            }

            $visitTimesText = implode(", ", $visitTimes);
            $totalVisits += count($visitTimes);
            $totalMonthly += count($visitTimes);
            $totalMonthlyPerSalesPerson +=  count($visitTimes);
            $result .= "<td style='border: 1px solid black;text-align: right; padding: 12px;'>$visitTimesText</td>";
        }

        $result .= "<td style='border: 1px solid black;text-align: right; padding: 12px;'>$totalVisits</td>";
        $result .= "</tr>";
        $counter++;
    }

    if ($totalMonthly === 0) {
        return "";
    }

    if ($previousSalesPersonID !== null) {
        $result = str_replace("<span id='total_{$previousSalesPersonID}'>0</span>", "$totalMonthlyPerSalesPerson", $result);
        $result .= "</table>";

        $result .= "<table style='width:100%; border: 1px solid #ddd;'>
                <tr>
                    <td style='padding: 10px; text-align: left; font-size: 15px; background-color: #cadbf7;'><b>Total Monthly Visits:</b></td>
                    <td style='padding: 10px; text-align: left; font-size: 15px; background-color: #cadbf7;'>$totalMonthly</td>
                </tr>
            </table>";
    }

    return $result;
}

function exportToExcel($htmlCodesByPeriod) {
    $spreadsheet = new Spreadsheet();
    $reader = new Html();
    $cu = 0;

    $yearlyHTML = $htmlCodesByPeriod['yearly'];
    $spreadsheet->createSheet($cu);
    $spreadsheet->getSheet($cu)->setTitle('Yearly');
    $spreadsheet->getSheet($cu)->getTabColor()->setRGB('ff6961');
    $reader->setSheetIndex($cu);
    $reader->loadFromString($yearlyHTML, $spreadsheet);
    $cu++;

    for ($month = 1; $month <= 12; $month++) {
        if(!isset($htmlCodesByPeriod["month_$month"])){
            continue;
        }
        $monthlyHTML = $htmlCodesByPeriod["month_$month"];
        $monthName = date('F', mktime(0, 0, 0, $month, 1));

        $spreadsheet->createSheet($cu);
        $spreadsheet->getSheet($cu)->setTitle("$monthName");
        $spreadsheet->getSheet($cu)->getTabColor()->setRGB('fdfd96');
        $reader->setSheetIndex($cu);
        $reader->loadFromString($monthlyHTML, $spreadsheet);
        $cu++;
    }

    foreach ($spreadsheet->getAllSheets() as $sheet) {
        foreach (range("A", $sheet->getHighestDataColumn()) as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }
    }



    foreach ($spreadsheet->getAllSheets() as $sheet) {
      //  $sheet->freezePane('A6');
        $sheet->getColumnDimension("B")->setWidth('25');
        $sheet->getColumnDimension("c")->setWidth('75');
    }

    $spreadsheet->setActiveSheetIndex('0');


    ob_start();
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    $ret = base64_encode(ob_get_contents());
    ob_end_clean();
    return $ret;
}

function getCustomerGroupForSalesperson($where){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ERROR);
    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $groupArrayIDs = array();
    $stm = $db->prepare("SELECT group_id,salesperson_id FROM Allow_CustomerGroups WHERE 1=1 $where");
    $stm->execute();
    $stm->bind_result($groupID,$salespersonID);
    while($stm->fetch()){
        if (!is_array($groupArrayIDs["$salespersonID"])){
            $groupArrayIDs["$salespersonID"] = array();
        }
        array_push($groupArrayIDs["$salespersonID"],$groupID);
    }
    $stm->close();

    $returnArray = array();
    foreach ($groupArrayIDs as $salespersonID=>$group){
        if (count($group)>0) {
            $whereGroup = implode('', $group);
            $tempArray = array();
            $stm = $db->prepare("SELECT c.customer_id, c.customer_code, c.customer_company_name
                        FROM Customer_CustomersGroup AS cg
                        INNER JOIN Customers AS c ON c.customer_id = cg.customer_id 
                        WHERE  cg.group_id IN ('$whereGroup')
                        ");
            $stm->execute();
            $stm->bind_result($customerID, $customerCode, $customerName);
            while ($stm->fetch()) {
                $tempObj = new stdClass();
                $tempObj->customerCode = $customerCode;
                $tempObj->customerName = $customerName;
                $tempArray["$customerID"] = $tempObj;
            }
            $stm->close();
            $returnArray["$salespersonID"] = $tempArray;
        }
    }
    return $returnArray;
}

function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}
?>