<?php
include_once("../../../../param.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

$where   = "";

$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);
$dateFilterType  = trim($_POST['dateFilterType']);
$analyticOrSummary = trim($_POST['analyticOrSummary']);
$customerSearch  = $_POST['customerSearch'];
$itemSearch  = $_POST['itemSearch'];
$salespersonSearch  = $_POST['salespersonSearch'];
$orderPrefix = trim($_POST['orderPrefix']);



if(strcmp($analyticOrSummary,'all')==0){
    $showAnalytic = true;
    $showSummary = true;
} else if(strcmp($analyticOrSummary,'summary')==0){
    $showAnalytic = false;
    $showSummary = true;
} else if(strcmp($analyticOrSummary,'analytic')==0){
    $showAnalytic = true;
    $showSummary = false;
}

if(strcmp($salespersonSearch,'')!=0) {
    $formSalesperson = explode(',', $salespersonSearch)[0];
}


if(strcmp($dateFrom,'')==0){
    $dateFrom = date('Y-m-d');
}

if(strcmp($dateTo,'')==0){
    $dateTo = date('Y-m-d');
}


if(strcmp($dateFilterType,'dueDate')==0){
    $where .= " AND Orders.delivery_date BETWEEN '$dateFrom' AND '$dateTo'";
} else {
    $where .= " AND Orders.order_date BETWEEN '$dateFrom' AND '$dateTo'";
}

if(strcmp($orderPrefix,'')!=0){$where .= " AND Orders.order_code LIKE '$orderPrefix%'";}


if(strcmp($customerSearch,'')!=0){$where .= " AND Orders.customer_id IN ($customerSearch)";}
if(strcmp($itemSearch,'')!=0){$where .= " AND Order_Item.item_id IN ($itemSearch)";}
if(strcmp($salespersonSearch,'')!=0){$where .= " AND Orders.salesperson_id IN ($salespersonSearch)";}

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$vats = array();
$stm = $db->prepare("SELECT vat_id,vat_code,vat_display_name,percentage FROM Vats ");
$stm->execute();
$stm->bind_result($id,$code,$name,$percent);
while ($stm->fetch()) {
    $vatObject = new stdClass();
    $vatObject->id = $id;
    $vatObject->code = $code;
    $vatObject->name = $name;
    $vatObject->percent = $percent;
    array_push($vats,$vatObject);
}

$vatAmounts = array();
$orders = array();
$items = array();
$totals = array();
$prevInvoiceID = 0;
$stm = $db->prepare(" SELECT Orders.order_id,customer_id,salesperson_id,order_code,order_date,Orders.details,Orders.status,subtotal,Orders.vat_amount,discount_amount,grand_total,Order_Item.vat_amount,Order_Item.vat_id,unit_price,qty,line_discount,global_discount_percentage,Order_Item.item_id,Items.item_code,Items.name,Items.subunits
                            FROM Orders,Order_Item,Items
                            WHERE Orders.order_id=Order_Item.order_id
                            AND Order_Item.item_id=Items.item_id
                            AND NOT Orders.status = 'Canceled'
                            $where
                            ");
$stm->execute();
$stm->bind_result($orderID,$customerID,$salespersonID,$orderCode,$orderDate,$orderNotes,$orderStatus,$orderSubtotal,$orderVAT,$orderDiscount,$orderTotal,$lineVat,$vatID,$unitPrice,$qty,$lineDiscount,$globalDiscount,$itemID,$itemCode,$itemName,$subunits);
while ($stm->fetch()) {

    if(intval($subunits) < 1){$subunits = 1;}

    $items[$itemID]['id'] = $itemID;
    $items[$itemID]['code'] = $itemCode;
    $items[$itemID]['name'] = $itemName;
    $items[$itemID]['subunits'] = $subunits;
    $items[$itemID]['amount'] += (floatval($unitPrice)*(floatval($qty)/intval($subunits))) - floatval($lineDiscount) - floatval($globalDiscount);
    $items[$itemID]['vat'] += floatval($lineVat);
    $items[$itemID]['qty'] += floatval($qty)/intval($subunits);

    if(!is_array($items[$itemID]['orders'])){$items[$itemID]['orders'] = array();}
    array_push($items[$itemID]['orders'],$orderID);
    $items[$itemID]['orders'] = array_unique($items[$itemID]['orders']);

    if(!is_array($items[$itemID]['customers'])){$items[$itemID]['customers'] = array();}
    array_push($items[$itemID]['customers'],$customerID);
    $items[$itemID]['customers'] = array_unique($items[$itemID]['customers']);

    if(!is_array($items[$itemID]['salespersons'])){$items[$itemID]['salespersons'] = array();}
    array_push($items[$itemID]['salespersons'],$salespersonID);
    $items[$itemID]['salespersons'] = array_unique($items[$itemID]['salespersons']);

    $totals['amount'] += (floatval($unitPrice)*floatval($qty)/intval($subunits)) - floatval($lineDiscount) - floatval($globalDiscount);
    $totals['vat'] += floatval($lineVat);
    $totals['qty'] += floatval($qty)/intval($subunits);

    if(!is_array($totals['orderIDs'])){$totals['orderIDs'] = array();}
    array_push($totals['orderIDs'],$orderID);
    $totals['orderIDs'] = array_unique($totals['orderIDs']);

    if(!is_array($totals['customerIDs'])){$totals['customerIDs'] = array();}
    array_push($totals['customerIDs'],$customerID);
    $totals['customerIDs'] = array_unique($totals['customerIDs']);

    if(!is_array($totals['salespersonIDs'])){$totals['salespersonIDs'] = array();}
    array_push($totals['salespersonIDs'],$salespersonID);
    $totals['salespersonIDs'] = array_unique($totals['salespersonIDs']);


    $totals['orders'] = count($totals['orderIDs']);
    $totals['customers'] = count($totals['customerIDs']);
    $totals['salespersons'] = count($totals['salespersonIDs']);

}
$stm->close();



if(count($items) > 0) {

    $reportAnalytics  = "<table class='table table-striped bordered' style='margin: 1px !important;'>";
    $reportAnalytics .= "<tr>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;'><b>Item Code</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;'><b>Item Name</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;'><b>No. Of Orders</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;'><b>Quantity %</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;'><b>Quantity</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;'><b>Net Sales %</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;'><b>Net Sales</td>";
    $reportAnalytics .= "</tr>";

    foreach ($items as $itemID => $item) {

        $items[$itemID]['amount_percent'] = ($item['amount'] / $totals['amount']) * 100;
        $items[$itemID]['vat_percent'] = ($item['vat'] / $totals['vat']) * 100;
        $items[$itemID]['qty_percent'] = ($item['qty'] / $totals['qty']) * 100;
    }

    usort($items, function($a, $b) {
        return $b['amount'] - $a['amount'];
    });
    $total_qty_percent = 0;
    $total_amount_percent = 0;
    $totals['items'] = count($items);
    $averageBasketAmount = $totals['amount']/$totals['orders'];

    if(count($totals['orderIDs']) > 0){
        $orderItems = 0;
        foreach ($totals['orderIDs'] as $orderID) {
            $stm = $db->prepare("SELECT COUNT(DISTINCT(item_id)) FROM Order_Item WHERE order_id = ? ");
            $stm->bind_param('i',$orderID);
            $stm->execute();
            $stm->bind_result($orderItemsCounter);
            while ($stm->fetch()) {$orderItems += $orderItemsCounter;}
            $stm->close();
            $averageBasketItems = $orderItems/$totals['orders'];
        }

    }

    foreach ($items as $item) {

        $amount_percent = ($item['amount']/$totals['amount'])*100;
        $vat_percent = ($item['vat']/$totals['vat'])*100;
        $qty_percent = ($item['qty']/$totals['qty'])*100;

        $numberOfOrders = count($item['orders']);
        $numberOfCustomers = count($item['customers']);
        $numberOfSalespersons = count($item['salespersons']);

        $total_qty_percent += $qty_percent;
        $total_amount_percent += $amount_percent;

        if(round($amount_percent,2) < 0.01){$amount_percent = '< 0.01';} else {$amount_percent = number_format(round($amount_percent,2), 2);}
        if(round($vat_percent,2) < 0.01){$vat_percent = '< 0.01';} else {$vat_percent = number_format(round($vat_percent,2), 2);}
        if(round($qty_percent,2) < 0.01){$qty_percent = '< 0.01';} else {$qty_percent = number_format(round($qty_percent,2), 2);}

        $reportAnalytics .= "<tr style='border-bottom: 1px solid silver'>";
        $reportAnalytics .= "<td style='text-align: left !important;'  >" . $item['code'] . "</td>";
        $reportAnalytics .= "<td style='text-align: left !important;'  >" . $item['name'] . "</td>";
        $reportAnalytics .= "<td style='text-align: center !important;'><center>" . $numberOfOrders . "</td>";
        $reportAnalytics .= "<td style='text-align: center !important;'><center>" . $qty_percent . "%</td>";
        $reportAnalytics .= "<td style='text-align: center !important;'><center>" . number_format($item['qty']) . "</td>";
        $reportAnalytics .= "<td style='text-align: center !important;'><center>" . $amount_percent . "%</td>";
        $reportAnalytics .= "<td style='text-align: right !important;text-align: right ;' >" . number_format($item['amount'], 2) . "</td>";
        $reportAnalytics .= "</tr>";
    }
    $reportAnalytics .= "<tr>";

    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: left !important;'  >Totals:</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: center !important;' ></td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: center !important;'></td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: center !important;'><center>" . round($total_qty_percent,2) . "%</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: center !important;'><center>" . number_format($totals['qty']) . "</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: center !important;'><center>" . round($total_amount_percent,2) . "%</td>";
    $reportAnalytics .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: right !important;text-align: right ;' >" . number_format(round($totals['amount'],2), 2) . "</td>";
    $reportAnalytics .= "</tr>";
    $reportAnalytics .= "</table>";


    $reportTotals  = "<table class='table table-striped bordered' style='margin: 1px !important;width: 100%;'>";
    $reportTotals .= "<tr>";
    $reportTotals .= "<td style='background-color: #cadbf7 !important;'><center><b>No Of Items</td>";
    $reportTotals .= "<td style='background-color: #cadbf7 !important;'><center><b>No Of Orders</td>";
    $reportTotals .= "<td style='background-color: #cadbf7 !important;'><center><b>No Of Customers</td>";
    $reportTotals .= "<td style='background-color: #cadbf7 !important;'><center><b>Average Order Items</td>";
    $reportTotals .= "<td style='background-color: #cadbf7 !important;'><center><b>Average Order Amount</td>";
    $reportTotals .= "<td style='background-color: #cadbf7 !important;'><center><b>Total Net Sales</td>";
    $reportTotals .= "</tr>";
    $reportTotals .= "<tr>";
    $reportTotals .= "<td style='text-align: center !important;'><center>" . number_format($totals['items']) . "</td>";
    $reportTotals .= "<td style='text-align: center !important;'><center>" . number_format($totals['orders']) . "</td>";
    $reportTotals .= "<td style='text-align: center !important;'><center>" . number_format($totals['customers']) . "</td>";
    $reportTotals .= "<td style='text-align: center !important;'><center>" . number_format(round($averageBasketItems)) . "</td>";
    $reportTotals .= "<td style='text-align: center !important;'><center>" . number_format(round($averageBasketAmount,2),2) . "</td>";
    $reportTotals .= "<td style='text-align: center !important;'><center>" . number_format(round($totals['amount'],2),2) . "</td>";
    $reportTotals .= "</tr>";
    $reportTotals .= "</table>";


    $reportFilters = "<div style='width: 100%;background-color: rgba(192,192,192,0.4);font-weight: bold;padding: 5px;margin: 0px !important;'>Date Range: " . date_format(date_create_from_format('Y-m-d', $dateFrom), 'd-m-Y') . ' - ' . date_format(date_create_from_format('Y-m-d', $dateTo), 'd-m-Y') . "</div>";

    if(strcmp($orderPrefix,'')!=0){
        $reportFilters .= "<div style='width: 100%;background-color: rgba(192,192,192,0.4);font-weight: bold;padding: 5px;margin: 0px !important;'>Order Prefix: " . $orderPrefix . "</div>";

    }

    $report = $reportFilters;

    if($showSummary){
        $report .= $reportTotals;
    }
    if($showAnalytic){
        $report .= $reportAnalytics;
    }


}
if(strcmp($report,'')==0) {
    $report = "<center><b>No Data found </b></center>";
}



$report = "<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
           

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }
       

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>
    <htmlpageheader name='myHTMLHeader1'></htmlpageheader>

".$report;

echo $report;
return $report;

function getSalespersonDetails($salespersonID){
    $z = '';
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db1->set_charset("utf8");
    $stm21 = $db1->prepare(" SELECT CONCAT(first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID' LIMIT 1");
    $stm21->execute();
    $stm21->bind_result($value);
    while ($stm21->fetch()) {if(strcmp($value,'')!=0 && $salespersonID > 0){$z = $value;}}
    $stm21->close();

    return $z;

}

?>

