<?php
include_once("../../../../param.php");


$whereFilter   = "";

$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);
$customers  = $_POST['customers'];
$categories  = $_POST['categories'];
$salespersons  = $_POST['salespersons'];


if(strcmp($dateFrom,'')==0){
    $dateFrom = date('Y-m-d');
}

if(strcmp($dateTo,'')==0){
    $dateTo = date('Y-m-d');
}


$whereFilter .= " WHERE r.return_date BETWEEN '$dateFrom' AND '$dateTo'";
if(strcmp($customers,'')!=0){$whereFilter .= " AND r.customer_id IN ($customers)";}
if(strcmp($categories,'')!=0){$whereFilter .= " AND i.item_id IN (SELECT item_id FROM Category_Item WHERE category_id IN ($categories))";}
if(strcmp($salespersons,'')!=0){$whereFilter .= " AND r.salesperson_id IN ($salespersons)";}

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare(" SELECT ri.item_id,i.item_code,i.name,ri.status,SUM(ri.qty), c.customer_code, customer_company_name
                            FROM Returns as r
                            INNER JOIN Return_Item  AS ri ON r.return_id = ri.return_id
                            INNER JOIN Items as i ON ri.item_id = i.item_id
                            LEFT JOIN Customers AS c ON c.customer_id = r.customer_id
                            $whereFilter
                           GROUP BY ri.item_id, ri.status, i.item_code, i.name, c.customer_code, c.customer_company_name");
$stm->execute();
$stm->bind_result($itemID, $itemCode, $itemName, $status, $totalQty, $customerCode, $customerName);

while ($stm->fetch()) {
    $reasonObj = new stdClass();
    $reasonObj->itemID = $itemID;
    $reasonObj->itemCode = $itemCode;
    $reasonObj->itemName = $itemName;
    $reasonObj->status = $status;
    $reasonObj->totalQty = $totalQty;
    $reasonObj->customerCode = $customerCode;
    $reasonObj->customerName = $customerName;
    $reasonObjs[] = $reasonObj;
}

$stm->close();

$report = "";
if (count($reasonObjs) > 0) {
    $report .= "<h3 style='text-align: center;'>Returns with Reasoning Report</h3>";
    $report .= "<u>Date Range:</u> &nbsp;" . date_format(date_create_from_format('Y-m-d', $dateFrom), 'd/m/Y') . ' - ' . date_format(date_create_from_format('Y-m-d', $dateTo), 'd/m/Y') . "<br>";

    if (!empty($salespersons)) {
        $report .= "<u>Sales Persons:</u> &nbsp; " . getSalespersonsDetails($salespersons, $db) . "<br>";
    }
    if (!empty($customers)) {
        $report .= "<u>Customers:</u> &nbsp;" . getCustomersDetails($customers, $db) . "<br>";
    }
    if (!empty($categories)) {
        $report .= "<u>Categories:</u> &nbsp;" . getCategoriesName($categories, $db) . "<br>";
    }

    $report .= "<br>";

    $report .= "<table class='table bordered' style='margin-top: 5px !important;width: 100%;'>";
    $report .= "<tr>";
    $report .= "<th style='background-color: #cadbf7 !important;text-align:center;'>Customer Code</th>";
    $report .= "<th style='background-color: #cadbf7 !important;text-align:center;'>Customer Name</th>";
    $report .= "<th style='background-color: #cadbf7 !important;text-align:center;'>Item Code</th>";
    $report .= "<th style='background-color: #cadbf7 !important;text-align:center;'>Item Name</th>";
    $report .= "<th style='background-color: #cadbf7 !important;text-align:center;'>Quantity</th>";
    $report .= "<th style='background-color: #cadbf7 !important;text-align:center;'>Return Reason</th>";
    $report .= "</tr>";

    foreach ($reasonObjs as $reasonObj) {
        $report .= "<tr>";
        $report .= "<td>" . $reasonObj->customerCode . "</td>";
        $report .= "<td>" . $reasonObj->customerName . "</td>";
        $report .= "<td>" . $reasonObj->itemCode . "</td>";
        $report .= "<td>" . $reasonObj->itemName . "</td>";
        $report .= "<td>" . $reasonObj->totalQty . "</td>";
        $report .= "<td>" . $reasonObj->status . "</td>";
        $report .= "</tr>";
    }

    $report .= "</table>";
} else {
    $report = "<center><b>No Data found</b></center>";
}


if(strcmp($_POST['reportType'],'xls')!=0) {

    $report = "<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
           

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }
       

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>
    <htmlpageheader name='myHTMLHeader1'></htmlpageheader>

" . $report;
}
else{
    $report ="<htmlpageheader name='myHTMLHeader1'></htmlpageheader>" . $report;
}

echo $report;
return $report;

function getSalespersonsDetails($salespersonsID,$db){
    $salespersons = '';
    $stm = $db->prepare("SELECT CONCAT(salesperson_code,'-',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id IN ($salespersonsID)");
    $stm->execute();
    $stm->bind_result($details);
    while ($stm->fetch()) {
        $salespersons .=", ".$details;
    }
    $stm->close();

    return ltrim($salespersons, ', ');

}

function getCustomersDetails($customerIDs,$db){
    $customers = '';
    $stm = $db->prepare("SELECT CONCAT(customer_code,'-',customer_company_name) FROM Customers WHERE customer_id IN ($customerIDs) ");
    $stm->execute();
    $stm->bind_result($details);
    while ($stm->fetch()) {
        if(!empty($details)){
            $customers .=", ".$details;
        }
    }
    $stm->close();
    return ltrim($customers, ', ');
}

function getCategoriesName($categoryIDs,$db){
    $categories = '';
    $stm = $db->prepare("SELECT name FROM Categories WHERE category_id IN ($categoryIDs)");
    $stm->execute();
    $stm->bind_result($name);
    while ($stm->fetch()) {
        if(!empty($name)){
            $categories .=", ".$name;
        }
    }
    $stm->close();
    return ltrim($categories, ', ');

}
?>

