<?php
include_once("../../../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0) {
    $Allow_Customers = "AND Customers.customer_id IN(".$_SESSION['Allow_Customers'].")";
}

$stm = $db->prepare("SELECT CONCAT(customer_code, ' - ',customer_company_name), customer_id FROM Customers WHERE 1=1 $Allow_Customers");
$stm-> execute();
$stm-> bind_result($customerName, $customerID);
while ($stm->fetch()) {
    $customerSelection .= "<option value='$customerID'>$customerName</option>";
}

$stm-> close();

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Invoiced Items Report Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <label style="display: block"><b>Select Date Range:</b></label>
                                <input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 15%">
                                <input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 15%">
                                <label style="display: block; margin-top: 10px"><b>Select Customer:</b></label>
                                <select name="Customer" id="Customer" style="width: 30%;">
                                    <?php echo $customerSelection; ?>
                                </select><br/><br/>
                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export to PDF</button>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                            <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="xlsInputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="xlsInputTitle" value="InvoicedItems"/>
                                </form>

                                <form method="POST" action="//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php" name="pdfForm" id="pdfForm" >
                                    <input type="hidden" name="inputResult" id="pdfInputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="pdfInputTitle" value="InvoicedItems"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();
        $('#Customer').select2({ width: 'resolve' });

    });

    function getReport(){

        var Customer = $('#Customer').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateInvoicedItemsReportHTML.php',
            data: {
                'Customer':Customer,
                'dateFrom':dateFrom,
                'dateTo':dateTo

            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var Customer = $('#Customer').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateInvoicedItemsReportHTML.php',
            data: {
                'Customer':Customer,
                'dateFrom':dateFrom,
                'dateTo':dateTo

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#xlsInputResult').val(result);
                $('#xlsForm').submit();
            }
        });
    }

    function exportPDF(){

        var Customer    = $('#Customer').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateInvoicedItemsReportHTML.php',
            data: {
                'Customer':Customer,
                'dateFrom':dateFrom,
                'dateTo':dateTo

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#pdfInputResult').val(result);
                $('#pdfForm').submit();
            }
        });
    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "reports_list.php";
        }, 1000);


    }

</script>


