<?php
include_once("../../../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$salespersonSelection = "<option value='0'>- All Salespersons -</option>";
$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ', last_name), salesperson_id FROM SalesPersons WHERE salesperson_id > 0 $whereSP");
$stm-> execute();
$stm-> bind_result($salespersonName, $salespersonID);
while ($stm->fetch()) {
    $salespersonSelection .= "<option value='$salespersonID'>$salespersonName</option>";
}
$stm-> close();
?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Product Movement Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <label style="display: block"><b>Select Date Range:</b></label>
                                <input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 15%">
                                <input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 15%">
                                <label style="display: block; margin-top: 10px"><b>Select Item:</b></label>
                                <input type="text" name="productSearch" id="productSearch" class="form-control" style="width: 30%">
                                <label style="display: block; margin-top: 10px"><b>Filter Customer Group:</b></label>
                                <input type="text" name="customerGroupSearch" id="customerGroupSearch" class="form-control" style="width: 30%">
                                <label style="display: block; margin-top: 10px"><b>Select Sales Person:</b></label>
                                <select name="salesPerson" id="salesPerson" class="form-control" style="width: 30%">
                                    <?php echo $salespersonSelection; ?>
                                </select>
                                <label style="display: block; margin-top: 5px;"><b>Select Actions:</b></label>
                                <table style="width: 30%;margin-bottom: 30px;border: 1px solid lightgrey;">
                                    <tr>
                                        <td style="width:25%"><label style="display: block; margin-top: 5px;"><b>Warehouse</b></label></td>
                                        <td style="width:25%"><label style="display: block; margin-top: 5px;"><b>Purchases</b></label></td>
                                        <td style="width:25%"><label style="display: block; margin-top: 5px;"><b>Sales</b></label></td>
                                        <td style="width:25%"><label style="display: block; margin-top: 5px;"><b>Returns</b></label></td>
                                    </tr>
                                    <tr >
                                        <td style="width:25%"><input type="checkbox" class="form-control" id="incWarehouse"  value="yes"  ></td>
                                        <td style="width:25%"><input type="checkbox" class="form-control" id="incPurchases"   value="yes" ></td>
                                        <td style="width:25%"><input type="checkbox" class="form-control" id="incSales"       value="yes" ></td>
                                        <td style="width:25%"><input type="checkbox" class="form-control" id="incReturns"     value="yes" ></td>
                                    </tr>
                                    <tr ><td colspan="4">&nbsp;</td></tr>
                                </table>

                                <br><br>
                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export PDF</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Product Movement Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                            <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="orientation" id="orientation" value="landscape"/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="SingleProductSalesPurchases"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {
        $('#salesPerson').select2();
        pageSetUp();

        $("#productSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/productSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#customerGroupSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerGroupSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

    });

    function getReport(){

        var productSearch = $('#productSearch').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var customerGroupSearch = $('#customerGroupSearch').val();

        var incWarehouse = $('#incWarehouse:checked').val();
        var incPurchases  =$('#incPurchases:checked').val();
        var incSales  =$('#incSales:checked').val();
        var incReturns  =$('#incReturns:checked').val();

        var salesPerson     = $('#salesPerson').val();
        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSingleProductSalesPurchasesReport.php',
            data: {
                'customerGroupSearch':customerGroupSearch,
                'productSearch':productSearch,
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'incWarehouse':incWarehouse,
                'incPurchases':incPurchases,
                'incSales':incSales,
                'incReturns':incReturns,
                'salesPerson':salesPerson
            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var productSearch = $('#productSearch').val();
        var customerGroupSearch = $('#customerGroupSearch').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var incWarehouse = $('#incWarehouse:checked').val();
        var incPurchases  =$('#incPurchases:checked').val();
        var incSales  =$('#incSales:checked').val();
        var incReturns  =$('#incReturns:checked').val();
        var salesPerson     = $('#salesPerson').val();
        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSingleProductSalesPurchasesReport.php',
            data: {
                'productSearch':productSearch,
                'customerGroupSearch':customerGroupSearch,
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'incWarehouse':incWarehouse,
                'incPurchases':incPurchases,
                'incSales':incSales,
                'incReturns':incReturns,
                'salesPerson':salesPerson

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });


    }

    function exportPDF(){

        var productSearch = $('#productSearch').val();
        var customerGroupSearch = $('#customerGroupSearch').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();

        var incWarehouse = $('#incWarehouse:checked').val();
        var incPurchases  =$('#incPurchases:checked').val();
        var incSales  =$('#incSales:checked').val();
        var incReturns  =$('#incReturns:checked').val();
        var salesPerson     = $('#salesPerson').val();
        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSingleProductSalesPurchasesReport.php',
            data: {
                'productSearch':productSearch,
                'customerGroupSearch':customerGroupSearch,
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'incWarehouse':incWarehouse,
                'incPurchases':incPurchases,
                'incSales':incSales,
                'incReturns':incReturns,
                'salesPerson':salesPerson
            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php').submit();
            }
        });


    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "reports_list.php";
        }, 1000);


    }

</script>


