<?php
include_once("../../../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Order Items Per Supplier
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Supplier Item Report Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body col-xs-12 col-sm-12 col-md-12 col-lg-7" >
                                <table style="width: 100%;">
                                    <tr>
                                        <td colspan="2"><label style="display: block; margin-top: 10px"><b>Select Date Range:</b></label></td>
                                        <td><label style="display: block; margin-top: 10px"><b>Select Supplier(s):</b></label></td>
                                    </tr>
                                    <tr>
                                        <td style="width: 20%;"><input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 95%" value="<?php echo date('Y-m-d')?>" ></td>
                                        <td style="width: 20%;"><input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 95%" value="<?php echo date('Y-m-d')?>"></td>
                                        <td><select name="supplier[]" id="supplier" class="form-control" style="width: 90%" multiple="multiple" >
                                                <?php
                                                    $stm = $db->prepare("SELECT CONCAT(customer_code, ' - ',customer_company_name), customer_id FROM Suppliers ");
                                                    $stm-> execute();
                                                    $stm-> bind_result($supplierName, $supplierID);
                                                    while ($stm->fetch()) {
                                                        echo "<option value='$supplierID'>$supplierName</option>";
                                                    }
                                                    $stm->close();
                                                ?>
                                            </select></td>
                                    </tr>
                                </table>




                                <br><br><br>
                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="orientation" id="orientation" value="landscape"/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="SupplierItemStockTaking"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<style>
    table {
        width:100%;
        border-collapse: collapse;
    }
    td{
        border: 1px solid black;
        padding: 4px;
        vertical-align: middle !important;
        padding:10px !important;
    }
</style>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();
        $('#supplier').select2();


    });

    function getReport(){

        var supplier = $('#supplier').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var typeReport  = 'simple';
        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSupplierOrderReport.php',
            data: {
                'supplier':supplier,
                'dateFrom':dateFrom,
                'dateTo':dateTo
            },
            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }
    function exportXLS(){
        var supplier    = $('#supplier').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var typeReport  = 'excel';
        $('#reportResult').html('<center><b>Generating Report..</b></center>');
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSupplierOrderReport.php',
            data: {
                'supplier':supplier,
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'typeReport':typeReport

            },
            success: function (result) {
                var linkSource = 'data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64,'+ result ;
                var downloadLink = document.createElement("a");
                var fileName = 'SupplierOrderReport.xlsx';

                downloadLink.href = linkSource;
                downloadLink.download = fileName;
                downloadLink.click();
                $('#reportResult').html("<center><h2 style='color:green;'>Success!!</h2></center>");
            }
        });

    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "reports_list.php";
        }, 1000);


    }

</script>


