<?php
include_once("../../../../param.php");

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'B2B_Brands';

// Table's primary key
$primaryKey = "brand_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`s`.`brand_image_url`', 'dt' => 'image', 'formatter' => function ($d, $row) {
        if (!isset($d) || $d == '') {
            $d = "noImage.png";
        }
        return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/b2b/assets/brandslider/'. $d .'" width="45" height="45"></td>';
    }, 'field' => 'brand_image_url'),
    array('db' => '`s`.`brand_code`',      'dt' => 'code',      'field' => 'brand_code'),
    array('db' => '`s`.`brand_name`',      'dt' => 'title',     'field' => 'brand_name'),
    array('db' => '`s`.`position`',        'dt' => 'position',  'field' => 'position'),
    array('db' => '`s`.`slider_number`',    'dt' => 'number',  'field' => 'slider_number'),
    array('db' => '`s`.`slider_position`',        'dt' => 'slider_position',  'field' => 'slider_position'),
    array('db' => '`s`.`brand_link_url`',  'dt' => 'link',      'formatter' => function( $d, $row ) {
        return '<a href="'.$d.'" target="_blank">'.$d.'<a>';}, 'field' => 'brand_link_url'),

    array('db' => '`s`.`timestamp`',            'dt' => 'time',      'field' => 'timestamp'),
    array('db' => '`s`.`brand_id`', 'dt' => 'form', 'formatter' => function( $d ) {


        return '<form id="'.$d.'"action="edit_brand.php" method="post" target="_blank">
           		<input type="hidden" name="brand_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit" style="width:60px">
			</form>';},
        'field' => 'brand_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `B2B_Brands` AS `s` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

