<?php

include_once("../../../../param.php");
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'B2B_Featured_Slider';

// Table's primary key
$primaryKey = "featured_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`s`.`featured_image_url`', 'dt' => 'image', 'formatter' => function ($d, $row) {
        if (!isset($d) || $d == '') {
            $d = "noImage.png";
        }
        return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/b2b/assets/featuredslider/'. $d .'" width="45" height="45"></td>';
    }, 'field' => 'featured_image_url'),
    array('db' => '`s`.`featured_code`',        'dt' => 'code',      'field' => 'featured_code'),
    array('db' => '`s`.`featured_title`',       'dt' => 'title',     'field' => 'featured_title'),
    array('db' => '`s`.`featured_text`',        'dt' => 'text',      'field' => 'featured_text'),
    array('db' => '`s`.`position`',             'dt' => 'position',  'field' => 'position'),
    array('db' => '`s`.`active`',               'dt' => 'active',    'field' => 'active'),
    array('db' => '`s`.`slider_number`',               'dt' => 'slider',    'field' => 'slider_number'),
    array('db' => '`s`.`featured_width`',               'dt' => 'width',    'field' => 'featured_width'),
    array('db' => '`s`.`featured_height`',               'dt' => 'height',    'field' => 'featured_height'),
    array('db' => '`s`.`featured_link_url`',    'dt' => 'link',  'formatter' => function( $d, $row ) {
        return '<a href="'.$d.'" target="_blank">'.$d.'<a>';},       'field' => 'featured_link_url'),

    array('db' => '`s`.`timestamp`',            'dt' => 'time',      'field' => 'timestamp'),
    array('db' => '`s`.`featured_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

        require("dbinfo.php");
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT active FROM B2B_Featured_Slider WHERE featured_id='$d'");
        $stm->execute();
        $stm->bind_result($check);

        while ($stm->fetch()) {}
        $stm->close();

        if($check == "yes") {
            $button = '<button type="button"  id="b'.$d.'" class="btn btn-danger" onclick="deactivateButtonClicked('.$d.');" style="width:55px; display: inline;">Hide</button>';
        } else {
            $button = '<button type="button" id="b'.$d.'"  class="btn btn-success" onclick="activateButtonClicked('.$d.');"  style="width:55px; display: inline;">Show</button>';
        }
        return '<form id="'.$d.'"action="edit_slider.php" method="post" target="_blank">
           		<input type="hidden" name="featured_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit" style="width:60px display: inline;">
			'.$button.'
			</form>';},
        'field' => 'featured_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `B2B_Featured_Slider` AS `s` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

