<?php
require("./concc/dbinfo.php");
include_once("./concc/dbhelper.php");
include_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
$dbHelperItem= new DBItem();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$tableColumns=array();
$tableRows = array();
$tablePrices=array();

if(isset($_GET['c']) && $_GET['c']> 0){
    $customerID = trim($_GET['c']);
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT CONCAT(customer_code,' - ',customer_company_name) FROM Customers WHERE customer_id='$customerID'");
    $stm-> execute();
    $stm-> bind_result($customerName);
    while ($stm->fetch()) {}
    $stm->close();
    $allCustomers = false;
} else {
    $customerID = 1;
    $customerName = '';
    $allCustomers = true;
}


$db->set_charset("utf8");
$stm = $db->prepare("SELECT delivery_range_id, customer_id, item_id, from_kg, to_kg, from_volume, to_volume, from_km, to_km,notes FROM  B2B_Dropship_Delivery_Fee_Ranges WHERE customer_id='$customerID'");
$stm-> execute();
$stm-> bind_result($delivery_range_id, $customer_id, $item_id, $from_kg, $to_kg, $from_volume, $to_volume, $from_km, $to_km,$notes);
while ($stm->fetch()) {


    $column= new stdClass();
    $column->id=$delivery_range_id;
    $column->fromKG=$from_kg;
    $column->toKG=$to_kg;
    $column->fromV=$from_volume;
    $column->toV=$to_volume;


    array_push($tableColumns,$column);




}
$stm->close();

$stm = $db->prepare("SELECT delivery_range_id, customer_id, item_id, from_kg, to_kg, from_volume, to_volume, from_km, to_km,notes FROM  B2B_Dropship_Delivery_Fee_Ranges WHERE customer_id='$customerID' GROUP BY to_km");
$stm-> execute();
$stm-> bind_result($delivery_range_id, $customer_id, $item_id, $from_kg, $to_kg, $from_volume, $to_volume, $from_km, $to_km,$notes);
while ($stm->fetch()) {

    $row= new stdClass();
    $row->id=$delivery_range_id;
    $row->from=$from_km;
    $row->to=$to_km;


    array_push($tableRows,$row);


}
$stm->close();

function getItemFromRange($fromD,$toD,$fromKG,$toKG,$toV,$fromV,$customerID,$dbHelperItem){
    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm2 = $db2->prepare("SELECT item_id FROM  B2B_Dropship_Delivery_Fee_Ranges WHERE from_kg='$fromKG' AND to_kg='$toKG' AND from_volume='$fromV' AND to_volume='$toV' AND from_km='$fromD' AND to_km='$toD'");
    $stm2-> execute();
    $stm2-> bind_result($itemID);
    while ($stm2->fetch()) {}
    $stm2->close();

    $price = getDefaultPrice($itemID,$customerID);
    $item = $dbHelperItem->getItemByID($itemID);

    $res = new stdClass();
    $res->itemCode=$item->itemCode." - ".$item->name;
    $res->itemID=$itemID;
    $res->itemPrice=$price;

    return $res;
}



?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Dropship Delivery Fees</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-6">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <img class="custom-rounded-image-padding order" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/ordericon.png" width="30" height="30">
                    Dropship Delivery Fees (<?php if(strcmp($customerName,'')==0){echo 'All Customers';} else{echo $customerName;} ?>)
                </h3>
            </div>



            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <input style='display:inline;font-weight: bolder' class='text-center form-control' id='customerSearch' name='customerSearch'  onclick="document.getElementById('customerSearch').value = ''" type='text' value='<?php echo $customerName ?>' placeholder="Select Customer">
                <input type="hidden" id="customerID" name="customerID" value="<?php echo $customerID ?>"/>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <?php
                if(!$allCustomers){
                    echo '<button id="resetButton" onclick="window.location.replace(\'//'. HTML_PATH .'/cop/backend/modules/b2bAdmin/dropship_delivery_fees.php\');" class="btn btn-warning btn-block"><i class="fa fa-filter"></i>&nbsp; All Customers</button>';
                }
                ?>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		        <span class="pull-right show-stat-buttons">
                    <span>
                        <button id="saveButton" onclick="saveFees();" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; Save Fees</button>
                    </span>
                </span>
            </div>




        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <div class="row" >

                <!-- NEW WIDGET START -->
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div style="margin-bottom:10px;" class="jarviswidget jarviswidget-color-blueDark" id="wid-id-5" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Dropship Delivery Fees Table</h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">


                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">

                                    <thead>



                                    <tr>
                                        <th class='text-center' style="border-color:#4682B4;"></th>
                                        <?php
                                        $prevFKG = $prevTKG = $prevFV = $prevTV = '';
                                        foreach ($tableColumns as $column){

                                            if($prevFKG != $column->fromKG || $prevTKG != $column->toKG || $prevFV != $column->fromV || $prevTV != $column->toV) {

                                                echo "<th class='text-center'>";

                                                echo "<label  style='margin: 15px !important;text-align: center;display: inline!important;width: 20%!important;font-weight: bolder'>Weight From / To</label>";
                                                echo "<label  style='margin: 15px !important;text-align: center;display: inline!important;width: 59%!important;font-weight: bolder'> |</label>";
                                                echo "<label  style='margin: 15px !important;text-align: center;display: inline!important;width: 20%!important;font-weight: bolder'>Volume From / To</label>";
                                                echo "<br>";
                                                echo "<input value='$column->fromKG' type='number' class='form-control' id='fromWeight' style='margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;' placeholder='From Weight'>";
                                                echo "<input value='$column->toKG' type='number' class='form-control' id='toWeight' style='margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;' placeholder='To Weight'>";
                                                echo "<span class='form-control' style='margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;background-color: white'>&nbsp;</span>";
                                                echo "<input value='$column->fromV' type='number' class='form-control' id='fromVolume' style='margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;' placeholder='From Volume'>";
                                                echo "<input value='$column->toV' type='number' class='form-control' id='toVolume' style='margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;' placeholder='To Volume'>";

                                                echo "</th>";
                                            }

                                            $prevFKG = $column->fromKG;
                                            $prevTKG = $column->toKG;
                                            $prevFV = $column->fromV;
                                            $prevTV = $column->toV;
                                        }

                                        ?>
                                        <th class='text-center'>

                                            <label  style='margin: 15px !important;text-align: center;display: inline!important;width: 20%!important;font-weight: bolder'>Weight From / To</label>
                                            <label  style='margin: 15px !important;text-align: center;display: inline!important;width: 59%!important;font-weight: bolder'> |</label>
                                            <label  style='margin: 15px !important;text-align: center;display: inline!important;width: 20%!important;font-weight: bolder'>Volume From / To</label>
                                            <br>
                                            <input type="number" class="form-control" id='fromWeight' style="margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;" placeholder="From Weight">

                                            <input type="number" class="form-control" id='toWeight' style="margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;" placeholder="To Weight">

                                            <span class="form-control" style="margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;background-color: white">&nbsp;</span>

                                            <input type="number" class="form-control" id='fromVolume' style="margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;" placeholder="From Volume">

                                            <input type="number" class="form-control" id='toVolume' style="margin-bottom: 5px !important;text-align: center;display: inline!important;width: 20%!important;" placeholder="To Volume">

                                        </th>


                                    </tr>
                                    </thead>

                                    <tbody>
                                    <?php

                                    foreach ($tableRows as $row){

                                        echo "<tr>";
                                        echo "<td  style='border-color:#4682B4;background-color: #4682B4;color: white;font-family: arial, sans-serif;border-right: 5px solid #4682B4;border-bottom: 5px solid #4682B4;'>";
                                        echo "<label style='margin: 15px !important;text-align: center;display: inline!important;width: 20%!important;font-weight: bolder'>Distance</label>";
                                        echo "<input value='$row->from' type='number' class='form-control' id='fromDistance' style='margin-bottom: 5px !important;text-align: center;' placeholder='From Distance'>";
                                        echo "<input value='$row->to' type='number' class='form-control' id='toDistance' style='margin-bottom: 5px !important;text-align: center;' placeholder='To Distance'>";
                                        echo "<input value='' type='number' class='form-control' id='extra' style='margin-bottom: 5px !important;text-align: center;display: none;' placeholder=''>";

                                        $prevFKG = $prevTKG = $prevFV = $prevTV = '';

                                        foreach ($tableColumns as $column) {



                                            if($prevFKG != $column->fromKG || $prevTKG != $column->toKG || $prevFV != $column->fromV || $prevTV != $column->toV) {

                                                $item=getItemFromRange($row->from,$row->to,$column->fromKG,$column->toKG,$column->toV,$column->fromV,$customerID,$dbHelperItem);

                                                echo "<td class='text-center'  style='border-right: 5px solid #4682B4;border-bottom: 5px solid #4682B4;'>";
                                                echo "<input value='$item->itemCode'  type='text'   class='form-control itemCode' id='itemCode' style='margin-bottom: 5px !important;text-align: center;' placeholder='Item'>";
                                                echo "<input value='$item->itemID'    type='number' class='form-control' id='itemID' style='display:none;margin-bottom: 5px !important;text-align: center;' placeholder='Item ID'>";
                                                echo "<input value='$item->itemPrice' type='number' class='form-control' id='contractPrice' style='margin-bottom: 5px !important;text-align: center;' placeholder='Price'>";
                                                echo "</td>";

                                            }
                                            $prevFKG = $column->fromKG;
                                            $prevTKG = $column->toKG;
                                            $prevFV = $column->fromV;
                                            $prevTV = $column->toV;
                                        }
                                        echo "<td class='text-center'  style='border-right: 5px solid #4682B4;border-bottom: 5px solid #4682B4;'>";
                                        echo "<input  type='text'   class='form-control itemCode' id='itemCode' style='margin-bottom: 5px !important;text-align: center;' placeholder='Item'>";
                                        echo "<input  type='number' class='form-control' id='itemID' style='display:none;margin-bottom: 5px !important;text-align: center;' placeholder='Item ID'>";
                                        echo "<input  type='number' class='form-control' id='contractPrice' style='margin-bottom: 5px !important;text-align: center;' placeholder='Price'>";
                                        echo "</td>";
                                        echo "</tr>";
                                    }

                                    ?>
                                    <tr>
                                        <td  style="border-color:#4682B4;background-color: #4682B4;color: white;font-family: arial, sans-serif;border-right: 5px solid #4682B4;border-bottom: 5px solid #4682B4;">
                                            <label style='margin: 15px !important;text-align: center;display: inline!important;width: 20%!important;font-weight: bolder'>Distance</label>
                                            <input type="number" class="form-control" id='fromDistance' style="margin-bottom: 5px !important;text-align: center;" placeholder="From Distance">
                                            <input type="number" class="form-control" id='toDistance' style="margin-bottom: 5px !important;text-align: center;" placeholder="To Distance">
                                            <input value='' type='number' class='form-control' id='extra' style='margin-bottom: 5px !important;text-align: center;display: none;' placeholder=''>

                                        </td>

                                        <?php

                                        $prevFKG = $prevTKG = $prevFV = $prevTV = '';
                                        foreach ($tableColumns as $column) {

                                            if($prevFKG != $column->fromKG || $prevTKG != $column->toKG || $prevFV != $column->fromV || $prevTV != $column->toV) {
                                                echo "<td class='text-center'  style='border-right: 5px solid #4682B4;border-bottom: 5px solid #4682B4;'>";
                                                echo "<input  type='text' class='form-control itemCode' id='itemCode' style='margin-bottom: 5px !important;text-align: center;' placeholder='Item'>";
                                                echo "<input  type='number' class='form-control' id='itemID' style='display:none;margin-bottom: 5px !important;text-align: center;' placeholder='Item ID'>";
                                                echo "<input  type='number' class='form-control' id='contractPrice' style='margin-bottom: 5px !important;text-align: center;' placeholder='Price'>";
                                                echo "</td>";
                                            }
                                            $prevFKG = $column->fromKG;
                                            $prevTKG = $column->toKG;
                                            $prevFV = $column->fromV;
                                            $prevTV = $column->toV;
                                        }
                                        ?>

                                        <td class='text-center'  style="border-right: 5px solid #4682B4;border-bottom: 5px solid #4682B4;">
                                            <input type="text" class="form-control itemCode" id='itemCode' style="margin-bottom: 5px !important;text-align: center;" placeholder="Item">
                                            <input type='number' class='form-control' id='itemID' style='display:none;margin-bottom: 5px !important;text-align: center;' placeholder='Item ID'>
                                            <input type="number" class="form-control" id='contractPrice' style="margin-bottom: 5px !important;text-align: center;" placeholder="Price">
                                        </td>



                                    </tr>

                                    </tbody>

                                </table>

                                <div id="testDiv"></div>


                                <div class="row" style="margin-top:4px;margin-right:3px;">
                                    <div class="col-sm-12">

                                        <div class="col-sm-12" style="margin-top:8px;margin-bottom: 20px;">
									        <span class="col-sm-2" >
                                                <a target="_blank" id="newLineButton" class="btn btn-primary btn-block" onclick="addNewLine()">
                                                <i class="fa fa-plus  ">
                                                </i>&nbsp; Add Line</a>
										    </span>
                                            <span class="col-sm-2 pull-right" >
											    <a target="_blank" id="newRowButton" class="btn btn-primary btn-block" onclick="addNewRow()">
												<i class="fa fa-plus  ">
												</i>&nbsp; Add Row</a>
										    </span>
                                        </div>




                                    </div>

                                </div>


                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
            </div>

            <!-- end row -->



        </section>
    </div>
</div>

<style>

    td input {
        width:100%;
    }

    table#datatable_fixed_column tr td img { display:none;}
    table#datatable_fixed_column tr:hover td img { display:inline-block;}

    table#datatable_fixed_column {
        border: solid 1px #407bad;
    }

    table#datatable_fixed_column thead  {
        border: solid 1px #407bad;
    }

    table#datatable_fixed_column thead th {
        background-color: #4682B4;
        color: white;
        font-family: arial, sans-serif;
    }

    .form-control {
        font-family: arial, sans-serif;
        border-radius: 4px !important;
        color: #000;
        font-weight:400;
        margin: 0px;
        padding: 0px;
    }

    table#datatable_fixed_column tr td {
        padding-left:4px;
        padding-right:4px;
    }

    td.index {
        font-weight:bold;
    }

    .form-control:disabled {
        background-color: #fcfcfc;
    }



    .slim-input {
        height:22px;
        margin-left:8px;
        font-family: Calibri;
    }

    .small-margin {
        margin-bottom: 5px !important;
    }

    #detailsTable thead th {
        background-color: white !important;
        border:none;
        height:0px;
    }

    .align-left {
        text-align: left;
    }

    .popover {
        position: absolute;
        top: 0;
        left: 0;
        z-index: 1010;
        display: none;
        max-width: 600px;
        padding: 1px;
        text-align: left;
        white-space: normal;
        background-color: #ffffff;
        border: 1px solid #ccc;
        border: 1px solid rgba(0, 0, 0, 0.2);
        -webkit-border-radius: 6px;
        -moz-border-radius: 6px;
        border-radius: 6px;
        -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        -webkit-background-clip: padding-box;
        -moz-background-clip: padding;
        background-clip: padding-box;
    }

</style>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script type="text/javascript">


    function initAutocomplete()
    {
        $(".itemCode").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/invoice_autocomplete.php",
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', 'auto');
            },
            select: function (event, ui) {

                var $itemRow = $(this).closest('td');

                // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                $itemRow.find('#itemID').val(ui.item.item_id); // Hidden input on form
                $itemRow.find('#itemCode').val(ui.item.item_code);
                $itemRow.find('#contractPrice').val(ui.item.price);


                var customerID= $('#customerID').val();
                var itemID = ui.item.item_id;
                $.ajax({
                    type: "POST",
                    url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemPrices.php',
                    data: {
                        'customerID':customerID,
                        'itemID':itemID
                    },
                    dataType:"json",

                    success: function (result) {


                        $itemRow.find('#contractPrice').val(newPrice);


                    }
                });

                return false;
            }
        });
    }

    function initCustomerCodeAutocomplete()
    {
        $("#customerSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
            autoFocus: true,
            select: function (event, ui) {

                window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/modules/b2bAdmin/dropship_delivery_fees.php?c="+ui.item.customer_id);


                return true;
            }
        });
    }

    function saveFees(){

        var customerID = $('#customerID').val();
        var fees=[];
        $('#datatable_fixed_column tr').each(function(i){
            var tb=$(this);
            var obj={};
            tb.find('input').each(function(j){
                obj[this.id+'-'+i+'-'+j]=this.value;
            });
            obj['row']=i;
            fees.push(obj);
        });

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/b2bAdmin/concc/add_dropship_delivery_fees.php',
            data: {
                'fees': fees,
                'customerID': customerID
            },
            success: function (result) {


                $('#testDiv').html(result);

                $.smallBox({
                    title: "Success!",
                    content: "Fee Range successfully entered",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                location.reload();
            }

        });

    }

    function addNewLine()
    {
        $lastTr = $('tr:last', $('#datatable_fixed_column'));
        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $newTr.find("input").val("");
        $newTr.find("textarea").text("");
        $newTr.find("label").text("");
        $i = $newTr.find("td.index").text();
        $i++;
        $newTr.find("td.index").text($i);

        $newTr.find('#itemDetails').prop( "disabled", true );
        $newTr.find('#unitPrice').prop( "disabled", true );
        $newTr.find('#priceCode').prop( "disabled", true );
        $newTr.find('#lineDiscount').prop( "disabled", true );
        $newTr.find('#qty').prop( "disabled", true );
        $newTr.find('#lineTotal').prop( "disabled", true );
        $newTr.find('#qtyUnits').prop( "disabled", true );
        $newTr.find('#qtySubunits').prop( "disabled", true );
        $newTr.find('#orderItemNotes').prop( "disabled", true );


        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });

        initAutocomplete();

    }

    function addNewRow(){
         $("#datatable_fixed_column tr > :last-child").each(function () { var $this = $(this); $this.clone().appendTo($this.parent()); });
        initAutocomplete();
    }


    $(document).ready(function() {

        pageSetUp();
        initCustomerCodeAutocomplete();
        initAutocomplete();



    });

</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
