<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("login.php");
}


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

if(isset($_POST['dailyTimeSlotID'])){

    $isEdit                 = true;
    $dailyTimeSlotID        = $_POST['dailyTimeSlotID'];
    $pageStatus             = 'Edit';
    $postURL                = 'edit_daily_time_slots_post.php';

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT daily_slots_id,day,zip_code_id,time_slots,next_day_delivery_after_time,disable_slot_hours_before,next_day_only_time_slots,enable_timeslots,enable_delivery_approval FROM ZZ_Daily_Time_Slots WHERE daily_slots_id='$dailyTimeSlotID'");
    $stm-> execute();
    $stm-> bind_result($dailyTimeSlotID,$dayDB,$zipCodeID,$timeSlots,$nextDayAfter,$disableSlotsBefore,$nextDaySlots,$enableTimeslots,$enableDeliveryApproval);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($enableTimeslots,'yes')==0){
        $selectedYesTimeslots = 'selected';
    } else {
        $selectedNoTimeslots = 'selected';
    }

    if(strcmp($enableDeliveryApproval,'yes')==0){
        $selectedYesDeliveryApproval = 'selected';
    } else {
        $selectedNoDeliveryApproval = 'selected';
    }




} else {
    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_daily_time_slots_post.php';
    $date        = date('Y-m-d',strtotime(date('Y-m-d') . "-1 days"));
    $nextDayAfter= '23:59';
}

$arrayOfDays = array("1"=>'Monday', "2"=>'Tuesday', "3"=>'Wednesday', "4"=>'Thursday', "5"=>'Friday', "6"=>'Saturday',"0"=>'Sunday');
?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> <?php echo $pageStatus?> Daily Time Slots</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Daily Time Slots</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">
                                            <section>
                                                <section class="col-sm-11">
                                                    <label class="label-bold align-left">Select Day : </label>
                                                    <select class='form-control' id='dateSelection'>
                                                        <?php
                                                        foreach ($arrayOfDays as $key=>$day){
                                                            if ($dayDB==$key){
                                                                echo "<option value='$key' selected>$day</option>";
                                                            }else{
                                                                echo "<option value='$key'>$day</option>";
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </section>
                                            <section class="col-sm-11">
                                                <section>
                                                    <label class="label-bold align-left">Select Area: </label>
                                                    <?php
                                                    echo "<select id='zipCodesID' name='zipCodesID' class='form-control'>";
                                                    echo "<option value='0' selected></option>";
                                                    global $username,$password,$database;
                                                    $db = new mysqli('localhost',$username,$password,$database);
                                                    if (mysqli_connect_errno()) {
                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                        exit();
                                                    }
                                                    $db->set_charset("utf8");
                                                    $stm = $db->prepare("SELECT zip_code_id,zip_code_region FROM ZZ_Zip_Codes WHERE 1=1");
                                                    $stm-> execute();
                                                    $stm-> bind_result($areaOptionID,$areaOptionName);
                                                    while ($stm->fetch()) {

                                                        if($areaOptionID == $zipCodeID){
                                                            echo "<option value='$areaOptionID' selected>$areaOptionName</option>";
                                                        } else {
                                                            echo "<option value='$areaOptionID' >$areaOptionName</option>";

                                                        }

                                                    }
                                                    $stm-> close();

                                                    echo "</select>";

                                                    ?>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Time Slots : </label>
                                                    <input type="text" class="form-control"  id="timeSlots" value="<?php echo $timeSlots?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Next Day Delivery After Time: </label>
                                                    <input type="time" class="form-control"  id="hours"  value="<?php echo $nextDayAfter;?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Minutes Before Disable Each Slot : </label>
                                                    <input type="number" class="form-control"  id="nextDayAfterTime"  min="0" value="<?php echo $disableSlotsBefore;?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Following Day(s) Only Time Slots : </label>
                                                    <input type="text" class="form-control"  id="nextDaySlots" value="<?php echo $nextDaySlots?>"/>
                                                </section>
                                                <section>
                                                    <table style="width: 100%;" class="table table-bordered">
                                                        <tr>
                                                            <td style="width: 50%;">
                                                                <center>
                                                                    <label class="label-bold align-left">Enable Area Time Slots: </label>
                                                                    <select class="form-control text-center" id="enableTimesSlots" style="width: 150px;">
                                                                        <option value="yes" <?php echo $selectedYesTimeslots?>>Yes</option>
                                                                        <option value="no" <?php echo $selectedNoTimeslots?>>No</option>
                                                                    </select>
                                                                </center>
                                                            </td>
                                                            <td style="display: none;">
                                                                <center>
                                                                    <label class="label-bold align-left">Enable Instant Delivery: </label>
                                                                    <select class="form-control text-center" id="enableDeliveryApproval"  style="width: 150px;">
                                                                        <option value="no" <?php echo $selectedNoDeliveryApproval?>>No</option>
                                                                        <option value="yes" <?php echo $selectedYesDeliveryApproval?>>Yes</option>
                                                                    </select>
                                                                </center>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                                <section>
                                                    <input type="hidden" class="form-control" id="dailyTimeSlotID" value="<?php echo $dailyTimeSlotID?>"/>
                                                </section>


                                            </section>

                                        </div>
                                    </fieldset>
                                </form>


                                <footer>
                                    <?php if($isEdit){echo '<input type="button" id="PostDelete" class="btn btn-danger pull-left"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Delete Daily Slots" onclick="deletePage()">';}?>
                                    <input type="button" id="PostSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Save Daily Slots" onclick="savePost()">
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">



    function deletePage(){
        var dailyTimeSlotID       = $('#dailyTimeSlotID').val();

        if(dailyTimeSlotID > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_daily_time_slot.php',
                dataType: 'html',
                data: {
                    'dailyTimeSlotID': dailyTimeSlotID
                },
                success: function (result) {
                    $('#pageName').val('');
                    $('#pageName').trigger('change');
                    $('#position').val('');
                    $('#position').trigger('change');
                    $.smallBox({
                        title: 'Page Deleted!',
                        content: "Post successfully entered",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.close();}, 1000);
                }
            });
        }

    }

    function savePost() {
        var dayTimeSlot             = $('#dateSelection').val(); //day
        var dailyTimeSlotID         = $('#dailyTimeSlotID').val(); //id table if exits
        var zipCodesID              = $('#zipCodesID').val(); //city
        var timeSlots               = $('#timeSlots').val(); // time slots
        var hours                   = $('#hours').val(); //minutes before disable
        var nextDayAfterTime        = $('#nextDayAfterTime').val(); //next delivery after time
        var nextDaySlots            = $('#nextDaySlots').val(); //Following Day(s) Only Time Slots
        var enableTimesSlots        = $('#enableTimesSlots').val(); //Enable Area Time Slots
        var enableDeliveryApproval  = $('#enableDeliveryApproval').val(); //Enable Instant Delivery
        console.log(nextDayAfterTime);
        if(zipCodesID > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/<?php echo $postURL?>',
                dataType: 'html',
                data: {
                    'dayTimeSlot': dayTimeSlot,
                    'dailyTimeSlotID': dailyTimeSlotID,
                    'zipCodesID': zipCodesID,
                    'timeSlots': timeSlots,
                    'hours': hours,
                    'nextDayAfterTime': nextDayAfterTime,
                    'nextDaySlots': nextDaySlots,
                    'enableTimesSlots': enableTimesSlots,
                    'enableDeliveryApproval': enableDeliveryApproval
                },
                success: function (result) {
                    var obj = jQuery.parseJSON(result);
                    if (obj.code<0){
                        $.smallBox({
                            title: 'Error',
                            content: obj.msg,
                            color: "#B22222",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                    }else{
                        $.smallBox({
                            title: 'Success!',
                            content: "Daily Slots successfully entered",
                            color: "#739E73",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                        setTimeout(location.reload(), 1000);
                    }
                }
            });
        } else {
            $.smallBox({
                title: 'Incomplete Data!',
                content: "Please Select Area",
                color: "firebrick",
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });

        }
    }

    // End of SavePost()

    $(document).ready(function() {

        pageSetUp();

    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



?>