<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
require("./concc/dbhelper.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class='txt-color-white'>Home / B2B Filters / Url Generator</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <article id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B Filter URLs
                </h3>
            </div>

        </div>

        <!-- NEW WIDGET START -->
        <section id="widget-grid" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <!-- row -->
            <div class="row">

                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-154" data-widget-editbutton="false" data-widget-deletebutton="false">
                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Url Generator</h2>
                    </header>


                    <div>
                        <div class="widget-body no-padding">
                            <center>
                            <table class="table" style="width: 90%;">
                                <tr>
                                    <td><label><b>Filter Category:</b></label></td>
                                    <td><label><b>Filter Name:</b></label></td>
                                    <td><label><b>Actions</b></label></td>
                                </tr>
                                <tr>
                                    <td><input type="text" name="categorySearch" id="categorySearch" class="form-control text-center" ></td>
                                    <td><input type="text" name="filterName" id="filterName" class="form-control text-center" ></td>
                                    <td><button type="button" class="btn btn-block btn-primary" onclick="generateB2Burl();">Generate Link</button> </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <div id="urlResult" style="margin-top:20px;display: none;">

                                        </div>
                                    </td>
                                </tr>
                            </table>
                            </center>

                        </div>
                    </div>





                </div>
            </div>
            <!-- end row -->

        </section>

        <!-- NEW WIDGET START -->


</div>





<script type="text/javascript">


    function generateB2Burl(){
        var categorySearch = $("#categorySearch").select2("val");
        var filterName = $("#filterName").val();

        if(filterName == null || filterName == ""){
            $.smallBox({
                title: "Error",
                content: "Please enter filter name",
                color: "#C46A69",
                iconSmall: "fa fa-times",
                timeout: 4000
            });
            return;
        }

        $.ajax({
            type: "POST",
            url: "./concc/generate_filter_url.php",
            data: {
                categorySearch: categorySearch,
                filterName: filterName
            },
            success: function(data){
                $("#urlResult").html(data);
                $("#urlResult").show();
            }
        });
    }

    $(document).ready(function() {

        pageSetUp();

        $("#categorySearch").select2({

            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/categorySearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });


    });



</script>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/notification/SmartNotification.min.js"></script>



<!-- include summernote css/js -->
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>