<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity,active FROM B2B_Image_Watermark WHERE watermark_id=1 ");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity,$active);
while ($stm->fetch()) {}
$stm->close();

$transparency = (float)$watermarkOpacity*10;
if($transparency < 1){$transparency = 1;}

$imageTrans = $transparency/10;


if(strcmp($watermarkURL,'')!=0){
    $watermarkImage = basename($watermarkURL);
    $currentWatermark = "<img style='width:100%;height:auto;opacity: $imageTrans;' src='//".HTML_PATH."/cop/b2b/assets/img/$watermarkImage'/>";
} else {
    $stm = $db->prepare("SELECT logo_link FROM B2B_Configuration LIMIT 1 ");
    $stm-> execute();
    $stm-> bind_result($logoLink);
    while ($stm->fetch()) {}
    $stm->close();
    $logoLink = basename($logoLink);
    $currentWatermark = "<img style='width:100%;height:auto;opacity: $imageTrans;' src='//".HTML_PATH."/cop/b2b/assets/img/$logoLink'/>";

}

$activeYes = $cSelected = $brSelected = $trSelected = $tlSelected = $blSelected = '';

if(strcmp($active,'yes')==0){$activeYes = 'selected';}
if(strcmp($watermarkPosition,'center')==0){$cSelected = 'selected';}
if(strcmp($watermarkPosition,'lowerRight')==0){$brSelected = 'selected';}
if(strcmp($watermarkPosition,'lowerLeft')==0){$blSelected = 'selected';}
if(strcmp($watermarkPosition,'upperRight')==0){$trSelected = 'selected';}
if(strcmp($watermarkPosition,'upperLeft')==0){$tlSelected = 'selected';}



?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> B2B Image Watermark</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>B2B Image Watermark</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                                <form id="brandForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                                <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                    <section>
                                                        <label class="label-bold align-left">Active: </label>
                                                        <select class="form-control text-center" id="active">
                                                            <option value="no" >No</option>
                                                            <option value="yes" <?php echo $activeYes; ?>>Yes</option>
                                                        </select>
                                                    </section>
                                                    <section>
                                                        <label class="label-bold align-left">Watermark Position: </label>
                                                        <select class="form-control text-center" id="position">
                                                            <option value="lowerRight" <?php echo $brSelected; ?>>Bottom Right</option>
                                                            <option value="lowerLeft" <?php echo $blSelected; ?>>Bottom Left</option>
                                                            <option value="upperRight" <?php echo $trSelected; ?>>Top Right</option>
                                                            <option value="upperLeft" <?php echo $tlSelected; ?>>Top Left</option>
                                                            <option value="center" <?php echo $cSelected; ?>>Center</option>

                                                        </select>
                                                    </section>
                                                    <section>
                                                        <label class="label-bold align-left">Watermark Transparency (1 - 10): </label>
                                                        <input type="number" class="form-control text-center"  id="transparency" value="<?php echo $transparency?>" min="1" max="10"/>
                                                    </section>
                                                </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                <label class="label-bold  align-left">Current Watermark</label>
                                            </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="background-color: silver;">
                                                <center>
                                                <?php echo $currentWatermark?>
                                                </center>
                                            </section>
                                        </div>
                                    </fieldset>
                                </form>

                                <label class="label-bold  align-left">Change Watermark</label>
                                <form  style="margin-top:10px;height:120px;min-height: 0px !important;width: 100%;"  enctype= "multipart/form-data" class="dropzone" id="brandpostdropzone"></form>
                                <footer>
                                    <input type="button" id="watermarkSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:150px;" value="Save Watermark">
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->
            </article>

        </div>
        <!-- end row -->
    </div>






</div>




<script src="./js/plugin/dropzone/dropzone.min.js"></script>
<!-- include summernote css/js -->
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>


<script type="text/javascript">

    //........................................

    function savePost() {

        var transparency  = $('#transparency').val();
        var active        = $('#active').val();
        var position      = $('#position').val();



        if(true) {

            $.ajax({
                type: 'POST',
                url: './concc/updateWatermark.php',
                dataType: 'html',
                data: {
                    'transparency': transparency,
                    'active': active,
                    'position': position

                },
                success: function (result) {


                    $.smallBox({
                        title: 'Success!',
                        content: "Watermark Successfully Saved",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                }
            });
        }
      setTimeout(function(){location.reload();}, 1000);
    }

    // End of SavePost()



    $(document).ready(function() {

        pageSetUp();

        Dropzone.autoDiscover = false;
        var acceptedFileTypesCRMPost ="*";


        $("#brandpostdropzone").dropzone({
            url: "./concc/updateWatermark.php",
            maxFiles: 1,
            addRemoveLinks : true,
            maxFileSize: 10,
            dictResponseError: 'Error uploading file!',
            autoProcessQueue:false,
            uploadMultiple: true,
            paramName: 'wmFile',
            acceptedFiles: ".png,.jpg,.gif,.bmp,.jpeg",

            init: function() {

                var thisDropzone = this;
                
                dzClosure = this; // Makes sure that 'this' is understood inside the functions below.

                // for Dropzone to process the queue (instead of default form behavior):
                document.getElementById("watermarkSubmit").addEventListener("click", function(e) {
                    // Make sure that the form isn't actually being sent.
                    e.preventDefault();
                    e.stopPropagation();

                    if (dzClosure.getQueuedFiles().length > 0) {
                        dzClosure.processQueue();
                        setTimeout(function(){location.reload();}, 1000);
                    } else {
                        savePost();
                    }
                });


                //send all the form data along with the files:
                this.on("sendingmultiple", function(data, xhr, formData) {

                    formData.append("transparency"   , $('#transparency').val());
                    formData.append("active", $("#active").val());
                    formData.append("position" , $("#position").val());



                });

                this.on("success", function(file, responseText) {
                    this.removeAllFiles(true);

                    $.smallBox({
                        title: "Success!",
                        content: "Watermark successfully Saved",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });

                });

            },
            removedfile: function(file) {

                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }
        }).get(0).dropzone.on("addedfile", function(file)
        {

        });






    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



