<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}


$sitemapURL = '';
$customDomain = '';
$htmlPath = HTML_PATH;

if(file_exists(ROOT.'b2b/sitemapdomain.txt')){
    $domain = file_get_contents(ROOT.'b2b/sitemapdomain.txt');
    $subDirectory = explode('/cop',str_replace($_SERVER['DOCUMENT_ROOT'],'' ,__DIR__ ))[0];
    if(strcmp("$domain","") != 0){
        $htmlPath = $domain.$subDirectory;
        $customDomain = $domain;
    }
}

if(file_exists(ROOT.'b2b/sitemap.xml')){
    $sitemapURL = "https://$htmlPath/cop/b2b/sitemap.xml";
    $fileExists = true;
} else {
    $fileExists = false;
}

?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Sitemap XML</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Sitemap XML</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                                <form id="brandForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                                <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                    <section>
                                                        <table style="width: 100%;">
                                                            <tr>
                                                                <td style="width: 1%;white-space: nowrap;">
                                                                    <label class="label-bold align-left">Custom Domain (optional) &nbsp;</label>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control text-center"  id="domain" name="domain" value="<?php echo "$customDomain";?>" placeholder="Add Custom Domain (optional)"/>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </section>
                                                </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                <table  style="width: 100%;">
                                                    <tr>
                                                        <td style="width: 1%;white-space: nowrap;">
                                                            <label class="label-bold align-left">Sitemap URL &nbsp;</label>
                                                        </td>
                                                        <td style="width: 98%">
                                                            <input class="form-control text-center" id="sitemapURL" value="<?php echo $sitemapURL; ?>" style="cursor: text;border-right: 0px;" disabled readonly>
                                                        </td>
                                                        <td style="width: 1%;white-space: nowrap;">
                                                            <a href="<?php echo $sitemapURL; ?>" id="sitemapHref" target="_blank" class="btn"  style="font-weight:400;font-size:15px;padding: 5.5px 10px;margin-right: 3px;border: 1px solid #cccccc;border-left: 0px;ba" title="view"><i class="fa fa-file"></i></a>
                                                        </td>
                                                        <td style="width: 1%;white-space: nowrap;">
                                                            <button type="button" id="generateSitemap" class="btn btn-primary" onclick="generateSitemapXml()"  style="font-weight:400;font-size:15px;padding: 5.5px 10px;"><?php if($fileExists){echo "Refresh";} else {echo "Generate";}?> Sitemap.xml</button>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                <div id="itemsCounterElement">
                                                </div>
                                            </section>
                                        </div>
                                    </fieldset>
                                </form>

                                <footer>

                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->
            </article>

        </div>
        <!-- end row -->
    </div>

</div>




<script type="text/javascript">


    function generateSitemapXml(){
        var domain = $('#domain').val();
        $('#generateSitemap').html('Generating...').prop('disabled', true);
        $.ajax({
            url: 'concc/generate_xml_site_map.php',
            type: 'POST',
            data: {domain: domain},
            dataType: 'json',
            success: function(data){
                if(data.status == 'success'){
                    $('#sitemapURL').val(data.file);
                    $('#generateSitemap').html('Refresh Sitemap.xml').prop('disabled', false);
                    $('#sitemapURL').val(data.file);
                    $('#sitemapHref').attr('href',data.file);
                    $('#itemsCounterElement').html('<center><label class="label-bold align-left">Items in Sitemap: '+data.items+'</label></center>');
                    $.smallBox({
                        title: "Success",
                        content: "Sitemap generated successfully",
                        color: "#739E73",
                        iconSmall: "fa fa-check bounce animated",
                        timeout: 4000
                    });
                } else {
                    $('#generateSitemap').html('Refresh Sitemap.xml').prop('disabled', false);
                    $.smallBox({
                        title: "Error",
                        content: "Sitemap could not be generated",
                        color: "#C46A69",
                        iconSmall: "fa fa-times bounce animated",
                        timeout: 4000
                    });
                }
            }
        });
    }


    $(document).ready(function() {

        pageSetUp();

    });
</script>




