<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>

        <!--breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Home / B2B / Web Analytics Settings</li>
        </ol>
        <!--end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-bar-chart-o"></i>
                    Web Analytics Settings
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons">
                    <span> <button id="saveButton" onclick="saveSettings();" class="btn btn-success btn-block">
                        <i class="fa fa-check"></i>&nbsp; Save Settings</button>
                    </span>
                </span>
            </div>
        </div>

        <!-- NEW WIDGET START -->
        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            <!-- row -->
            <div class="row">
                <!-- new widget -->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Web Analytics Settings</h2>
                    </header>

                    <div class="widget-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <form id="analyticsForm" method="post" class="smart-form" enctype="multipart/form-data">
                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>

                                        <section class="col-sm-5">
                                                <section>
                                                    <table style="width: 100%">
                                                        <tr>
                                                            <td style="width: 50%;"><div align="left"> <label class="label-bold align-left">Enable </label></div></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 50%;"><div align="left"> <label class="label-bold align-left">Google Analytics ID: </label></div></td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input type="text" id="googleAuthID" name="googleAuthID" class="form-control" required>

                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>

                                                <section>
                                                    <h3>Analytics Options</h3>
                                                    <hr>
                                                </section>
                                                <section>

                                                    <label class="form-check-label  label-bold "><input type="checkbox" class="checkmark" style="width:13px;height:13px;" name="analytics_options[]" value="login">&nbsp; Login<span class="cop-switch-slider"></span></label><br>
                                                    <label class="form-check-label label-bold "><input type="checkbox" style="width:13px;height:13px;" name="analytics_options[]" value="checkout">&nbsp; Checkout<span class="cop-switch-slider"></span></label><br>
                                                    <label class="form-check-label label-bold "><input type="checkbox" style="width:13px;height:13px;" name="analytics_options[]" value="new_customers"> &nbsp;New Customers<span class="cop-switch-slider"></span></label><br>
                                                    <label class="form-check-label label-bold "><input type="checkbox" style="width:13px;height:13px;" name="analytics_options[]" value="page_views"> &nbsp;Page Views<span class="cop-switch-slider"></span></label><br>
                                                    <label class="form-check-label label-bold "><input type="checkbox" style="width:13px;height:13px;" name="analytics_options[]" value="sales"> &nbsp;Sales<span class="cop-switch-slider"></span></label><br>
                                                    <label class="form-check-label label-bold "><input type="checkbox" style="width:13px;height:13px;" name="analytics_options[]" value="product_views">&nbsp; Product Views<span class="cop-switch-slider"></span></label><br>
                                                    <label class="form-check-label label-bold "><input type="checkbox" style="width:13px;height:13px;"  name="analytics_options[]" value="cart_additions"> &nbsp;Cart Additions<span class="cop-switch-slider"></span></label><br>
                                                </section>
                                            </section>
                                    </fieldset>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!--end widget div -->
                </div>
                <!--end widget -->
            </div>
        </article>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        pageSetUp();

    });

    function saveSettings() {
        var googleAuthID = $("#googleAuthID").val();
        var analytics_options = [];
        $("input[name='analytics_options[]']:checked").each(function() {
            analytics_options.push($(this).val());
        });

        $.ajax({
            type: 'POST',
            url: './concc/edit_web_analytics_settings.php',
            data: {
                'googleAuthID': googleAuthID,
                'analytics_options': analytics_options
            },
            success: function(result) {
                $.smallBox({
                    title: "Success!",
                    content: "Settings successfully saved",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-gift swing animated"
                });
            }
        });
    }
</script>