<?php
include_once('../../../../param.php');

$contractScheduleID = intval($_POST['contractScheduleID']);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm =$db->prepare("SELECT contract_schedule_id,contract_id, service_call_id, contract_type_id, assign_salesperson_id,referred_salespersons, type_of_schedule, start_date, start_time, end_time, days, months, days_of_month, last_run_date, next_run_date, details, schedule_status,service_call_type_id, timestamp FROM Contract_Schedules WHERE contract_schedule_id = ? LIMIT 1");
$stm->bind_param('i',$contractScheduleID);
$stm-> execute();
$stm-> bind_result($contract_schedule_id,$contract_id, $service_call_id, $contract_type_id, $assign_salesperson_id,$referred_salespersons, $type_of_schedule, $start_date, $start_time, $end_time, $days, $months, $days_of_month, $last_run_date, $next_run_date, $details, $schedule_status,$scTypeID, $timestamp);
while ($stm->fetch()) {}
$stm-> close();

$contractSchedule = new stdClass();

if($contract_schedule_id == 0){
    $contractSchedule->status = 0;
    $contractSchedule->error = "Contract Schedule not found";
} else {

    $start_time = date_format(date_create($start_time),"H:i");
    $end_time = date_format(date_create($end_time),"H:i");

    if(strcmp("$last_run_date","0000-00-00 00:00:00")==0){
        $last_run_date_display = "-";
    } else {
        $last_run_date_display = date_format(date_create($last_run_date),"d/m/Y");
    }

    if(strcmp("$next_run_date","0000-00-00 00:00:00")==0){
        $next_run_date_display = "-";
    } else {
        $next_run_date_display = date_format(date_create($next_run_date),"d/m/Y");
    }

    if(strcmp("$timestamp","0000-00-00 00:00:00")==0){
        $timestamp_display = "-";
    } else {
        $timestamp_display = date_format(date_create($timestamp),"d/m/Y");
    }

    $contractSchedule->contractScheduleID = "$contract_schedule_id";
    $contractSchedule->contractID = $contract_id;
    $contractSchedule->serviceCallID = $service_call_id;
    $contractSchedule->contractTypeID = $contract_type_id;
    $contractSchedule->assignSalespersonID = $assign_salesperson_id;
    $contractSchedule->typeOfSchedule = $type_of_schedule;
    $contractSchedule->scheduleStartDate = $start_date;
    $contractSchedule->startTime = $start_time;
    $contractSchedule->endTime = $end_time;
    $contractSchedule->scheduleDays = explode(',',$days);
    $contractSchedule->scheduleMonths = explode(',',$months);
    $contractSchedule->scheduleDaysOfMonth = explode(',',$days_of_month);
    $contractSchedule->scheduleLastExecutionDate = $last_run_date;
    $contractSchedule->scheduleNextExecutionDate = $next_run_date;
    $contractSchedule->scheduleLastExecutionDateDisplay = $last_run_date_display;
    $contractSchedule->scheduleNextExecutionDateDisplay = $next_run_date_display;
    $contractSchedule->scheduleName = $details;
    $contractSchedule->scheduleStatus = $schedule_status;
    $contractSchedule->scTypeID = $scTypeID;
    $contractSchedule->referred = explode(',',$referred_salespersons);
    $contractSchedule->status = 1;
    $contractSchedule->error = '';
    $contractSchedule->timestamp = $timestamp_display;
}

echo json_encode($contractSchedule);
?>

