<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */




include_once('../../../../param.php');

$menuID = intval(trim($_GET['menuID']));
$showAll = intval(trim($_GET['showAll']));


global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$adminID = $_SESSION['adminID'];
$masterUser = false;
$stm = $db->prepare("SELECT master_user FROM Admin  WHERE id='$adminID'");
$stm->execute();
$stm->bind_result($isMaster);
while ($stm->fetch()) {
    if(strcmp(strtolower($isMaster),'yes')==0){
        $masterUser = true;
    }
}
$stm->close();

// DB table to use
$table = 'Admin';

// Table's primary key
$primaryKey = "id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

   array(
        'db' => '`a`.`username`', 
        'dt' => 'icon',
        'formatter' => function( $d, $row ) {
             if($row['coprime_user']=="yes"){
               return '<b>COP</b>';
             }else{
                return '<i class="fa fa-user"></i>';

                 
             }
        },
        'field' => 'username'
    ),
    
       array(
        'db' => '`a`.`username`', 
        'dt' => 'username',
        'field' => 'username'
    ),
      
    array(
        'db' => '`a`.`coprime_user`', 
        'dt' => 'coprime_user',
        'field' => 'coprime_user'
    ),
      
 
    array(
        'db' => 'CONCAT(`s`.`first_name`, " ", `s`.`last_name`, " - ", `s`.`salesperson_code`, " (", `a`.`user_group`, " ", s.type, ")")',
        'dt' => 'user_info',
        'formatter' => function( $d, $row ) {
            if($row['coprime_user']=="yes"){
                return "Coprime User";
                
            }else{
                return $d;
            }
        },
        
        'field' => 'user_info',
        'as' =>'user_info'
    )


    
    , array(
    'db' => '`a`.`id`',
    'dt' => 'form',
    'formatter' => function($d, $row) use($db,$menuID) {
       
        
        
        $stm = $db->prepare("SELECT menu_id FROM ZC_Menu_user WHERE user_id = ? LIMIT 1");
        $stm->bind_param("i", $d);
        $stm->execute();
        $stm->bind_result($userMenuID);
        $stm->fetch();
        $stm->close();
        
        if(empty($userMenuID)){
            return '<button id="action-btn-'.$d.'" class="btn btn-success" onclick="addUserToMenu('. $menuID.','.$d.')" style="width:100px">Add</button> ';
        }
        else if(intval($userMenuID) ==$menuID){
            return '<button id="action-btn-'.$d.'" class="btn btn-danger" onclick="removeUserFromMenu('.$menuID.','. $d.')" style="width:100px">Remove</button> ';
        } else {
            
            $stm = $db->prepare("SELECT menu_name FROM ZC_Menu WHERE menu_id = ? LIMIT 1");
            $stm->bind_param("i", $userMenuID);
            $stm->execute();
            $stm->bind_result($menuName);
            $stm->fetch();
            $stm->close();
            
            $result  = "<h6><b>$menuName Menu</b></h6>";
            // $result .= '<button id="action-btn-'.$d.'" class="btn btn-primary" onclick="changeUserMenu('.$menuID.','. $d.')" >Switch to This Menu</button> ';
             
             return $result;
        }

    },
    'field' => 'id'
    )

 
    
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Admin` AS `a` LEFT JOIN `SalesPersons` AS `s` ON (`s`.`salesperson_id`=`a`.`id`)";  
$where = ''; // Add any specific where clauses if needed
if ($showAll == 0) {
    $joinQuery .= " INNER JOIN `ZC_Menu_user` AS `mu` ON `mu`.`user_id` = `a`.`id` AND `mu`.`menu_id` = $menuID";
}
if($masterUser==false){
    $where=" NOT `a`.coprime_user='yes' ";
}


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
