<?php
// List of events

include_once("../../../../param.php");
require(ROOT . "concc/dbhelpers/dbhelper.php");

if(isset($_GET['dateSelect'])){
    $date = trim($_GET['dateSelect']);
    $where="WHERE Service_Call.customer_id=Customers.customer_id AND Service_Call.type_id= SC_Types.type_id AND DATE(schedule_start_date)='$date' AND schedule_start_date<=schedule_end_date";
} else {
    $where="WHERE Service_Call.customer_id=Customers.customer_id AND Service_Call.type_id= SC_Types.type_id AND DATE(schedule_start_date)=CURDATE() AND schedule_start_date<=schedule_end_date";

}

// $where="WHERE Service_Call.customer_id=Customers.customer_id AND Service_Call.type_id= SC_Types.type_id AND schedule_start_date>'0000-00-00 00:00:00' AND schedule_end_date>'0000-00-00 00:00:00' AND schedule_start_date<=schedule_end_date";



if(isset($_GET['typeSelect']))
{
    $types=$_GET['typeSelect'];

    if(strcmp($types,"")!=0)
    {
        $where=$where." AND SC_Types.type_id IN($types)";
    }
}


if(isset($_GET['userSelect']))
{
    $users=$_GET['userSelect'];

    if(strcmp($users,"")!=0)
    {
        $where=$where." AND Service_Call.assign_to IN($users)";
    }
}


if(isset($_GET['prioritySelect']))
{
    $priorities=$_GET['prioritySelect'];

    if(strcmp($priorities,"")!=0)
    {
        $where=$where." AND Service_Call.priority_id IN($priorities)";
    }
}


if(isset($_GET['statusSelect']))
{
    $statuses=$_GET['statusSelect'];

    if(strcmp($statuses,"")!=0)
    {
        $where=$where." AND Service_Call.status_id IN($statuses)";
    }
}

$objects = array();

// Query that retrieves events
$request = "SELECT service_call_id,service_call_code,topic,schedule_start_date,schedule_end_date,customer_company_name,type_name,priority_id,status_id,Customers.customer_id,Service_Call.details FROM Service_Call,Customers,SC_Types $where ORDER BY service_call_id";


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stmt = $db->prepare($request);
$stmt->execute();
$stmt->bind_result($serviceCallID,$serviceCallCode,$serviceCallTitle,$serviceCallDate,$serviceCallDateDue,$customerName,$type,$priorityID,$statusID,$customerID,$details);
while ($stmt->fetch()) {
    $serviceCallTitle=str_replace("'","",$serviceCallTitle);
    $serviceCallTitle=str_replace("\"","",$serviceCallTitle);
    $customerName=str_replace("'","",$customerName);
    $customerName=str_replace("\"","",$customerName);
    $object =  new \stdClass();
    $object->id = $serviceCallID;
    if($customerID == 1){
        $object->title = $details;
        $object->calendarnotes = true;
    } else {
        $object->title = $customerName." ".$serviceCallCode;
        $object->calendarnotes = false;
    }
    $object->start = $serviceCallDate;
    $object->end = $serviceCallDateDue;
    $object->status = $statusID;

    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $serviceCallDate);
    $firstDate = $myDateTime->format('Y-m-d');


    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $serviceCallDateDue);
    $secondDate = $myDateTime->format('Y-m-d');

    if (strcmp($firstDate,$secondDate)!=0) {

        $object->allDay=true;

    }



    if($statusID == 1)
    {
        $object->color = "#4682B4";
    }
    else if($statusID == 2)
    {
        $object->color = "#4682B4";
    }
    else if($statusID == 3)
    {
        $object->color = "#b22222";
    }
    else if($statusID == 4)
    {
        $object->color = "#bf8900";
    }
    else if($statusID == 5)
    {
        $object->color = "#008080";
    }
    else if($statusID == 6)
    {
        $object->color = "#00910f";
    }
    else if($statusID == 7)
    {
        $object->color = "#878787";
    }
    else if($statusID == 9)
    {
        $object->color = "goldenrod";
    }
    else
    {
        $object->color = "#4682B4";
    }


    array_push($objects,$object);

}

$stmt->close();



// sending the encoded result to success page
echo json_encode($objects);

?>
