<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'ChartOfAccounts';

// Table's primary key
$primaryKey = "account_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => " c.account_code",
        'dt' => 'accountCode',
        'field' => 'account_code'
    ),
    array(
        'db' => " c.account_name",
        'dt' => 'accountName',
        'field' => 'account_name'
    ),
    array(
        'db' => 'a.account_type_name',
        'dt' => 'type',
        'field' => 'account_type_name'
    ),
    array(
        'db' => 'c.local_currency_id',
        'dt' => 'currency',
        'field' => 'local_currency_id'
    ),
    array(
        'db' => 'c.timestamp',
        'dt' => 'timestamp',
        'field' => 'timestamp'
    )


);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM ChartOfAccounts AS c 
                LEFT JOIN AccountTypes AS a ON c.type_id = a.account_type_id";
$where = '';


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
