<?php
include_once("../../../../param.php");
$edit=false;
if(isset($_POST['erpConnectionID']))
{

    $erpID=$_POST['erpConnectionID'];
    $edit=true;
}

$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare(" SELECT erp_connection_id, erp_host, erp_port, erp_username, erp_identifier, erp_database, erp_instance, erp_error_mail, erp_name, erp_active, timestamp FROM ERP_Connection WHERE erp_connection_id=?");
$stm->bind_param("i",$erpID);
$stm->execute();
$stm-> bind_result($erpConnectionID, $erpHost, $erpPort, $erpUsername, $erpIdentifier, $erpDatabase, $erpInstance, $erpErrorMail, $erpName, $erpActive, $timestamp);
while ($stm->fetch()) {
}

$stm-> close();


?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / <?php if($edit){echo "Edit";}else{echo "New";}?> ERP Connection</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-refresh"></i>
                    <?php if($edit){echo "Edit";}else{echo "New";}?>  ERP Connection
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span ><a  onclick="saveERPConnection();" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; Save ERP Connection</a> </span>
            </div>


        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <div class="row">

                <!-- NEW WIDGET START -->
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark no-margin" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2><?php if($edit){echo "Edit";}else{echo "New";}?> ERP Form</h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <form action="" id="checkout-form" class="smart-form">
                                    <fieldset>
                                        <div class="row">
                                            <section class="col col-6 no-margin" style="border-right:1px dotted #ADD8E6;padding-right:2px" >
                                                <section>
                                                    <i class="fa-fw fa fa-refresh fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">Connection Details</h3>
                                                </section>
                                                <table id="basicDetailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead >
                                                    </thead>
                                                    <tbody >
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold  align-left">ERP Name: </label></td>
                                                        <td class="custom-td-input"><input  class='text-center form-control ' id='erpName' name='erpName' type='text' value="<?php if($edit){echo "$erpName";} ?>"></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  align-left">ERP Host: </label></td>
                                                        <td class="custom-td-input"><input  class='text-center form-control ' id='erpHost' name='erpHost' type='text' value="<?php if($edit){echo "$erpHost";} ?>"></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  align-left">ERP Port: </label></td>
                                                        <td class="custom-td-input"><input  class='text-center form-control ' id='erpPort' name='erpPort' type='number' value="<?php if($edit){echo "$erpPort";} ?>"></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  align-left">Username: </label></td>
                                                        <td class="custom-td-input"><input  class='text-center form-control ' id='erpUsername' name='erpUsername' type='text' value="<?php if($edit){echo "$erpUsername";} ?>"></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  align-left">Identifier: </label></td>
                                                        <td class="custom-td-input"><input  class='text-center form-control ' id='identifier' name='identifier' type='text' value="<?php if($edit){echo "$erpIdentifier";} ?>"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </section>
                                            <section class="col col-6 no-margin" style="border-left:1px dotted #ADD8E6;padding-right:2px;">
                                                <section>
                                                    <i class="fa-fw fa fa-info fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">Configuration Details</h3>
                                                </section>
                                                <section>
                                                    <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                        <thead >
                                                        </thead>
                                                        <tbody>

                                                        <tr >
                                                            <td class="custom-td-label"><label class="label-bold  align-left">Database: </label></td>
                                                            <td class="custom-td-input"><input  class='text-center form-control ' id='database' name='database' type='text' value="<?php if($edit){echo "$erpDatabase";} ?>"></td>
                                                        </tr>
                                                        <tr >
                                                            <td class="custom-td-label"><label class="label-bold  align-left">Instance: </label></td>
                                                            <td class="custom-td-input"><input  class='text-center form-control ' id='instance' name='instance' type='text' value="<?php if($edit){echo "$erpInstance";} ?>"></td>
                                                        </tr>
                                                        <tr >
                                                            <td class="custom-td-label"><label class="label-bold  align-left">Error Email: </label></td>
                                                            <td class="custom-td-input"><input  class='text-center form-control ' id='errorEmail' name='errorEmail' type='text' value="<?php if($edit){echo "$erpErrorMail";} ?>"></td>
                                                        </tr>
                                                        <tr >
                                                            <td class="custom-td-label"><label class="label-bold  align-left">Active: </label></td>
                                                            <td class="custom-td-input">
                                                                <select class="text-center form-control" id="erpActive" name="erpActive">
                                                                    <option value="yes" <?php if($edit && strtolower($erpActive)=='yes') echo "selected"; ?>>yes</option>
                                                                    <option value="no" <?php if($edit && strtolower($erpActive)!='yes') echo "selected"; ?>>no</option>
                                                                </select>
                                                            </td>
                                                        </tr>

                                                        </tbody>
                                                    </table>
                                                </section>
                                            </section>
                                    </fieldset>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

            </div>

            <!-- end row -->





        </section>
    </div>
</div>

<script type="text/javascript">

    function saveERPConnection(){

        var erpConnectionID= "<?php echo $erpConnectionID;?>";
        var erpName = $('#erpName').val();
        var erpHost = $('#erpHost').val();
        var erpPort = $('#erpPort').val();
        var erpUsername = $('#erpUsername').val();
        var identifier = $('#identifier').val();
        var database = $('#database').val();
        var instance = $('#instance').val();
        var errorEmail = $('#errorEmail').val();
        var erpActive = $('#erpActive').val();
        $.ajax({
            type: "POST",
            <?php
            if($edit){
                echo " url: '//" . HTML_PATH . "/cop/backend/modules/erpConnection/controllers/edit_erp_connection.php',";
            } else {
                echo " url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_erp_connection.php',";
            }
            ?>
            data: {
                'erpConnectionID': erpConnectionID,
                'erpName': erpName,
                'erpHost': erpHost,
                'erpPort': erpPort,
                'erpUsername': erpUsername,
                'identifier': identifier,
                'database': database,
                'instance': instance,
                'errorEmail': errorEmail,
                'erpActive': erpActive
            },
            success: function (result) {

                $.smallBox({
                    title : "Success!",
                    content : "ERP successfully entered",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-check swing animated"
                });
                window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/modules/erpConnection/views/manage_erp_connections.php");

            }
        });
    }

    $(document).ready(function() {

        pageSetUp();

    });



</script>


