<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">SAP B1 API Tester</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-8 col-lg-10">
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa fa-info"></i>
                    &nbsp; SAP Tester
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-2">
                    <button id="infoIcon" class="pull-right btn btn-primary btn-block" onclick="$('#infoModal').modal('show');">  <i class="fa fa-info"> </i> &nbsp; Info</button>

            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2> Form</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <section class="col-lg-6   col-md-6 col-12 no-margin" style="padding-right:2px">

                                    <section>
                                        <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Test Connection</h3>
                                    </section>
                                    <table class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                        <td class="custom-td-label"> <button id="testConnection" class="btn btn-primary"> Connect </button></td>
                                        <p id="connectionStatus"></p>
                                    </table>
                                    <br>

                                    <section>
                                        <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Send API Request</h3>
                                    </section>
                                    <table class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                        <tr >

                                            <td class="custom-td-label"> <label style="display: block; margin-top: 10px;font-weight:bold">Choose API Call:</label></td>
                                            <td class="custom-td-input">
                                                <select id="apiCall" class="form-control text-center" >
                                                    <option value="Items">Items</option>
                                                    <option value="Orders">Orders</option>
                                                    <option value="SalesPersons">SalesPersons</option>
                                                    <option value="Invoices">Invoices</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr >
                                            <td class="custom-td-label"><label style="display: block; margin-top: 10px;font-weight:bold">Filter:</label></td>
                                            <td class="custom-td-input">   <textarea type="textarea" class="form-control text-center" id="filter" placeholder="DocTotal gt 3000"></textarea>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="custom-td-label"><label style="display: block; margin-top: 10px;font-weight:bold">Top:</label></td>
                                            <td class="custom-td-input">   <input type="number"   class="form-control text-center"  id="topSAP"></td>
                                        </tr>
                                        <tr>
                                            <td class="custom-td-label"><label style="display: block; margin-top: 10px;font-weight:bold">Skip:</label></td>
                                            <td class="custom-td-input">   <input type="number"   class="form-control text-center"  id="skipSAP"></td>
                                        </tr>
                                        <tr>
                                            <td class="custom-td-label"><label style="display: block; margin-top: 10px;font-weight:bold">Select:</label></td>
                                            <td class="custom-td-input">   <input type="text"   class="form-control text-center"  id="selectSAP" placeholder="DocEntry, DocTotal"></td>
                                        </tr>
                                        <tr>
                                            <td class="custom-td-label"><label style="display: block; margin-top: 10px;font-weight:bold">Order By:</label></td>
                                            <td class="custom-td-input">   <input type="text"   class="form-control text-center"  id="orderBySAP" placeholder="DocTotal asc, DocEntry desc"></td>
                                        </tr>
                                        <tr>
                                            <td class="custom-td-label"><button style="margin-top: 10px;width:40%" id="sendRequest" class="btn btn-success">Send Request</button></td>
                                            <td></td>
                                        </tr>
                                    </table>
                                    <br>

                                </section>


                                <section class="col-lg-6   col-md-6 col-12 no-margin" style="padding-right:2px">
                                    <section>
                                        <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Response:</h3>
                                    </section>
                                    <br>
                                    <pre id="responseSAP"></pre>
                                </section>



                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->


                </article>
                <!-- NEW WIDGET END -->


            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>



<!-- info modal -->
<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" >
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <center>


                    <h4 style="text-align: center"><b>Filter Functions and Operators</b></h4>
                </center>
            </div>
            <div class="modal-body">
                <input class="form-control text-center" type="hidden" id="xReplaceID">


                <table class="table" width="100%" border="1" cellpadding="0" cellspacing="0">
                    <thead>
                    <tr>
                        <th  style="text-align: center">Function/Operator</th>
                        <th style="text-align: center">Description</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>startswith</td>
                        <td>Checks if a string starts with a specified value.</td>
                    </tr>
                    <tr>
                        <td>endswith</td>
                        <td>Checks if a string ends with a specified value.</td>
                    </tr>
                    <tr>
                        <td>contains</td>
                        <td>Checks if a string contains a specified value.</td>
                    </tr>
                    <tr>
                        <td>substringof</td>
                        <td>Checks if a string is a substring of another string.</td>
                    </tr>
                    <tr>
                        <td>and</td>
                        <td>Logical operator for combining multiple conditions.</td>
                    </tr>
                    <tr>
                        <td>or</td>
                        <td>Logical operator for combining multiple conditions.</td>
                    </tr>
                    <tr>
                        <td>le</td>
                        <td>Less than or equal to operator.</td>
                    </tr>
                    <tr>
                        <td>lt</td>
                        <td>Less than operator.</td>
                    </tr>
                    <tr>
                        <td>ge</td>
                        <td>Greater than or equal to operator.</td>
                    </tr>
                    <tr>
                        <td>gt</td>
                        <td>Greater than operator.</td>
                    </tr>
                    <tr>
                        <td>eq</td>
                        <td>Equal to operator.</td>
                    </tr>
                    <tr>
                        <td>ne</td>
                        <td>Not equal to operator.</td>
                    </tr>
                    <tr>
                        <td>not</td>
                        <td>Logical negation operator (supported from version 9.1 patch level 01).</td>
                    </tr>
                    </tbody>
                </table>

                <br>
                <center>
                        <button class="btn btn-secondary" id="closeModal"  onclick = "$('#infoModal').modal('hide');">Close</button>
                </center>
            </div>

        </div>
    </div>
</div>


<style>
    #responseSAP {
        background-color: #f4f4f4;
        border: 1px solid #ccc;
        padding: 10px;
        min-height: 450px;
        max-height: 600px;
        overflow: auto;
        white-space: pre-wrap;
        font-family: monospace;
    }
    .connectionSuccess {
        background-color: #d4edda;
        color: #155724;
        padding: 10px;
        border-radius: 5px;
        border: 1px solid #c3e6cb;
        font-weight: bold;
        font-size: 15px;
    }

    .connectionFailed {
        background-color: #f8d7da;
        color: #721c24;
        padding: 10px;
        border-radius: 5px;
        border: 1px solid #f5c6cb;
        font-weight: bold;
        font-size: 15px;
    }

</style>

<script type="text/javascript">

    $(document).ready(function() {

        $('#testConnection').click(function() {
            $('#testConnection').prop('disabled', true);
            $.ajax({
                url: "//<?php echo HTML_PATH ?>/cop/interface/SapServiceLayer/sapRequestChecker.php",
                type: 'POST',
                data: {
                    'testConnection': true,
                },
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.status === 'success') {
                        $('#connectionStatus').text('Connection successful. Session ID: ' + data.sessionID).removeClass('connectionFailed').addClass('connectionSuccess');
                    } else {
                        $('#connectionStatus').text('Connection failed. ' + data.error).removeClass('connectionSuccess').addClass('connectionFailed');

                    }
                },
                complete: function() {
                    $('#testConnection').prop('disabled', false);
                },
                error: function() {
                    $('#testConnection').prop('disabled', false);
                }
            });

        });

        $('#sendRequest').click(function() {
            var apiCall = $('#apiCall').val();
            var filter = $('#filter').val();
            var top = $('#topSAP').val();
            var skip = $('#skipSAP').val();
            var orderBy = $('#orderBySAP').val();
            var select = $('#selectSAP').val();






            $.ajax({
                url: "//<?php echo HTML_PATH ?>/cop/interface/SapServiceLayer/sapRequestChecker.php",
                type: 'POST',
                data : {
                    'apiCall': apiCall,
                    'filter': filter,
                    'top': top,
                    'skip': skip,
                    'orderBy': orderBy,
                    'select': select
                },
                success: function(response) {
                    $('#responseSAP').html(JSON.stringify(response, null, 2));
                }
            });
        });
    });

</script>