<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
include_once('../../../../param.php');
// DB table to use
$table = 'ChartOfAccounts';

// Table's primary key
$primaryKey = "account_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`c`.`account_id`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
        return '<img class="img-rounded center-canvas" src="//' . HTML_PATH . '/cop/backend/modules/expenses/media/iconExpenses.png"  style="width: 35px !important;"></td>';},
        'field' => 'account_id' ),

    array( 'db' => '`c`.`account_code`', 'dt' =>  'code', 'field' =>'account_code' ),
//    array( 'db' => '`c`.`account_name`', 'dt' => 'name', 'field' => 'account_name' ),

    array( 'db' => '`c`.`account_name`', 'dt' => 'name', 'formatter' => function( $d, $row ) {
        $name = explode("%&ara&%", $d)[0];
        return $name;
			;},
        'field' => 'account_name' ),

    array( 'db' => '`c`.`account_name`', 'dt' => 'arabic', 'formatter' => function( $d, $row ) {
        $name = explode("%&ara&%", $d)[1];
        return $name;
			;},
        'field' => 'account_name' ),

    array( 'db' => '`c`.`account_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {
        return '<form style="display:inline;" target="_blank" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/expenses/views/new_expenses_category.php" method="post">
                    <input type="hidden" class="invoiceID" name="expensesCategoryID" value="'.$d.'">
                    <input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit">
                 </form>
			';},
        'field' => 'account_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

$where = '';
$joinQuery = "FROM `ChartOfAccounts` AS `c`";
$where .= '`c`.type_id=999';
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>